/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProduct;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProductHelper;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProductIndex;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProductIndexData;
import com.gridnine.xtrip.common.model.dict.CarClass;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class CarRentalProductIndexHandler
implements IndexHandler<BookingFile, CarRentalProductIndex> {
    public Class<? extends BaseIndexData<BookingFile, CarRentalProductIndex>> getDataClass() {
        return CarRentalProductIndexData.class;
    }

    public Class<CarRentalProductIndex> getIndexClass() {
        return CarRentalProductIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public void create(EntityContainer<BookingFile> etc, Collection<BaseIndexData<BookingFile, CarRentalProductIndex>> indexes) {
        BookingFile bookingFile = (BookingFile)etc.getEntity();
        for (Reservation reservation : bookingFile.getReservations()) {
            DataAggregator aggregator = new DataAggregator();
            for (BaseProduct baseProduct : reservation.getProducts()) {
                if (!(baseProduct instanceof CarRentalProduct)) continue;
                CarRentalProduct product = (CarRentalProduct)baseProduct;
                CarRentalProductIndexData data = new CarRentalProductIndexData();
                this.updateData(data, aggregator, product);
                data.setAggregatedData(aggregator.toString());
                indexes.add((BaseIndexData<BookingFile, CarRentalProductIndex>)data);
                aggregator.reset();
            }
        }
    }

    protected Organization getOrganization(Reservation reservation) {
        EntityContainer subagencyContainer;
        Organization subagency = null;
        if (reservation.getSubagency() != null && (subagencyContainer = EntityStorage.get().resolve(reservation.getSubagency())) != null) {
            subagency = (Organization)subagencyContainer.getEntity();
        }
        return subagency;
    }

    protected CarClass resolveReference(DictionaryReference<CarClass> classRef) {
        return (CarClass)DictionaryCache.get().resolveReference(classRef);
    }

    private void updateData(CarRentalProductIndexData data, DataAggregator aggregator, CarRentalProduct product) {
        data.setNavigationKey(product.getUid());
        ProductStatus status = product.getStatus();
        data.setStatus(status);
        data.setTicketType(product.getTicketType() != null ? product.getTicketType() : TicketType.OWN);
        data.setIssueDate(product.getIssueDate());
        data.setIssueDateTime(product.getIssueDate());
        data.setSystemNumber(product.getSystemNumber());
        aggregator.aggregate((Object)product.getSystemNumber());
        data.setCarClass(product.getCarClass());
        data.setNumberOfCars(Integer.valueOf(product.getNumberOfCars()));
        data.setCarsSupplier(product.getCarsSupplier());
        data.setCurrencyRate(product.getCurrencyRate());
        data.setStartLocation(product.getStartLocation());
        data.setStartDate(product.getStartDate());
        data.setStartDateTime(product.getStartDate());
        data.setEndLocation(product.getEndLocation());
        data.setEndDate(product.getEndDate());
        data.setEndDateTime(product.getEndDate());
        data.setWithDriver(Boolean.valueOf(product.isWithDriver()));
        EntityReference agency = CarRentalProductHelper.getAgency((CarRentalProduct)product);
        data.setAgency(agency);
        EntityReference subagency = CarRentalProductHelper.getSubagency((CarRentalProduct)product);
        data.setSubagency(subagency);
        data.setBlankOwner(product.getBlankOwner());
        EntityReference supplier = CarRentalProductHelper.getSupplier((CarRentalProduct)product);
        data.setSupplier(supplier);
        data.setSalesPoint(product.getSalesPoint());
        data.setAgent(product.getAgent());
        List travellers = product.getTravellers().stream().map(Traveller::getName).collect(Collectors.toList());
        data.setTravellersNames(travellers);
        aggregator.aggregate(travellers);
        data.setTotalPrice(CarRentalProductHelper.getTotalPrice((CarRentalProduct)product));
        if (product.getEquivalentFare() != null) {
            data.setEquivalentFareCurrency(product.getEquivalentFare().getCurrency());
        }
        data.setPenalty(product.getPenalty());
        boolean refund = status == ProductStatus.REFUND;
        data.setVendorCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)CarRentalProductHelper.getUnmodifiableCommissions((CarRentalProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
        data.setSubagencyCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)CarRentalProductHelper.getUnmodifiableCommissions((CarRentalProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
        data.setSubagencyFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)CarRentalProductHelper.getUnmodifiableCommissions((CarRentalProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund));
        data.setClientFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)CarRentalProductHelper.getUnmodifiableCommissions((CarRentalProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund));
        boolean inFinanceDocuments = IndexBuilderHelper.isInFinanceDocuments((BaseProduct)product);
        data.setInFinanceDocuments(Boolean.valueOf(inFinanceDocuments));
        boolean hasClientDebt = false;
        for (GeneralProductFop fop : CarRentalProductHelper.getClientFops((CarRentalProduct)product)) {
            if (fop.getOperationDate() != null) continue;
            hasClientDebt = true;
            break;
        }
        data.setHasClientDebt(Boolean.valueOf(hasClientDebt));
        data.setChecked(Boolean.valueOf(product.isChecked()));
        data.setCompleted(Boolean.valueOf(product.isCompleted()));
        data.setHasOtherErrors(Boolean.valueOf(false));
        data.setHasErrors(Boolean.valueOf(false));
        for (ValidationMessage message : product.getValidationMessages()) {
            if (message.getSeverity() == ValidationMessageSeverity.USER_ERROR) {
                data.setHasErrors(Boolean.valueOf(true));
            }
            if (message.getSeverity() != ValidationMessageSeverity.ERROR) continue;
            data.setHasErrors(Boolean.valueOf(true));
            if (message.getCategory() != ValidationMessageCategory.OTHER) continue;
            data.setHasOtherErrors(Boolean.valueOf(true));
        }
        if (product.getReservation() != null) {
            data.setDisplayedRecordLocator(CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)product.getReservation()));
            data.setRecordLocators(IndexBuilderHelper.getRecordLocators(product.getReservation()));
            data.setGdsNames(IndexBuilderHelper.getGdsNames(product.getReservation()));
            if (product.getReservation().getBookingFile() != null) {
                String bookingNumber = TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile());
                aggregator.aggregate((Object)bookingNumber);
                data.setBookingNumber(bookingNumber);
                data.setClient(product.getReservation().getBookingFile().getCustomerProfile());
                String notes = product.getReservation().getBookingFile().getNotes();
                data.setHasNotes(Boolean.valueOf(TextUtil.nonBlank((String)notes)));
            }
        }
    }
}

