/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.CardIndex;
import com.gridnine.xtrip.common.model.profile.CardIndexData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;
import java.util.List;

public class CardIndexHandler
implements IndexHandler<BaseProfile, CardIndex> {
    public Class<? extends BaseIndexData<BaseProfile, CardIndex>> getDataClass() {
        return CardIndexData.class;
    }

    public Class<CardIndex> getIndexClass() {
        return CardIndex.class;
    }

    public Class<BaseProfile> getEntityType() {
        return BaseProfile.class;
    }

    public void create(EntityContainer<BaseProfile> etc, Collection<BaseIndexData<BaseProfile, CardIndex>> indexes) throws Exception {
        if (etc.getEntity() instanceof Organization) {
            this.create(((Organization)etc.getEntity()).getCards(), indexes);
        } else if (etc.getEntity() instanceof Person) {
            this.create(((Person)etc.getEntity()).getCards(), indexes);
        }
    }

    private void create(List<Card> cards, Collection<BaseIndexData<BaseProfile, CardIndex>> indexes) {
        DataAggregator aggregator = new DataAggregator();
        for (Card card : cards) {
            CardIndexData data = new CardIndexData();
            data.setNavigationKey(card.getUid());
            if (card.getNumber() != null && card.getNumber().contains("*")) {
                data.setNumber(card.getNumber());
                aggregator.aggregate((Object)card.getNumber());
                aggregator.aggregate((Object)card.getNumber().replaceAll("\\*", "0"));
            }
            data.setVendor(card.getVendor());
            data.setNameOnCard(card.getNameOnCard());
            data.setExpiration(card.getExpiration());
            data.setRemarks(card.getRemarks());
            data.setCirUid(card.getCirUid());
            data.setToRemove(Boolean.valueOf(card.isToRemove()));
            aggregator.aggregate((Enum)card.getVendor());
            aggregator.aggregate((Object)card.getNameOnCard());
            data.setAggregatedData(aggregator.toString());
            indexes.add((BaseIndexData<BaseProfile, CardIndex>)data);
            aggregator.reset();
        }
    }
}

