/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.Cash;
import com.gridnine.xtrip.common.model.profile.CashIndex;
import com.gridnine.xtrip.common.model.profile.CashIndexData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;
import java.util.Optional;

public class CashIndexHandler
implements IndexHandler<Cash, CashIndex> {
    public Class<? extends BaseIndexData<Cash, CashIndex>> getDataClass() {
        return CashIndexData.class;
    }

    public Class<CashIndex> getIndexClass() {
        return CashIndex.class;
    }

    public Class<Cash> getEntityType() {
        return Cash.class;
    }

    public void create(EntityContainer<Cash> etc, Collection<BaseIndexData<Cash, CashIndex>> indexes) {
        CashIndexData data = new CashIndexData();
        DataAggregator aggregator = new DataAggregator();
        this.updateData(etc, data, aggregator);
        data.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<Cash, CashIndex>)data);
    }

    protected void updateData(EntityContainer<Cash> etc, CashIndexData data, DataAggregator aggregator) {
        Cash entity = (Cash)etc.getEntity();
        data.setDisabled(Boolean.valueOf(entity.isDisabled()));
        data.setName(entity.getName());
        data.setOwner(entity.getOwner());
        if (entity.getOwner() != null) {
            if (Organization.class.equals((Object)entity.getOwner().getType())) {
                data.setOrganization(entity.getOwner());
            } else if (SalesPoint.class.equals((Object)entity.getOwner().getType())) {
                data.setOrganization((EntityReference)Optional.ofNullable(EntityStorage.get().resolve(entity.getOwner())).map(item -> ((SalesPoint)item.getEntity()).getAgency()).orElse(null));
            } else if (Branch.class.equals((Object)entity.getOwner().getType())) {
                data.setOrganization((EntityReference)Optional.ofNullable(EntityStorage.get().resolve(entity.getOwner())).map(item -> ((Branch)item.getEntity()).getAgency()).orElse(null));
            }
        }
        aggregator.aggregate((Object)entity.getName());
        aggregator.aggregate((Object)entity.getOwner());
    }
}

