/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.CommissionPropertiesIndex;
import com.gridnine.xtrip.common.model.booking.commission.CommissionPropertiesIndexData;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;

public class CommissionPropertiesIndexHandler
implements IndexHandler<CommissionProperties, CommissionPropertiesIndex> {
    private final Comparator<? super ProductType> productTypesComparator = (a, b) -> a.toString().compareTo(b.toString());

    public Class<? extends BaseIndexData<CommissionProperties, CommissionPropertiesIndex>> getDataClass() {
        return CommissionPropertiesIndexData.class;
    }

    public Class<CommissionPropertiesIndex> getIndexClass() {
        return CommissionPropertiesIndex.class;
    }

    public Class<CommissionProperties> getEntityType() {
        return CommissionProperties.class;
    }

    public void create(EntityContainer<CommissionProperties> etc, Collection<BaseIndexData<CommissionProperties, CommissionPropertiesIndex>> indexes) {
        CommissionPropertiesIndexData data = new CommissionPropertiesIndexData();
        CommissionProperties entity = (CommissionProperties)etc.getEntity();
        data.setCategory(entity.getCategory());
        data.setDisplayName(entity.getDisplayName());
        data.setMinimum(Boolean.valueOf(entity.isMinimum()));
        data.setRate(Boolean.valueOf(entity.isRate()));
        data.setRoundingMode(entity.getRoundingMode());
        data.setRoundingValue(entity.getRoundingValue());
        data.setCalculationBasis(entity.getCalculationBasis());
        data.setDisabled(Boolean.valueOf(entity.isDisabled()));
        ArrayList productTypes = new ArrayList(entity.getProductTypes());
        Collections.sort(productTypes, this.productTypesComparator);
        data.setProductTypes(productTypes);
        DataAggregator aggregator = new DataAggregator();
        aggregator.aggregate((Object)entity.getCategory());
        aggregator.aggregate((Object)entity.getDisplayName());
        data.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<CommissionProperties, CommissionPropertiesIndex>)data);
    }
}

