/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndexData;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;

public class ContractCustomerIndexHandler
implements IndexHandler<Contract, ContractCustomerIndex> {
    public Class<? extends BaseIndexData<Contract, ContractCustomerIndex>> getDataClass() {
        return ContractCustomerIndexData.class;
    }

    public Class<ContractCustomerIndex> getIndexClass() {
        return ContractCustomerIndex.class;
    }

    public Class<Contract> getEntityType() {
        return Contract.class;
    }

    public void create(EntityContainer<Contract> etc, Collection<BaseIndexData<Contract, ContractCustomerIndex>> indexes) {
        Contract entity = (Contract)etc.getEntity();
        for (ContractCustomerInfo info : entity.getCustomers()) {
            ContractCustomerIndexData data = new ContractCustomerIndexData();
            DataAggregator aggregator = new DataAggregator();
            this.fillIndexData(entity, info, data, aggregator);
            data.setAggregatedData(aggregator.toString());
            aggregator.reset();
            indexes.add((BaseIndexData<Contract, ContractCustomerIndex>)data);
        }
    }

    protected void fillIndexData(Contract contract, ContractCustomerInfo info, ContractCustomerIndexData data, DataAggregator aggregator) {
        Organization customer;
        data.setContractType(contract.getContractType());
        data.setName(contract.getName());
        data.setCustomer(info.getCustomer());
        data.setSupplier(contract.getSupplier());
        data.setVendor(contract.getVendor());
        data.setProvider(contract.getProvider());
        data.setContractUid(contract.getUid());
        data.setEndDate(info.getEndDate());
        data.setIssueDate(info.getIssueDate());
        data.setNumber(info.getNumber());
        data.setStartDate(info.getStartDate());
        data.setTourCode(info.getTourCode());
        data.setDisabled(Boolean.valueOf(contract.isDisabled()));
        data.setPaymentCurrency(info.getPaymentCurrency());
        data.setVendorContractType(info.getVendorContractType());
        data.setNewModel(Boolean.valueOf(contract.isNewModel()));
        data.setNavigationKey(info.getUid());
        aggregator.aggregate((Enum)contract.getContractType());
        aggregator.aggregate((Object)contract.getName());
        aggregator.aggregate((Object)contract.getNotes());
        aggregator.aggregate(info.getEndDate());
        aggregator.aggregate(info.getIssueDate());
        aggregator.aggregate((Object)info.getNumber());
        aggregator.aggregate((Object)info.getCustomer());
        aggregator.aggregate(info.getStartDate());
        aggregator.aggregate((Enum)info.getVendorContractType());
        EntityContainer customerCont = EntityStorage.get().resolve(info.getCustomer());
        if (customerCont != null && (customer = (Organization)customerCont.getEntity()) != null) {
            aggregator.aggregate(customer.getShortName());
            aggregator.aggregate(customer.getFullName());
        }
    }
}

