/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Contract2ModelContract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.ContractIndexData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ContractIndexHandler
implements IndexHandler<Contract, ContractIndex> {
    public Class<? extends BaseIndexData<Contract, ContractIndex>> getDataClass() {
        return ContractIndexData.class;
    }

    public Class<ContractIndex> getIndexClass() {
        return ContractIndex.class;
    }

    public Class<Contract> getEntityType() {
        return Contract.class;
    }

    public void create(EntityContainer<Contract> etc, Collection<BaseIndexData<Contract, ContractIndex>> indexes) {
        Contract entity = (Contract)etc.getEntity();
        ContractIndexData data = new ContractIndexData();
        DataAggregator aggregator = new DataAggregator();
        this.fillIndexData(entity, data, aggregator);
        data.setAggregatedData(aggregator.toString());
        aggregator.reset();
        indexes.add((BaseIndexData<Contract, ContractIndex>)data);
    }

    protected void fillIndexData(Contract entity, ContractIndexData data, DataAggregator aggregator) {
        Organization customer;
        data.setPriority(Double.valueOf(entity.getPriority()));
        data.setDisabled(Boolean.valueOf(entity.isDisabled()));
        data.setTypicalContract(Boolean.valueOf(entity.isTypicalContract()));
        data.setContractType(entity.getContractType());
        data.setName(entity.getName());
        data.setSupplier(entity.getSupplier());
        data.setVendor(entity.getVendor());
        data.setAgreementType(entity.getAgreementType());
        data.setDefaultContract(Boolean.valueOf(entity.isDefaultContract()));
        data.setNumber(entity.getNumber());
        data.setCustomer(entity.getCustomer());
        data.setProvider(entity.getProvider());
        data.setTransferProvider(entity.getTransferProvider());
        data.setIssueDate(entity.getIssueDate());
        data.setStartDate(entity.getStartDate());
        data.setEndDate(entity.getEndDate());
        data.setTourCode(entity.getTourCode());
        data.setPaymentCurrency(entity.getPaymentCurrency());
        data.setVendorContractType(entity.getVendorContractType());
        data.setNewModel(Boolean.valueOf(entity.isNewModel()));
        data.setModelContracts((Collection)entity.getModelContracts().stream().map(Contract2ModelContract::getModelContract).collect(Collectors.toList()));
        if (!entity.isNewModel()) {
            ArrayList<String> customerUids = new ArrayList<String>();
            for (ContractCustomerInfo ccInfo : entity.getCustomers()) {
                Organization customer2;
                if (ccInfo.getCustomer() == null) continue;
                customerUids.add(ccInfo.getCustomer().getUid());
                EntityContainer customerCont = EntityStorage.get().resolve(ccInfo.getCustomer());
                if (customerCont == null || (customer2 = (Organization)customerCont.getEntity()) == null) continue;
                aggregator.aggregate(customer2.getShortName());
                aggregator.aggregate(customer2.getFullName());
            }
            data.setCustomerUids(customerUids);
        } else {
            data.setCustomerUids(entity.getCustomer() != null ? Collections.singleton(entity.getCustomer().getUid()) : Collections.emptyList());
        }
        aggregator.aggregate((Enum)entity.getContractType());
        aggregator.aggregate((Enum)entity.getAgreementType());
        aggregator.aggregate((Object)entity.getName());
        aggregator.aggregate((Object)entity.getNotes());
        aggregator.aggregate(entity.getEndDate());
        aggregator.aggregate(entity.getIssueDate());
        aggregator.aggregate((Object)entity.getNumber());
        aggregator.aggregate((Object)entity.getCustomer());
        aggregator.aggregate(entity.getStartDate());
        aggregator.aggregate((Enum)entity.getVendorContractType());
        EntityContainer customerCont = EntityStorage.get().resolve(entity.getCustomer());
        if (customerCont != null && (customer = (Organization)customerCont.getEntity()) != null) {
            aggregator.aggregate(customer.getShortName());
            aggregator.aggregate(customer.getFullName());
        }
    }

    protected Set<String> getNumbers(List<ContractCustomerInfo> ccis) {
        HashSet<String> numbers = new HashSet<String>();
        for (ContractCustomerInfo cci : ccis) {
            if (cci == null) continue;
            numbers.add(cci.getNumber());
        }
        return numbers;
    }
}

