/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.finance.BasePaymentDocument;
import com.gridnine.xtrip.common.model.finance.DebitSlip;
import com.gridnine.xtrip.common.model.finance.DebitSlipIndex;
import com.gridnine.xtrip.common.model.finance.DebitSlipIndexData;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebitSlipIndexHandler
implements IndexHandler<BasePaymentDocument, DebitSlipIndex> {
    Logger log = LoggerFactory.getLogger(this.getClass());

    public Class<? extends BaseIndexData<BasePaymentDocument, DebitSlipIndex>> getDataClass() {
        return DebitSlipIndexData.class;
    }

    public Class<DebitSlipIndex> getIndexClass() {
        return DebitSlipIndex.class;
    }

    public Class<BasePaymentDocument> getEntityType() {
        return BasePaymentDocument.class;
    }

    public void create(EntityContainer<BasePaymentDocument> etc, Collection<BaseIndexData<BasePaymentDocument, DebitSlipIndex>> indexes) {
        if (etc.getEntity() instanceof DebitSlip) {
            DebitSlipIndexData data = new DebitSlipIndexData();
            DataAggregator aggregator = new DataAggregator();
            this.updateData(data, aggregator, (DebitSlip)etc.getEntity());
            data.setAggregatedData(aggregator.toString());
            indexes.add((BaseIndexData<BasePaymentDocument, DebitSlipIndex>)data);
        }
    }

    private void updateData(DebitSlipIndexData data, DataAggregator aggregator, DebitSlip entity) {
        data.setNavigationKey(entity.getUid());
        data.setType(entity.getType());
        aggregator.aggregate((Enum)entity.getType());
        data.setName(entity.getName());
        aggregator.aggregate((Object)entity.getName());
        data.setNumber(TextUtil.buildFullNumber((CompositeNumber)entity));
        aggregator.aggregate((Object)TextUtil.buildFullNumber((CompositeNumber)entity));
        data.setDate(entity.getDate());
        data.setPayer(entity.getPayer());
        aggregator.aggregate((Object)entity.getPayer());
        data.setOrganization(entity.getOrganization());
        aggregator.aggregate((Object)entity.getOrganization());
        data.setPerson(entity.getPerson());
        aggregator.aggregate((Object)entity.getPerson());
        data.setCashier(entity.getCashier());
        aggregator.aggregate((Object)entity.getCashier());
        data.setAmount(entity.getTotalAmount() != null ? entity.getTotalAmount().getValue() : null);
    }
}

