/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductFopIndex;
import com.gridnine.xtrip.common.model.booking.CommonProductFopIndexData;
import com.gridnine.xtrip.common.model.booking.FopType;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.DeliveryHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeliveryCommonProductFopIndexHandler
implements IndexHandler<BookingFile, CommonProductFopIndex> {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public Class<? extends BaseIndexData<BookingFile, CommonProductFopIndex>> getDataClass() {
        return CommonProductFopIndexData.class;
    }

    public Class<CommonProductFopIndex> getIndexClass() {
        return CommonProductFopIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public void create(EntityContainer<BookingFile> bookingFileContainer, Collection<BaseIndexData<BookingFile, CommonProductFopIndex>> datas) {
        for (Reservation reservation : ((BookingFile)bookingFileContainer.getEntity()).getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                if (!(baseProduct instanceof Delivery)) continue;
                Delivery product = (Delivery)baseProduct;
                ProductStatus status = DeliveryHelper.getProductStatus((Delivery)product);
                if (ProductStatusHandler.getAllVoidStatuses().contains(status)) continue;
                this.updateData(datas, product);
            }
        }
    }

    protected void updateData(Collection<BaseIndexData<BookingFile, CommonProductFopIndex>> datas, Delivery product) {
        DataAggregator aggregator = new DataAggregator();
        for (GeneralProductFop fop : product.getClientFops()) {
            CommonProductFopIndexData data = new CommonProductFopIndexData();
            this.updateProductData(data, aggregator, product);
            data.setContractType(ContractType.CLIENT);
            this.updateFopData(data, aggregator, fop, product);
            data.setRefuse(Boolean.valueOf(fop.isRefused()));
            data.setAggregatedData(aggregator.toString());
            aggregator.reset();
            datas.add((BaseIndexData<BookingFile, CommonProductFopIndex>)data);
        }
    }

    protected void updateProductData(CommonProductFopIndexData data, DataAggregator aggregator, Delivery product) {
        data.setProductUid(product.getUid());
        String bookingNumber = TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile());
        data.setBookingNumber(bookingNumber);
        aggregator.aggregate((Object)bookingNumber);
        data.setProductType(ProductType.DELIVERY);
        aggregator.aggregate((Enum)ProductType.DELIVERY);
        data.setClient(product.getReservation().getBookingFile().getCustomerProfile());
        aggregator.aggregate((Object)product.getReservation().getBookingFile().getCustomerProfile());
        data.setBlankOwner(product.getAgency());
        data.setSupplier(product.getAgency());
        data.setAgency(product.getAgency());
        data.setSubagency(product.getAgency());
        aggregator.aggregate((Object)product.getAgency());
        EntityContainer clientContainer = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
        if (clientContainer != null) {
            data.setHolding(((Organization)clientContainer.getEntity()).getHolding());
            aggregator.aggregate((Object)((Organization)clientContainer.getEntity()).getHolding());
        }
        data.setBranch(product.getBranch());
        aggregator.aggregate((Object)product.getBranch());
        data.setSalesPoint(product.getSalesPoint());
        aggregator.aggregate((Object)product.getSalesPoint());
        data.setAgent(product.getAgent());
        aggregator.aggregate((Object)product.getAgent());
        IndexBuilderHelper.updateReservationGdsNameInfo(product.getReservation(), data, aggregator);
        data.setIssueDate(product.getIssueDate());
        data.setIssueDateTime(product.getIssueDate());
        data.setUnholdDate(null);
        data.setUnholdDateTime(null);
        ProductStatus productStatus = DeliveryHelper.getProductStatus((Delivery)product);
        data.setStatus(productStatus);
        aggregator.aggregate((Enum)productStatus);
        aggregator.aggregate((Enum)product.getStatus());
        String blankOwnerCode = null;
        String blankOwnerAirlineNumber = null;
        if (product.getAgency() != null) {
            try {
                EntityContainer agencyContainer = EntityStorage.get().resolve(product.getAgency());
                if (agencyContainer != null) {
                    Airline airline = (Airline)DictionaryCache.get().resolveReference(((Organization)agencyContainer.getEntity()).getAirline());
                    if (airline != null) {
                        blankOwnerAirlineNumber = airline.getAirlineNumber();
                    }
                    blankOwnerCode = ((Organization)agencyContainer.getEntity()).getCode();
                }
            }
            catch (Exception e) {
                this.log.error("unable to resolve blank owner", (Throwable)e);
            }
        }
        data.setBlankOwnerCode(blankOwnerCode);
        aggregator.aggregate(blankOwnerCode);
        data.setBlankOwnerAirlineNumber(blankOwnerAirlineNumber);
        aggregator.aggregate(blankOwnerAirlineNumber);
        ArrayList<String> systemNumbers = new ArrayList<String>();
        if (!TextUtil.isBlank((String)product.getSystemNumber())) {
            systemNumbers.add(product.getSystemNumber());
        }
        data.setSystemNumbers(systemNumbers);
        aggregator.aggregate(systemNumbers);
        ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
        String routeLine = handler.generateShortProductName((BaseProduct)product);
        routeLine = !TextUtil.isBlank((String)routeLine) && routeLine.length() > 255 ? "???" : routeLine;
        data.setRouteLine(routeLine);
        aggregator.aggregate((Object)routeLine);
        data.setFirstTravelDate(product.getStartDate());
        data.setLastTravelDate(product.getStartDate());
        aggregator.aggregate(product.getStartDate());
        data.setServiceLocationType(ServiceLocationType.DOMESTIC);
        aggregator.aggregate((Enum)ServiceLocationType.DOMESTIC);
    }

    protected void updateFopData(CommonProductFopIndexData data, DataAggregator aggregator, GeneralProductFop fop, Delivery product) {
        data.setFopUid(fop.getUid());
        FopType fopType = GeneralProductHelper.getFopType((GeneralProductFop)fop);
        data.setFopType(fopType);
        aggregator.aggregate((Enum)fopType);
        data.setPaymentType(fop.getType());
        aggregator.aggregate((Enum)fop.getType());
        BigDecimal equivalentAmount = fop.getEquivalentAmount();
        ProductStatus status = DeliveryHelper.getProductStatus((Delivery)product);
        if (equivalentAmount != null && (status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE)) {
            equivalentAmount = equivalentAmount.negate();
        }
        data.setAmount(equivalentAmount);
        try {
            String currency = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)null);
            data.setCurrency(currency);
            aggregator.aggregate((Object)currency);
        }
        catch (Exception currency) {
            // empty catch block
        }
        CardVendor cardVendor = null;
        String cardNumber = null;
        String cardSecurityCode = null;
        if (fop.getCard() != null) {
            Card card = fop.getCard();
            cardVendor = card.getVendor();
            cardNumber = card.getNumber();
            cardSecurityCode = card.getSecurityCode();
        }
        data.setCardVendor(cardVendor);
        aggregator.aggregate((Enum)cardVendor);
        data.setCardNumber(cardNumber);
        aggregator.aggregate((Object)cardNumber);
        data.setCardSecurityCode(cardSecurityCode);
        aggregator.aggregate((Object)cardSecurityCode);
        data.setRelatedTicketNumber(fop.getRelatedTicketNumber());
        aggregator.aggregate((Object)fop.getRelatedTicketNumber());
        data.setFopAgent(fop.getAgent());
        aggregator.aggregate((Object)fop.getAgent());
        data.setFopDate(fop.getOperationDate());
        data.setHasComments(Boolean.valueOf(!TextUtil.isBlank((String)product.getReservation().getBookingFile().getNotes())));
    }
}

