/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.CommonProductIndexData;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.OperationBatch;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.delivery.DeliveryStatus;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.ProfileGroupReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DeliveryHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.handlers.ServerHandlersRegistry;
import com.gridnine.xtrip.server.model.handlers.index.CommonIndexHandler;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import com.gridnine.xtrip.server.model.index.BaseCommonProductIndexHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeliveryCommonProductIndexHandler
extends BaseCommonProductIndexHandler
implements IndexHandler<BookingFile, CommonProductIndex> {
    Logger log = LoggerFactory.getLogger(this.getClass());

    public Class<? extends BaseIndexData<BookingFile, CommonProductIndex>> getDataClass() {
        return CommonProductIndexData.class;
    }

    public Class<CommonProductIndex> getIndexClass() {
        return CommonProductIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public void create(EntityContainer<BookingFile> etc, Collection<BaseIndexData<BookingFile, CommonProductIndex>> indexes) {
        DataAggregator aggregator = new DataAggregator();
        for (Reservation reservation : ((BookingFile)etc.getEntity()).getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                if (!(baseProduct instanceof Delivery)) continue;
                aggregator.reset();
                try {
                    CommonProductIndexData data = new CommonProductIndexData();
                    List handlers = ServerHandlersRegistry.get().findCommonIndexHandlers(this.getIndexClass());
                    for (CommonIndexHandler<BaseProduct, BookingFile, CommonProductIndex> commonIndexHandler : handlers) {
                        commonIndexHandler.updateData((BaseIndexData<BookingFile, CommonProductIndex>)data, aggregator, etc, baseProduct);
                    }
                    this.updateData(data, aggregator, etc, (Delivery)baseProduct);
                    data.setAggregatedData(aggregator.toString());
                    indexes.add((BaseIndexData<BookingFile, CommonProductIndex>)data);
                }
                catch (Exception e) {
                    this.log.error("unable to create index", (Throwable)e);
                }
            }
        }
    }

    protected void updateData(CommonProductIndexData data, DataAggregator aggregator, EntityContainer<BookingFile> etc, Delivery product) throws Exception {
        data.setNavigationKey(product.getUid());
        data.setNextProductUid(product.getNextProduct() == null ? null : product.getNextProduct().getUid());
        data.setReservationType(product.getReservation().getType());
        data.setBookingNumber(TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile()));
        aggregator.aggregate((Object)TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile()));
        data.setBookingCreateDate(product.getReservation().getBookingFile().getCreateDate());
        aggregator.aggregate(product.getReservation().getBookingFile().getCreateDate());
        data.setServiceLocationType(ServiceLocationType.DOMESTIC);
        aggregator.aggregate((Enum)ServiceLocationType.DOMESTIC);
        data.setTimeLimit(product.getReservation().getTimeLimit());
        aggregator.aggregate(product.getReservation().getTimeLimit());
        data.setBlankOwner(product.getAgency());
        String militaryClaimNumber = GeneralProductHelper.getMilitaryClaimNumber((BaseProduct)product);
        data.setMilitaryClaimNumber(militaryClaimNumber);
        aggregator.aggregate((Object)militaryClaimNumber);
        if (product.getAgency() != null) {
            try {
                EntityContainer ctr = EntityStorage.get().resolve(product.getAgency());
                if (ctr != null) {
                    Airline airline = (Airline)DictionaryCache.get().resolveReference(((Organization)ctr.getEntity()).getAirline());
                    if (airline != null) {
                        data.setBlankOwnerAirlineNumber(airline.getAirlineNumber());
                    }
                    data.setBlankOwnerCode(((Organization)ctr.getEntity()).getCode());
                    data.setProviderCode(((Organization)ctr.getEntity()).getCode());
                    data.setProviderName(((Organization)ctr.getEntity()).toString());
                }
            }
            catch (Exception e) {
                this.log.error("unable to resolve blank owner", (Throwable)e);
            }
        }
        data.setStatus(DeliveryHelper.getProductStatus((Delivery)product));
        aggregator.aggregate((Enum)product.getStatus());
        data.setIssueDate(product.getIssueDate());
        data.setIssueDateTime(product.getIssueDate());
        data.setLocalIssueDate(product.getLocalIssueDate());
        data.setUnholdDate(null);
        data.setUnholdDateTime(null);
        ArrayList<String> systemNumbers = new ArrayList<String>();
        if (!TextUtil.isBlank((String)product.getSystemNumber())) {
            systemNumbers.add(product.getSystemNumber());
        }
        data.setSystemNumbers(systemNumbers);
        data.setFirstSystemNumber((String)CollectionUtil.head(systemNumbers));
        aggregator.aggregate(systemNumbers);
        data.setTicketType(product.getTicketType());
        aggregator.aggregate((Enum)product.getTicketType());
        data.setChecked(Boolean.valueOf(product.isChecked()));
        data.setCompleted(Boolean.valueOf(product.isCompleted()));
        data.setAgent(product.getAgent());
        aggregator.aggregate((Object)product.getAgent());
        data.setClient(product.getReservation().getBookingFile().getCustomerProfile());
        EntityReference clientRelationMediator = GeneralProductHelper.getClientRelationMediator((BaseProduct)product);
        data.setMediator(clientRelationMediator);
        aggregator.aggregate((Object)clientRelationMediator);
        aggregator.aggregate((Object)product.getReservation().getBookingFile().getCustomerProfile());
        data.setAgency(product.getAgency());
        aggregator.aggregate((Object)product.getAgency());
        data.setSupplier(product.getAgency());
        try {
            EntityContainer client = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
            if (client != null) {
                String code = SystemHelper.findMetadataAsString((Collection)((Organization)client.getEntity()).getMetadata(), (MetadataKey)MetadataKey.KEY_ACCOUNTING_SYSTEM_CODE);
                code = code != null ? code : ((Organization)client.getEntity()).getCode();
                data.setClientAccountingCode(code);
                aggregator.aggregate((Object)code);
                ArrayList clientGroups = new ArrayList();
                for (Metadata metadata : ((Organization)client.getEntity()).getMetadata()) {
                    if (metadata.getKey() == null || !metadata.getKey().getCode().equals(MetadataKey.KEY_ORGANIZATION_PROFILE_GROUP.name()) || metadata.getValue() == null) continue;
                    clientGroups.add((ProfileGroupReference)metadata.getValue());
                }
                data.setClientGroups(clientGroups);
                aggregator.aggregate(clientGroups);
            }
        }
        catch (Throwable e) {
            this.log.error("unable to load profile " + product.getReservation().getBookingFile().getCustomerProfile(), e);
        }
        data.setSubagency(product.getAgency());
        EntityContainer clientContainer = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
        if (clientContainer != null) {
            data.setHolding(((Organization)clientContainer.getEntity()).getHolding());
            aggregator.aggregate((Object)((Organization)clientContainer.getEntity()).getHolding());
        }
        data.setBranch(product.getBranch());
        aggregator.aggregate((Object)product.getBranch());
        data.setSalesPoint(product.getSalesPoint());
        aggregator.aggregate((Object)product.getSalesPoint());
        Date refuseDate = null;
        for (GeneralProductFop fop2 : product.getClientFops()) {
            if (!fop2.isRefused() || fop2.getOperationDate() == null || refuseDate != null && !refuseDate.after(fop2.getOperationDate())) continue;
            refuseDate = fop2.getOperationDate();
        }
        if (refuseDate != null) {
            data.setCancellationDate(refuseDate);
            aggregator.aggregate(refuseDate);
        }
        String sortingNumber = product.getSystemNumber();
        OperationBatch batch = null;
        if (product.getStatus() != null) {
            switch (product.getStatus()) {
                case VOID: {
                    batch = OperationBatch.VOID;
                    break;
                }
                case COMPLETED: {
                    batch = OperationBatch.SELL;
                    sortingNumber = product.getSystemNumber() + "2";
                    break;
                }
                case PLANNED: {
                    batch = OperationBatch.SELL;
                    sortingNumber = product.getSystemNumber() + "1";
                }
            }
        }
        data.setOperationBatch(batch);
        aggregator.aggregate((Object)sortingNumber);
        data.setSortingTicketNumber(sortingNumber);
        aggregator.aggregate((Enum)batch);
        data.setWorkflowStatus(product.getReservation().getBookingFile().getWorkflowStatus());
        aggregator.aggregate((Enum)product.getReservation().getBookingFile().getWorkflowStatus());
        data.setReservationStatus(product.getReservation().getStatus());
        aggregator.aggregate((Enum)product.getReservation().getStatus());
        aggregator.aggregate((Enum)ProductType.DELIVERY);
        data.setProductType(ProductType.DELIVERY);
        data.setDescription(ProductType.DELIVERY.toString());
        if (product.getStatus() != DeliveryStatus.VOID) {
            ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
            String routeLine = handler.generateShortProductName((BaseProduct)product);
            routeLine = !TextUtil.isBlank((String)routeLine) && routeLine.length() > 255 ? "???" : routeLine;
            data.setRouteLine(routeLine);
            aggregator.aggregate((Object)routeLine);
            boolean vatIncluded = true;
            EntityContainer ctr = EntityStorage.get().resolve(product.getAgency());
            if (ctr.getEntity() != null) {
                vatIncluded = ((Organization)ctr.getEntity()).isSimpleTaxed();
            }
            data.setIncludeVat(Boolean.valueOf(vatIncluded));
            data.setEquivalentFare(BigDecimal.ZERO);
            data.setValid(Boolean.valueOf(true));
            data.setHasOtherErrors(Boolean.valueOf(false));
            data.setHasStockControlErrors(Boolean.valueOf(false));
            data.setHasRulesErrors(Boolean.valueOf(false));
            data.setHasShipmentErrors(Boolean.valueOf(false));
            data.setHasErrors(Boolean.valueOf(false));
            for (ValidationMessage message : product.getValidationMessages()) {
                if (message.getSeverity() == ValidationMessageSeverity.WARNING) {
                    data.setHasWarnings(Boolean.valueOf(true));
                }
                if (message.getSeverity() == ValidationMessageSeverity.USER_ERROR) {
                    data.setHasUserErrors(Boolean.valueOf(true));
                    data.setHasErrors(Boolean.valueOf(true));
                }
                if (message.getSeverity() == ValidationMessageSeverity.SHIPMENT_ERROR) {
                    data.setHasShipmentErrors(Boolean.valueOf(true));
                }
                if (message.getSeverity() != ValidationMessageSeverity.ERROR) continue;
                data.setHasErrors(Boolean.valueOf(true));
                if (message.getCategory() == ValidationMessageCategory.OTHER) {
                    data.setValid(Boolean.valueOf(false));
                    data.setHasOtherErrors(Boolean.valueOf(true));
                }
                if (message.getCategory() == ValidationMessageCategory.STOCK_CONTROL) {
                    data.setHasStockControlErrors(Boolean.valueOf(true));
                }
                if (message.getCategory() != ValidationMessageCategory.RULES) continue;
                data.setHasRulesErrors(Boolean.valueOf(true));
            }
            data.setFirstTravelDate(product.getStartDate());
            data.setLastTravelDate(product.getEndDate());
            aggregator.aggregate(product.getStartDate());
            data.setTaxesSum(BigDecimal.ZERO);
            data.setTaxesForBlankSum(BigDecimal.ZERO);
            data.setOtherTaxesSum(BigDecimal.ZERO);
            data.setOtherTaxesSum(BigDecimal.ZERO);
            CardVendor creditCardVendor = GeneralProductHelper.getCreditCardVendor((Collection)product.getClientFops());
            data.setClientCardVendor(creditCardVendor);
            aggregator.aggregate((Enum)creditCardVendor);
            VatAmount price = BookingHelper.calculateProductPrice((BaseProduct)product, (ContractType)ContractType.CLIENT);
            BigDecimal totalSum = price.getTotal();
            data.setTotalSum(totalSum);
            aggregator.aggregate((Object)totalSum);
            data.setVatRate(price.getVat());
            data.setVatValue(price.getVatAmount());
            try {
                data.setClientCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.getCommissionValue((Collection)product.getCommissions(), (ContractType)ContractType.CLIENT, CommissionProperties.class, (boolean)false), (boolean)false));
                data.setClientBonusValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.getCommissionValue((Collection)product.getCommissions(), (ContractType)ContractType.CLIENT, CommissionProperties.class, (boolean)true), (boolean)false));
                BigDecimal clientFeeValue = GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.filterCommissions((Collection)product.getCommissions(), (Set)GeneralProductHelper.clientContractTypes), (Set)GeneralProductHelper.feePropertyTypes, null, null));
                BigDecimal clientServiceFeeValue = GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.filterCommissions((Collection)product.getCommissions(), (Set)GeneralProductHelper.clientContractTypes), (Set)GeneralProductHelper.serviceFeePropertyTypes, null, null));
                BigDecimal clientPaymentFeeValue = GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.filterCommissions((Collection)product.getCommissions(), (Set)GeneralProductHelper.clientContractTypes), (Set)GeneralProductHelper.paymentFeePropertyTypes, null, null));
                if (DeliveryStatus.RETURNED.equals((Object)product.getStatus())) {
                    clientFeeValue = MiscUtil.negate((BigDecimal)clientFeeValue);
                    clientServiceFeeValue = MiscUtil.negate((BigDecimal)clientServiceFeeValue);
                    clientPaymentFeeValue = MiscUtil.negate((BigDecimal)clientPaymentFeeValue);
                }
                data.setClientFeeValue(clientFeeValue);
                data.setClientServiceFeeValue(clientServiceFeeValue);
                data.setClientPaymentFeeValue(clientPaymentFeeValue);
                data.setClientCommissionRate(GeneralProductHelper.findCommissionRate((Collection)product.getCommissions(), (ContractType)ContractType.CLIENT, CommissionProperties.class, (boolean)false));
                data.setClientBonusRate(GeneralProductHelper.findCommissionRate((Collection)product.getCommissions(), (ContractType)ContractType.CLIENT, CommissionProperties.class, (boolean)true));
                data.setClientFeeRate(GeneralProductHelper.findCommissionRate((Collection)product.getCommissions(), (ContractType)ContractType.CLIENT, FeeProperties.class, (boolean)false));
            }
            catch (Exception e) {
                this.log.error("failed calculating commissions ", (Throwable)e);
            }
            Object date = null;
            EntityReference agent = null;
            boolean hasClientDebt = false;
            HashSet<PaymentType> clientFopTypes = new HashSet<PaymentType>();
            HashSet<PaymentType> clientFeesFopTypes = new HashSet<PaymentType>();
            BigDecimal clientFOPAmount = null;
            BigDecimal clientFOPAddAmount = null;
            BigDecimal clientFOPTotalAddAmount = null;
            EnumSet<PaymentType> addPaymentTypes = EnumSet.allOf(PaymentType.class);
            addPaymentTypes.remove(PaymentType.TICKET);
            addPaymentTypes.remove(PaymentType.VOUCHER);
            addPaymentTypes.remove(PaymentType.MTD);
            addPaymentTypes.remove(PaymentType.MTD_AGENCY);
            addPaymentTypes.remove(PaymentType.CREDIT);
            addPaymentTypes.remove(PaymentType.CREDIT_CARD);
            for (GeneralProductFop fop3 : product.getClientFops()) {
                if (fop3.getEquivalentAmount() != null) {
                    BigDecimal bigDecimal = clientFOPAmount = clientFOPAmount != null ? clientFOPAmount.add(fop3.getEquivalentAmount()) : fop3.getEquivalentAmount();
                }
                if (fop3.getEquivalentAmount() != null && addPaymentTypes.contains(fop3.getType()) && GeneralProductHelper.productFopTypes.contains(GeneralProductHelper.getFopType((GeneralProductFop)fop3))) {
                    BigDecimal bigDecimal = clientFOPAddAmount = clientFOPAddAmount != null ? clientFOPAddAmount.add(fop3.getEquivalentAmount()) : fop3.getEquivalentAmount();
                }
                if (fop3.getEquivalentAmount() != null && addPaymentTypes.contains(fop3.getType()) && !GeneralProductHelper.discountFopTypes.contains(GeneralProductHelper.getFopType((GeneralProductFop)fop3))) {
                    BigDecimal bigDecimal = clientFOPTotalAddAmount = clientFOPTotalAddAmount != null ? clientFOPTotalAddAmount.add(fop3.getEquivalentAmount()) : fop3.getEquivalentAmount();
                }
                if (fop3.getType() != null) {
                    if (GeneralProductHelper.isServiceFop((GeneralProductFop)fop3)) {
                        clientFopTypes.add(fop3.getType());
                    } else {
                        clientFeesFopTypes.add(fop3.getType());
                    }
                }
                if (fop3.getOperationDate() == null) {
                    hasClientDebt = true;
                    continue;
                }
                if (date != null && !((Date)date).before(fop3.getOperationDate())) continue;
                date = fop3.getOperationDate();
                agent = fop3.getAgent();
            }
            if (DeliveryStatus.RETURNED.equals((Object)product.getStatus())) {
                if (clientFOPAmount != null) {
                    clientFOPAmount = clientFOPAmount.negate();
                }
                if (clientFOPAddAmount != null) {
                    clientFOPAddAmount = clientFOPAddAmount.negate();
                }
                if (clientFOPTotalAddAmount != null) {
                    clientFOPTotalAddAmount = clientFOPTotalAddAmount.negate();
                }
            }
            data.setClientFopAmount(clientFOPAmount);
            aggregator.aggregate((Object)clientFOPAmount);
            data.setClientFopAddAmount(clientFOPAddAmount);
            aggregator.aggregate((Object)clientFOPAddAmount);
            data.setClientFopTotalAddAmount(clientFOPTotalAddAmount);
            aggregator.aggregate((Object)clientFOPTotalAddAmount);
            data.setClientFopTypes(clientFopTypes);
            aggregator.aggregate(clientFopTypes);
            data.setClientFeesFopTypes(clientFeesFopTypes);
            aggregator.aggregate(clientFeesFopTypes);
            data.setDateOfClientPayment((Date)date);
            aggregator.aggregate((Date)date);
            data.setClientFopAgent(agent);
            aggregator.aggregate((Object)agent);
            data.setHasClientDebt(Boolean.valueOf(hasClientDebt));
            data.setAgentPenaltyForService(BookingHelper.calculateAgentPenaltyForProduct((BaseProduct)product));
            data.setAgentPenaltyForCommissions(null);
            data.setAgentPenaltyForFees(BookingHelper.calculateAgentPenaltyForFees((BaseProduct)product));
            data.setPayers((Collection)GeneralProductHelper.getClientFops((BaseProduct)product).stream().filter(fop -> fop.getPayer() != null).map(fop -> fop.getPayer()).collect(Collectors.toSet()));
            data.setSubagencyContractTotalSum(BookingHelper.calculateProductPrice((BaseProduct)product, (ContractType)ContractType.SUBAGENCY).getTotal());
        } else {
            data.setValid(Boolean.valueOf(true));
            data.setHasOtherErrors(Boolean.valueOf(false));
            data.setHasErrors(Boolean.valueOf(false));
        }
        String notes = product.getReservation().getBookingFile().getNotes();
        data.setHasNotes(Boolean.valueOf(notes != null && !notes.trim().isEmpty()));
        boolean inFinanceDocuments = IndexBuilderHelper.isInFinanceDocuments((BaseProduct)product);
        data.setInFinanceDocuments(Boolean.valueOf(inFinanceDocuments));
        StringBuilder email = new StringBuilder();
        if (product.getReservation().getBookingFile() != null && product.getReservation().getBookingFile().getCustomer() != null) {
            for (Communication c : product.getReservation().getBookingFile().getCustomer().getCommunications()) {
                if (c == null || !CommunicationType.EMAIL.equals((Object)c.getType()) || TextUtil.isBlank((String)c.getSense())) continue;
                email = email.append(email.length() > 0 ? ", " + c.getSense() : c.getSense());
            }
        }
        if (!TextUtil.isBlank((String)email.toString())) {
            data.setEmail(TextUtil.adjustStringToLimit((String)email.toString(), (String)", ", (int)255));
            aggregator.aggregate((Object)email.toString());
        }
        data.setAggregator(aggregator);
        this.updateStatisticalData(data, product.getStatisticalData(), (EntityReference<Organization>)product.getReservation().getBookingFile().getCustomerProfile());
        data.setAggregator(null);
        Set shipments = product.getFopDetalizations().values().stream().flatMap(item -> item.getComponents().stream()).filter(item -> item.getShipment() != null).map(item -> item.getShipment()).collect(Collectors.toSet());
        data.setShipments(shipments);
        aggregator.aggregate(shipments);
        data.setShipmentsDate(product.getShipmentsDate());
        data.setShipmentsDateSubagent(product.getShipmentsDateSubagent());
        data.setFopComponentsAllUsed(Boolean.valueOf(product.getFopDetalizations().values().stream().flatMap(item -> item.getComponents().stream()).allMatch(item -> item.getShipment() != null)));
        String comments = TextUtil.getFieldOrTrimToLength((String)product.getComments(), (int)255);
        data.setComments(comments);
        aggregator.aggregate((Object)comments);
        EntityReference clientPrepaymentDocument = null;
        EntityReference subagentPrepaymentDocument = null;
        for (EntityReference prepaymentDocumentReference : product.getPrepaymentDocuments()) {
            EntityContainer contract;
            EntityContainer prepaymentDocument = EntityStorage.get().resolve(prepaymentDocumentReference);
            if (prepaymentDocument == null || (contract = EntityStorage.get().resolve(((FinanceDocument)prepaymentDocument.getEntity()).getContract())) == null) continue;
            if (((Contract)contract.getEntity()).getContractType() == ContractType.CLIENT) {
                clientPrepaymentDocument = prepaymentDocumentReference;
                continue;
            }
            if (((Contract)contract.getEntity()).getContractType() != ContractType.SUBAGENCY) continue;
            subagentPrepaymentDocument = prepaymentDocumentReference;
        }
        data.setClientPrepaymentDocument(clientPrepaymentDocument);
        data.setSubagentPrepaymentDocument(subagentPrepaymentDocument);
        aggregator.aggregate(clientPrepaymentDocument);
        aggregator.aggregate(subagentPrepaymentDocument);
        Set receipts = product.getFopDetalizations().values().stream().flatMap(fopDetalization -> fopDetalization.getComponents().stream()).map(FopComponent::getReceipt).collect(Collectors.toSet());
        data.setReceipts(receipts);
        Set travellersGroups = GeneralProductHelper.getHandler((BaseProduct)product).getTravellers((BaseProduct)product).stream().map(item -> EntityStorage.get().resolve(item.getPassenger())).filter(item -> item != null).flatMap(item -> ((Person)item.getEntity()).getMetadata().stream()).filter(item -> item.getKey() != null && item.getValue() != null && MiscUtil.equals((Object)item.getKey().getCode(), (Object)MetadataKey.KEY_PERSON_PROFILE_GROUP.name())).map(item -> (ProfileGroupReference)item.getValue()).collect(Collectors.toSet());
        data.setTravellersGroups(travellersGroups);
        aggregator.aggregate(travellersGroups);
        Set agentsGroups = Optional.ofNullable(EntityStorage.get().resolve(GeneralProductHelper.getHandler((BaseProduct)product).findIssuingAgent((BaseProduct)product))).map(item -> ((Person)item.getEntity()).getMetadata()).orElse(Collections.emptyList()).stream().filter(item -> item.getKey() != null && item.getValue() != null && MiscUtil.equals((Object)item.getKey().getCode(), (Object)MetadataKey.KEY_PERSON_PROFILE_GROUP.name())).map(item -> (ProfileGroupReference)item.getValue()).collect(Collectors.toSet());
        data.setAgentsGroups(agentsGroups);
        aggregator.aggregate(agentsGroups);
    }
}

