/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.delivery.DeliveryIndex;
import com.gridnine.xtrip.common.model.delivery.DeliveryIndexData;
import com.gridnine.xtrip.common.model.delivery.DeliveryItem;
import com.gridnine.xtrip.common.model.delivery.DeliveryStatus;
import com.gridnine.xtrip.common.model.delivery.MetroStation;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeliveryIndexHandler
implements IndexHandler<BookingFile, DeliveryIndex> {
    Logger log = LoggerFactory.getLogger(this.getClass());

    public Class<? extends BaseIndexData<BookingFile, DeliveryIndex>> getDataClass() {
        return DeliveryIndexData.class;
    }

    public Class<DeliveryIndex> getIndexClass() {
        return DeliveryIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public void create(EntityContainer<BookingFile> etc, Collection<BaseIndexData<BookingFile, DeliveryIndex>> indexes) {
        for (Reservation reservation : ((BookingFile)etc.getEntity()).getReservations()) {
            DataAggregator aggregator = new DataAggregator();
            for (BaseProduct product : reservation.getProducts()) {
                if (!(product instanceof Delivery)) continue;
                DeliveryIndexData data = new DeliveryIndexData();
                aggregator.reset();
                try {
                    Delivery delivery = (Delivery)product;
                    this.updateData(data, aggregator, delivery);
                    data.setAggregatedData(aggregator.toString());
                }
                catch (Exception e) {
                    this.log.error("unable to create index", (Throwable)e);
                    continue;
                }
                indexes.add((BaseIndexData<BookingFile, DeliveryIndex>)data);
            }
        }
    }

    protected void updateData(DeliveryIndexData data, DataAggregator aggregator, Delivery product) throws Exception {
        String notes;
        MetroStation metroStation;
        data.setTicketType(product.getTicketType());
        aggregator.aggregate((Enum)product.getTicketType());
        data.setAgency(product.getAgency());
        aggregator.aggregate((Object)product.getAgency());
        EntityContainer clientContainer = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
        if (clientContainer != null) {
            data.setHolding(((Organization)clientContainer.getEntity()).getHolding());
            aggregator.aggregate((Object)((Organization)clientContainer.getEntity()).getHolding());
        }
        data.setAgent(product.getAgent());
        aggregator.aggregate((Object)product.getAgent());
        data.setChecked(Boolean.valueOf(product.isChecked()));
        data.setCompleted(Boolean.valueOf(product.isCompleted()));
        data.setSystemNumber(product.getSystemNumber());
        aggregator.aggregate((Object)product.getSystemNumber());
        data.setAddressee(product.getAddressee());
        aggregator.aggregate((Object)product.getAddressee());
        String accountingCode = product.getAddressee() != null && Organization.class.equals((Object)product.getAddressee().getType()) ? ProfileHelper.findAccountingCode((EntityReference)product.getAddressee()) : null;
        data.setAddresseeAccountingCode(accountingCode);
        data.setAddresseeName(product.getAddresseeName());
        aggregator.aggregate((Object)product.getAddresseeName());
        aggregator.aggregate((Object)accountingCode);
        data.setNavigationKey(product.getUid());
        List<String> recordLocators = IndexBuilderHelper.getRecordLocators(product.getReservation());
        data.setRecordLocators(recordLocators);
        aggregator.aggregate(recordLocators);
        List<GdsName> gdsNames = IndexBuilderHelper.getGdsNames(product.getReservation());
        data.setGdsNames(gdsNames);
        aggregator.aggregate(gdsNames);
        data.setDisplayedRecordLocator(CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)product.getReservation()));
        DeliveryStatus status = product.getStatus();
        data.setStatus(status);
        aggregator.aggregate((Enum)status);
        Date issueDate = product.getIssueDate();
        data.setIssueDate(issueDate == null ? null : MiscUtil.clearTime((Date)issueDate));
        aggregator.aggregate(issueDate);
        data.setIssueDateTime(issueDate);
        data.setSalesPoint(product.getSalesPoint());
        aggregator.aggregate((Object)product.getSalesPoint());
        data.setAddress(product.getAddress());
        aggregator.aggregate((Object)product.getAddress());
        aggregator.aggregate((Object)product.getAdditionalInfo());
        data.setContactPerson(product.getContactPerson());
        aggregator.aggregate((Object)product.getContactPerson());
        data.setContactPersonName(product.getContactPersonName());
        aggregator.aggregate((Object)product.getContactPersonName());
        data.setContactPhone(product.getContactPhone());
        aggregator.aggregate((Object)product.getContactPhone());
        data.setDeliveryDate(product.getStartDate() == null ? product.getStartDate() : MiscUtil.clearTime((Date)product.getStartDate()));
        aggregator.aggregate(product.getStartDate());
        data.setStartTime(this.getDate(product.getStartDate()));
        data.setEndTime(this.getDate(product.getEndDate()));
        data.setCourier(product.getCourier());
        aggregator.aggregate((Object)product.getCourier());
        data.setDeliveryRegion(product.getDeliveryRegion());
        aggregator.aggregate((Object)product.getDeliveryRegion());
        String bookingNumber = TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile());
        data.setBookingNumber(bookingNumber);
        aggregator.aggregate((Object)bookingNumber);
        data.setMetroStation(product.getMetroStation());
        aggregator.aggregate((Object)product.getMetroStation());
        if (product.getMetroStation() != null && (metroStation = (MetroStation)DictionaryCache.get().resolveReference(product.getMetroStation())) != null) {
            data.setMetroLine(metroStation.getLine());
            aggregator.aggregate((Object)metroStation.getLine());
        }
        boolean hasErrors = false;
        boolean hasOtherErrors = false;
        for (ValidationMessage message : product.getValidationMessages()) {
            if (message.getSeverity() != ValidationMessageSeverity.ERROR) continue;
            hasErrors = true;
            if (message.getCategory() != ValidationMessageCategory.OTHER) continue;
            hasOtherErrors = true;
        }
        data.setHasErrors(Boolean.valueOf(hasErrors));
        data.setHasOtherErrors(Boolean.valueOf(hasOtherErrors));
        data.setCancellationDate(GeneralProductHelper.getFirstRefuseDate((List)product.getClientFops()));
        if (status != DeliveryStatus.VOID) {
            BigDecimal fee = GeneralProductHelper.calculateFee((BaseProduct)product, (ContractType)ContractType.CLIENT);
            data.setDeliveryCost(fee);
            aggregator.aggregate((Object)fee);
            Date date = null;
            EntityReference agent = null;
            boolean hasClientDebt = false;
            PaymentType clientFeesFopTypes = null;
            BigDecimal clientFOPAmount = BigDecimal.ZERO;
            for (GeneralProductFop fop : product.getClientFops()) {
                if (fop.getEquivalentAmount() == null) continue;
                clientFOPAmount = clientFOPAmount.add(fop.getEquivalentAmount());
                if (fop.getType() != null && clientFeesFopTypes == null) {
                    clientFeesFopTypes = fop.getType();
                }
                if (fop.getOperationDate() == null) {
                    hasClientDebt = true;
                    continue;
                }
                if (date != null && !date.before(fop.getOperationDate())) continue;
                date = fop.getOperationDate();
                agent = fop.getAgent();
            }
            if (DeliveryStatus.RETURNED.equals((Object)status) && clientFOPAmount != null) {
                clientFOPAmount = clientFOPAmount.negate();
            }
            data.setClientFopAmount(clientFOPAmount);
            data.setClientFopType(clientFeesFopTypes);
            data.setDateOfClientPayment(date);
            aggregator.aggregate(date);
            data.setClientFopAgent(agent);
            aggregator.aggregate(agent);
            data.setHasClientDebt(Boolean.valueOf(hasClientDebt));
            BigDecimal total = BigDecimal.ZERO;
            BigDecimal totalCash = BigDecimal.ZERO;
            for (DeliveryItem item : product.getDeliveryItems()) {
                if (item.getCost() == null) continue;
                total = total.add(item.getCost());
                if (item.getPaymentType() != PaymentType.CASH) continue;
                totalCash = totalCash.add(item.getCost());
            }
            data.setTotalDeliverySum(total);
            data.setCashDeliverySum(totalCash);
            data.setAgentPenaltyForProduct(BookingHelper.calculateAgentPenaltyForProduct((BaseProduct)product));
            data.setAgentPenaltyForCommissions(null);
            data.setAgentPenaltyForFees(BookingHelper.calculateAgentPenaltyForFees((BaseProduct)product));
        }
        data.setHasNotes(Boolean.valueOf((notes = product.getReservation().getBookingFile().getNotes()) != null && !notes.trim().isEmpty()));
        boolean inFinanceDocuments = IndexBuilderHelper.isInFinanceDocuments((BaseProduct)product);
        data.setInFinanceDocuments(Boolean.valueOf(inFinanceDocuments));
        List costCodes = StatisticsHelper.findCostCenterCostCodes((StatisticalData)product.getStatisticalData(), (EntityReference)product.getReservation().getBookingFile().getCustomerProfile());
        if (!costCodes.isEmpty()) {
            String value = IndexBuilderHelper.getCostCodesJoinValue(costCodes, CostCode::getValue);
            String localValue = IndexBuilderHelper.getCostCodesJoinValue(costCodes, CostCode::getLocalValue);
            String englishValue = IndexBuilderHelper.getCostCodesJoinValue(costCodes, CostCode::getEnglishValue);
            data.setCostCenter(value);
            data.setCostCenterLocalValue(localValue);
            data.setCostCenterEnglishValue(englishValue);
            aggregator.aggregate((Object)value);
            aggregator.aggregate((Object)localValue);
            aggregator.aggregate((Object)englishValue);
            data.setCostCenterList(IndexBuilderHelper.getCostCodeValues(costCodes, CostCode::getValue));
            data.setCostCenterLocalValueList(IndexBuilderHelper.getCostCodeValues(costCodes, CostCode::getLocalValue));
            data.setCostCenterEnglishValueList(IndexBuilderHelper.getCostCodeValues(costCodes, CostCode::getEnglishValue));
        }
        String comments = TextUtil.getFieldOrTrimToLength((String)product.getComments(), (int)255);
        data.setComments(comments);
        aggregator.aggregate((Object)comments);
        data.setCustomer(product.getReservation().getBookingFile().getCustomerProfile());
    }

    private double getDate(Date startDate) {
        if (startDate == null) {
            return 0.0;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        return (double)cal.get(11) + (double)cal.get(12) / 100.0;
    }
}

