/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.delivery.DeliveryItem;
import com.gridnine.xtrip.common.model.delivery.DeliveryItemIndex;
import com.gridnine.xtrip.common.model.delivery.DeliveryItemIndexData;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeliveryItemIndexHandler
implements IndexHandler<BookingFile, DeliveryItemIndex> {
    Logger log = LoggerFactory.getLogger(this.getClass());

    public Class<? extends BaseIndexData<BookingFile, DeliveryItemIndex>> getDataClass() {
        return DeliveryItemIndexData.class;
    }

    public Class<DeliveryItemIndex> getIndexClass() {
        return DeliveryItemIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public void create(EntityContainer<BookingFile> etc, Collection<BaseIndexData<BookingFile, DeliveryItemIndex>> indexes) {
        for (Reservation reservation : ((BookingFile)etc.getEntity()).getReservations()) {
            DataAggregator aggregator = new DataAggregator();
            for (BaseProduct product : reservation.getProducts()) {
                if (!(product instanceof Delivery)) continue;
                Delivery delivery = (Delivery)product;
                for (DeliveryItem item : delivery.getDeliveryItems()) {
                    DeliveryItemIndexData data = new DeliveryItemIndexData();
                    aggregator.reset();
                    try {
                        Object object = item.getObject();
                        if (object != null) {
                            NestedEntityReference reference;
                            data.setName(object.toString());
                            aggregator.aggregate((Object)object.toString());
                            if (object instanceof NestedEntityReference) {
                                reference = (NestedEntityReference)object;
                                data.setRootEntityUid(reference.getUid());
                                data.setNestedEntityUid(reference.getNestedEntityUid());
                            } else if (object instanceof EntityReference) {
                                reference = (EntityReference)object;
                                data.setRootEntityUid(reference.getUid());
                            }
                        }
                        data.setType(item.getType());
                        aggregator.aggregate((Enum)item.getType());
                        data.setCost(item.getCost());
                        data.setCurrency(item.getCurrency());
                        aggregator.aggregate((Object)item.getCost());
                        data.setIssueDate(delivery.getIssueDate());
                        aggregator.aggregate(delivery.getIssueDate());
                        data.setNavigationKey(item.getUid());
                        data.setPaymentType(item.getPaymentType());
                        aggregator.aggregate((Enum)item.getPaymentType());
                        data.setStatus(delivery.getStatus());
                        aggregator.aggregate((Enum)delivery.getStatus());
                        data.setDeliveryUid(delivery.getUid());
                        data.setBookingFileNumber(((BookingFile)etc.getEntity()).getNumber());
                        aggregator.aggregate((Object)((BookingFile)etc.getEntity()).getNumber());
                        data.setDeliverySystemNumber(delivery.getSystemNumber());
                        aggregator.aggregate((Object)delivery.getSystemNumber());
                        data.setAggregatedData(aggregator.toString());
                    }
                    catch (Exception e) {
                        this.log.error("unable to create index", (Throwable)e);
                        continue;
                    }
                    indexes.add((BaseIndexData<BookingFile, DeliveryItemIndex>)data);
                }
            }
        }
    }
}

