/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.meta.DictionaryType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.DictUpdateItem;
import com.gridnine.xtrip.common.model.dict.DictUpdateItemIndex;
import com.gridnine.xtrip.common.model.dict.DictUpdateItemIndexData;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;
import java.util.Locale;

public class DictionaryUpdateItemIndexHandler
implements IndexHandler<DictUpdateItem, DictUpdateItemIndex> {
    private static final Locale[] locales = new Locale[]{LocaleHelper.RU_LOCALE, LocaleHelper.EN_LOCALE, LocaleHelper.getLocale((String)"UK"), LocaleHelper.getLocale((String)"BG")};

    public void create(EntityContainer<DictUpdateItem> etc, Collection<BaseIndexData<DictUpdateItem, DictUpdateItemIndex>> indexes) {
        if (etc != null && etc.getEntity() != null) {
            DictUpdateItem item = (DictUpdateItem)etc.getEntity();
            DictUpdateItemIndexData data = new DictUpdateItemIndexData();
            data.setCode(item.getCode());
            L10nString name = new L10nString();
            for (Locale loc : locales) {
                name.getValues().put(loc, ((DictionaryType)MetaRegistry.get().getDictionaries().get(item.getDictClassName())).getDisplayName(loc));
            }
            data.setDictName(name);
            data.setField(item.getField());
            data.setOldValue(item.getOldValue());
            data.setNewValue(item.getNewValue());
            data.setUpdated(Boolean.valueOf(item.isUpdated()));
            indexes.add((BaseIndexData<DictUpdateItem, DictUpdateItemIndex>)data);
        }
    }

    public Class<? extends BaseIndexData<DictUpdateItem, DictUpdateItemIndex>> getDataClass() {
        return DictUpdateItemIndexData.class;
    }

    public Class<DictUpdateItemIndex> getIndexClass() {
        return DictUpdateItemIndex.class;
    }

    public Class<DictUpdateItem> getEntityType() {
        return DictUpdateItem.class;
    }
}

