/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndexData;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;
import java.util.stream.Collectors;

public class DocumentBasicDocumentIndexHandler
implements IndexHandler<BaseFileDocument, BasicDocumentIndex> {
    public Class<? extends BaseIndexData<BaseFileDocument, BasicDocumentIndex>> getDataClass() {
        return BasicDocumentIndexData.class;
    }

    public Class<BasicDocumentIndex> getIndexClass() {
        return BasicDocumentIndex.class;
    }

    public Class<BaseFileDocument> getEntityType() {
        return BaseFileDocument.class;
    }

    public void create(EntityContainer<BaseFileDocument> etc, Collection<BaseIndexData<BaseFileDocument, BasicDocumentIndex>> indexes) {
        if (!Document.class.isAssignableFrom(((BaseFileDocument)etc.getEntity()).getClass())) {
            return;
        }
        BasicDocumentIndexData data = new BasicDocumentIndexData();
        DataAggregator aggregator = new DataAggregator();
        Document entity = (Document)etc.getEntity();
        this.fillData(data, entity);
        this.fillAggregator(etc, aggregator, entity);
        data.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<BaseFileDocument, BasicDocumentIndex>)data);
    }

    protected void fillAggregator(EntityContainer<BaseFileDocument> etc, DataAggregator aggregator, Document entity) {
        aggregator.aggregate((Object)entity.getName());
        aggregator.aggregate(entity.getCreated());
        aggregator.aggregate((Enum)entity.getContentType());
        aggregator.aggregate((Object)entity.getDescription());
        aggregator.aggregate((Object)entity.getTitle());
        aggregator.aggregate((Enum)entity.getType());
        aggregator.aggregate((Object)etc.getUid());
    }

    protected void fillData(BasicDocumentIndexData data, Document entity) {
        data.setContentType(entity.getContentType());
        data.setCreated(entity.getCreated());
        data.setName(entity.getName());
        String title = entity.getTitle();
        data.setTitle(title != null && title.length() > 255 ? title.substring(0, 252) + "..." : title);
        data.setCheckSum(entity.getCheckSum());
        data.setSize(entity.getContent() == null ? 0 : entity.getContent().length);
        data.setType(entity.getType());
        data.setExternal(Boolean.valueOf(entity.isExternal()));
        data.setDoNotShowOnSite(Boolean.valueOf(entity.isDoNotShowOnSite()));
        data.setMultiOwner(Boolean.valueOf(entity.isMultiOwner()));
        data.setOwner(entity.getOwner());
        if (entity.isMultiOwner()) {
            data.setOwnersUids((Collection)entity.getOwners().stream().map(EntityReference::getUid).collect(Collectors.toList()));
        }
        data.setNavigationKey(entity.getNavigationKey());
    }
}

