/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.stockcontrol.ETicketQuota;
import com.gridnine.xtrip.common.model.stockcontrol.ETicketQuotaIndex;
import com.gridnine.xtrip.common.model.stockcontrol.ETicketQuotaIndexData;
import com.gridnine.xtrip.common.model.stockcontrol.ETicketQuotaItem;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.handlers.ServerHandlersRegistry;
import com.gridnine.xtrip.server.model.handlers.stockcontrol.StockControlProductHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ETicketQuotaIndexHandler
implements IndexHandler<ETicketQuota, ETicketQuotaIndex> {
    Logger log = LoggerFactory.getLogger(this.getClass());

    public void create(EntityContainer<ETicketQuota> etc, Collection<BaseIndexData<ETicketQuota, ETicketQuotaIndex>> indexes) {
        ETicketQuota entity = (ETicketQuota)etc.getEntity();
        EntityReference stockHolder = entity.getStockHolder();
        EntityReference blankOwner = entity.getBlankOwner();
        boolean countVoid = !entity.isRestoreUnvoid();
        EntityReference currentLocation = entity.getCurrentLocation();
        for (ETicketQuotaItem quotaItem : entity.getQuotaItems()) {
            if (entity.getCurrentLocation() != null && !entity.getCurrentLocation().equals((Object)entity.getStockHolder())) {
                try {
                    List<ETicketQuotaIndex> unallocateQuotaItemIndexes = this.getUnallocatedQuoteItems((EntityReference<Organization>)stockHolder, quotaItem.getGdsNames(), (DictionaryReference<BlankType>)quotaItem.getBlankType());
                    if (unallocateQuotaItemIndexes.size() > 0) {
                        countVoid = !unallocateQuotaItemIndexes.get(0).isRestoreUnvoid();
                    }
                }
                catch (Exception unallocateQuotaItemIndexes) {
                    // empty catch block
                }
            }
            ETicketQuotaIndexData data = new ETicketQuotaIndexData();
            DataAggregator aggregator = new DataAggregator();
            data.setStockHolder(stockHolder);
            aggregator.aggregate((Object)stockHolder);
            data.setBlankOwner(blankOwner);
            aggregator.aggregate((Object)blankOwner);
            data.setCurrentLocation(currentLocation);
            aggregator.aggregate((Object)currentLocation);
            data.setGdsNames((Collection)quotaItem.getGdsNames());
            aggregator.aggregate((Iterable)quotaItem.getGdsNames());
            data.setBlankType(quotaItem.getBlankType());
            aggregator.aggregate((Object)quotaItem.getBlankType());
            data.setNavigationKey(quotaItem.getUid());
            data.setRestoreUnvoid(Boolean.valueOf(entity.isRestoreUnvoid()));
            data.setTotalQuota(quotaItem.getTotalQuota());
            int usedQuotaAmount = this.getUsedQuotaAmount((EntityReference<Organization>)stockHolder, (EntityReference<Organization>)blankOwner, (EntityReference<? extends BaseProfile>)currentLocation, quotaItem.getGdsNames(), (DictionaryReference<BlankType>)quotaItem.getBlankType(), countVoid);
            data.setRemainder((int)(quotaItem.getTotalQuota() - (long)usedQuotaAmount));
            if (entity.getCurrentLocation() == null || entity.getCurrentLocation().equals((Object)entity.getStockHolder())) {
                int unallocatedQuotaAmount = this.getUnallocatedQuotaAmount(quotaItem.getTotalQuota(), (EntityReference<Organization>)stockHolder, (EntityReference<Organization>)blankOwner, (EntityReference<? extends BaseProfile>)currentLocation, quotaItem.getGdsNames(), (DictionaryReference<BlankType>)quotaItem.getBlankType(), countVoid);
                data.setUnusedQuota(unallocatedQuotaAmount);
            }
            data.setAggregatedData(aggregator.toString());
            indexes.add((BaseIndexData<ETicketQuota, ETicketQuotaIndex>)data);
        }
    }

    public Class<? extends BaseIndexData<ETicketQuota, ETicketQuotaIndex>> getDataClass() {
        return ETicketQuotaIndexData.class;
    }

    public Class<ETicketQuota> getEntityType() {
        return ETicketQuota.class;
    }

    public Class<ETicketQuotaIndex> getIndexClass() {
        return ETicketQuotaIndex.class;
    }

    private int getUsedQuotaAmount(EntityReference<Organization> stockHolder, EntityReference<Organization> blankOwner, EntityReference<? extends BaseProfile> currentLocation, Set<GdsName> gdsNames, DictionaryReference<BlankType> blankType, boolean countVoid) {
        EntityReference<? extends BaseProfile> subagency = null;
        EntityReference<? extends BaseProfile> salesPoint = null;
        if (currentLocation != null && !currentLocation.equals(stockHolder)) {
            if (currentLocation.getType().getName().equals(Organization.class.getName())) {
                subagency = currentLocation;
            } else if (currentLocation.getType().getName().equals(SalesPoint.class.getName())) {
                salesPoint = currentLocation;
            }
        }
        int count = 0;
        Collection<StockControlProductHandler<?, ?, ?>> handlers = ((ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class)).getAllStockControlHandlers();
        for (StockControlProductHandler<?, ?, ?> handler : handlers) {
            try {
                count += handler.getEticketCount(blankOwner, stockHolder, subagency, salesPoint, gdsNames, blankType, countVoid);
            }
            catch (Exception e) {
                this.log.debug(String.format("can't calculate used quota amount for products of %s type", handler.getProductClass()), (Throwable)e);
            }
        }
        return count;
    }

    private int getUnallocatedQuotaAmount(long totalQuota, EntityReference<Organization> stockHolder, EntityReference<Organization> blankOwner, EntityReference<? extends BaseProfile> currentLocation, Set<GdsName> gdsNames, DictionaryReference<BlankType> blankType, boolean countVoid) {
        try {
            List<ETicketQuotaIndex> indexes = this.getAllocatedQuoteItems(stockHolder, gdsNames, blankType);
            long unallocatedQuotaAmount = totalQuota;
            HashMap<String, ETicketQuota> quotaMap = new HashMap<String, ETicketQuota>();
            block2: for (ETicketQuotaIndex index : indexes) {
                EntityContainer quotaContainer;
                ETicketQuota quota = (ETicketQuota)quotaMap.get(index.getSource().getUid());
                if (quota == null && (quotaContainer = EntityStorage.get().resolve(index.getSource())) != null) {
                    quota = (ETicketQuota)quotaContainer.getEntity();
                    quotaMap.put(index.getSource().getUid(), quota);
                }
                if (quota == null) continue;
                for (ETicketQuotaItem item : quota.getQuotaItems()) {
                    if (item.getBlankType() == null || !item.getBlankType().equals((Object)index.getBlankType()) || item.getGdsNames().size() != index.getGdsNames().size() || !item.getGdsNames().containsAll(index.getGdsNames())) continue;
                    long totalQuotaAmount = item.getTotalQuota();
                    unallocatedQuotaAmount -= totalQuotaAmount;
                    long usedQuotaAmount = this.getUsedQuotaAmount((EntityReference<Organization>)index.getStockHolder(), (EntityReference<Organization>)index.getBlankOwner(), (EntityReference<? extends BaseProfile>)index.getCurrentLocation(), index.getGdsNames(), (DictionaryReference<BlankType>)index.getBlankType(), countVoid);
                    long remainderQuotaAmount = totalQuotaAmount - usedQuotaAmount;
                    if (remainderQuotaAmount >= 0L) continue block2;
                    unallocatedQuotaAmount += remainderQuotaAmount;
                    continue block2;
                }
            }
            return (int)unallocatedQuotaAmount;
        }
        catch (Exception e) {
            this.log.error("can't calculate unallocated quota amount", (Throwable)e);
            return 0;
        }
    }

    private List<ETicketQuotaIndex> getAllocatedQuoteItems(EntityReference<Organization> stockHolder, Set<GdsName> gdsNames, DictionaryReference<BlankType> blankType) throws Exception {
        SearchQuery query = new SearchQuery();
        if (stockHolder != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ETicketQuotaIndex.Property.stockHolder.name(), stockHolder));
            query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)ETicketQuotaIndex.Property.currentLocation.name(), null), SearchCriterion.ne((String)ETicketQuotaIndex.Property.currentLocation.name(), stockHolder)}));
        }
        if (gdsNames != null) {
            ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
            for (GdsName gdsName : gdsNames) {
                criterions.add(SearchCriterion.contains((String)ETicketQuotaIndex.Property.gdsNames.name(), (Object)gdsName.name()));
            }
            query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
        }
        if (blankType != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ETicketQuotaIndex.Property.blankType.name(), (Object)blankType.getCode()));
        }
        return EntityStorage.get().search(ETicketQuotaIndex.class, query).getData();
    }

    private List<ETicketQuotaIndex> getUnallocatedQuoteItems(EntityReference<Organization> stockHolder, Set<GdsName> gdsNames, DictionaryReference<BlankType> blankType) throws Exception {
        SearchQuery query = new SearchQuery();
        if (stockHolder != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ETicketQuotaIndex.Property.stockHolder.name(), stockHolder));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ETicketQuotaIndex.Property.currentLocation.name(), null), SearchCriterion.eq((String)ETicketQuotaIndex.Property.currentLocation.name(), stockHolder)}));
        }
        if (gdsNames != null) {
            ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
            for (GdsName gdsName : gdsNames) {
                criterions.add(SearchCriterion.contains((String)ETicketQuotaIndex.Property.gdsNames.name(), (Object)gdsName.name()));
            }
            query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
        }
        if (blankType != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ETicketQuotaIndex.Property.blankType.name(), (Object)blankType.getCode()));
        }
        return EntityStorage.get().search(ETicketQuotaIndex.class, query).getData();
    }
}

