/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndexData;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.EntityOperationTracingDocument;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;

public class EntityOperationTracingDocumentBasicDocumentIndexHandler
implements IndexHandler<BaseFileDocument, BasicDocumentIndex> {
    public Class<? extends BaseIndexData<BaseFileDocument, BasicDocumentIndex>> getDataClass() {
        return BasicDocumentIndexData.class;
    }

    public Class<BasicDocumentIndex> getIndexClass() {
        return BasicDocumentIndex.class;
    }

    public Class<BaseFileDocument> getEntityType() {
        return EntityOperationTracingDocument.class;
    }

    public void create(EntityContainer<BaseFileDocument> etc, Collection<BaseIndexData<BaseFileDocument, BasicDocumentIndex>> indexes) {
        BasicDocumentIndexData data = new BasicDocumentIndexData();
        DataAggregator aggregator = new DataAggregator();
        EntityOperationTracingDocument entity = (EntityOperationTracingDocument)etc.getEntity();
        data.setContentType(entity.getContentType());
        data.setCreated(entity.getCreated());
        data.setName(entity.getName());
        data.setTitle(entity.getTitle());
        data.setCheckSum(entity.getCheckSum());
        data.setSize(entity.getContent() == null ? 0 : entity.getContent().length);
        data.setType(DocumentType.ENTITY_OPERATION_TRACING_DOCUMENT);
        data.setOwner(entity.getOwner());
        data.setNavigationKey(entity.getNavigationKey());
        aggregator.aggregate((Object)entity.getName());
        aggregator.aggregate((Enum)entity.getContentType());
        aggregator.aggregate((Object)entity.getDescription());
        aggregator.aggregate((Object)entity.getTitle());
        aggregator.aggregate((Enum)DocumentType.ENTITY_OPERATION_TRACING_DOCUMENT);
        data.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<BaseFileDocument, BasicDocumentIndex>)data);
    }

    protected void fillAggregator(EntityContainer<BaseFileDocument> etc, DataAggregator aggregator, Document entity) {
        aggregator.aggregate((Object)entity.getName());
        aggregator.aggregate(entity.getCreated());
        aggregator.aggregate((Enum)entity.getContentType());
        aggregator.aggregate((Object)entity.getDescription());
        aggregator.aggregate((Object)entity.getTitle());
        aggregator.aggregate((Enum)entity.getType());
        aggregator.aggregate((Object)etc.getUid());
    }

    protected void fillData(BasicDocumentIndexData data, Document entity) {
        data.setContentType(entity.getContentType());
        data.setCreated(entity.getCreated());
        data.setName(entity.getName());
        data.setTitle(entity.getTitle());
        data.setCheckSum(entity.getCheckSum());
        data.setSize(entity.getContent() == null ? 0 : entity.getContent().length);
        data.setType(entity.getType());
        data.setOwner(entity.getOwner());
        data.setNavigationKey(entity.getNavigationKey());
    }
}

