/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.system.EventNotification;
import com.gridnine.xtrip.common.model.system.EventNotificationIndex;
import com.gridnine.xtrip.common.model.system.EventNotificationIndexData;
import com.gridnine.xtrip.common.model.system.EventNotificationRecipient;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;
import java.util.stream.Collectors;

public class EventNotificationIndexHandler
implements IndexHandler<EventNotification, EventNotificationIndex> {
    public Class<? extends BaseIndexData<EventNotification, EventNotificationIndex>> getDataClass() {
        return EventNotificationIndexData.class;
    }

    public Class<EventNotificationIndex> getIndexClass() {
        return EventNotificationIndex.class;
    }

    public Class<EventNotification> getEntityType() {
        return EventNotification.class;
    }

    public void create(EntityContainer<EventNotification> etc, Collection<BaseIndexData<EventNotification, EventNotificationIndex>> indexes) {
        EventNotification notification = (EventNotification)etc.getEntity();
        EventNotificationIndexData index = new EventNotificationIndexData();
        index.setActive(Boolean.valueOf(notification.isActive()));
        index.setAlarmDate(notification.getAlarmDate());
        index.setEventDate(notification.getEventDate());
        index.setTitle(notification.getTitle());
        index.setEntityReference(notification.getEntityReference());
        index.setNeedEmail(Boolean.valueOf(notification.isNeedEmail()));
        index.setViewingDate(notification.getViewingDate());
        index.setMailingDate(notification.getMailingDate());
        index.setRecipientNames((Collection)notification.getRecipients().stream().filter(recipient -> !TextUtil.isBlank((String)recipient.getName())).map(EventNotificationRecipient::getName).collect(Collectors.toList()));
        index.setRecipientProfiles((Collection)notification.getRecipients().stream().filter(recipient -> recipient.getProfile() != null).map(EventNotificationRecipient::getProfile).collect(Collectors.toList()));
        index.setRecipientLogins((Collection)notification.getRecipients().stream().filter(recipient -> !TextUtil.isBlank((String)recipient.getLogin())).map(EventNotificationRecipient::getLogin).collect(Collectors.toList()));
        DataAggregator aggregator = new DataAggregator();
        aggregator.aggregate((Object)notification.getTitle());
        aggregator.aggregate((Object)notification.getEntityReference());
        for (EventNotificationRecipient recipient2 : notification.getRecipients()) {
            aggregator.aggregate((Object)recipient2.getName());
            aggregator.aggregate((Object)recipient2.getProfile());
            aggregator.aggregate((Object)recipient2.getLogin());
            aggregator.aggregate((Object)recipient2.getEmail());
        }
        index.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<EventNotification, EventNotificationIndex>)index);
    }
}

