/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.export.BaseExportSettings;
import com.gridnine.xtrip.common.model.export.BaseExportSettingsWithCommonSettings;
import com.gridnine.xtrip.common.model.export.EntityCompressedData;
import com.gridnine.xtrip.common.model.export.ExportDocument;
import com.gridnine.xtrip.common.model.export.ExportDocumentIndex;
import com.gridnine.xtrip.common.model.export.ExportDocumentIndexData;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.export.ConnectionHandler;
import com.gridnine.xtrip.server.model.export.ExportHandler;
import com.gridnine.xtrip.server.model.handlers.ServerHandlersRegistry;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportDocumentIndexHandler
implements IndexHandler<ExportDocument, ExportDocumentIndex> {
    protected transient Logger log = LoggerFactory.getLogger(this.getClass());

    public Class<? extends BaseIndexData<ExportDocument, ExportDocumentIndex>> getDataClass() {
        return ExportDocumentIndexData.class;
    }

    public Class<ExportDocumentIndex> getIndexClass() {
        return ExportDocumentIndex.class;
    }

    public Class<ExportDocument> getEntityType() {
        return ExportDocument.class;
    }

    public void create(EntityContainer<ExportDocument> etc, Collection<BaseIndexData<ExportDocument, ExportDocumentIndex>> indexes) {
        ExportHandler handler;
        ExportDocumentIndexData indexData = new ExportDocumentIndexData();
        DataAggregator aggregator = new DataAggregator();
        ExportDocument entity = (ExportDocument)etc.getEntity();
        EntityContainer settingsCtr = null;
        try {
            settingsCtr = EntityStorage.get().resolve(entity.getExportSettings());
            if (settingsCtr != null) {
                ConnectionHandler connectionHandler;
                if (((BaseExportSettings)settingsCtr.getEntity()).getConnectionSettings() != null && (connectionHandler = ((ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class)).findConnectionHandlerBySettings(((BaseExportSettings)settingsCtr.getEntity()).getConnectionSettings().getClass())) != null) {
                    indexData.setConnectionType(connectionHandler.getConnectionType());
                    aggregator.aggregate((Enum)connectionHandler.getConnectionType());
                }
                if (settingsCtr.getEntity() instanceof BaseExportSettingsWithCommonSettings) {
                    BaseExportSettingsWithCommonSettings advancedSettings = (BaseExportSettingsWithCommonSettings)settingsCtr.getEntity();
                    indexData.setCommonSettings(advancedSettings.getCommonSettings());
                    aggregator.aggregate((Object)advancedSettings.getCommonSettings());
                }
            }
        }
        catch (Exception e) {
            this.log.error("unable to resolve reference " + entity.getExportSettings(), (Throwable)e);
        }
        if (entity.getExportSettings() != null && (handler = ((ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class)).findExportHandlerBySettings(entity.getExportSettings().getType())) != null) {
            indexData.setExportCategory(handler.getExportCategory());
            aggregator.aggregate((Enum)handler.getExportCategory());
        }
        indexData.setCreateDate(entity.getCreateDate());
        aggregator.aggregate(entity.getCreateDate());
        indexData.setLastCommunicationDate(entity.getLastCommunicationDate());
        aggregator.aggregate(entity.getLastCommunicationDate());
        indexData.setExportSettings(entity.getExportSettings());
        EntityReference relatedObject = entity.getObject() != null ? entity.getObject().getReference() : null;
        indexData.setObject(relatedObject);
        aggregator.aggregate((Object)relatedObject);
        String description = entity.getDescription() != null ? entity.getDescription() : (relatedObject != null ? relatedObject.toString() : null);
        indexData.setDescription(description);
        String fileName = entity.getFileName() != null ? entity.getFileName() : null;
        indexData.setFileName(fileName);
        aggregator.aggregate((Object)description);
        indexData.setStatus(entity.getStatus());
        aggregator.aggregate((Enum)entity.getStatus());
        indexData.setMayBeReExported(Boolean.valueOf(entity.isMayBeReExported()));
        aggregator.aggregate((Object)entity.isMayBeReExported());
        long size = 0L;
        if (entity.getContent() != null) {
            size += (long)entity.getContent().length;
        }
        if (entity.getResponse() != null) {
            size += (long)entity.getResponse().length;
        }
        for (EntityCompressedData item : entity.getReferencedEntities()) {
            if (item.getContent() == null) continue;
            size += (long)item.getContent().length;
        }
        for (EntityCompressedData item : entity.getReferencedDictionaries()) {
            if (item.getContent() == null) continue;
            size += (long)item.getContent().length;
        }
        indexData.setSize(size);
        indexData.setAggregatedData(aggregator.toString());
        indexData.setErrorCategory(entity.getErrorCategory());
        indexData.setExportAfter(entity.getExportAfter());
        indexes.add((BaseIndexData<ExportDocument, ExportDocumentIndex>)indexData);
    }
}

