/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.ExternalFinanceDocument;
import com.gridnine.xtrip.common.model.finance.ExternalFinanceDocumentIndex;
import com.gridnine.xtrip.common.model.finance.ExternalFinanceDocumentIndexData;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;

public class ExternalFinanceDocumentIndexHandler
implements IndexHandler<ExternalFinanceDocument, ExternalFinanceDocumentIndex> {
    public Class<? extends BaseIndexData<ExternalFinanceDocument, ExternalFinanceDocumentIndex>> getDataClass() {
        return ExternalFinanceDocumentIndexData.class;
    }

    public Class<ExternalFinanceDocumentIndex> getIndexClass() {
        return ExternalFinanceDocumentIndex.class;
    }

    public Class<ExternalFinanceDocument> getEntityType() {
        return ExternalFinanceDocument.class;
    }

    public void create(EntityContainer<ExternalFinanceDocument> etc, Collection<BaseIndexData<ExternalFinanceDocument, ExternalFinanceDocumentIndex>> indexes) throws Exception {
        ExternalFinanceDocumentIndexData data = new ExternalFinanceDocumentIndexData();
        DataAggregator aggregator = new DataAggregator();
        this.updateData(data, aggregator, etc);
        data.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<ExternalFinanceDocument, ExternalFinanceDocumentIndex>)data);
    }

    protected void updateData(ExternalFinanceDocumentIndexData data, DataAggregator aggregator, EntityContainer<ExternalFinanceDocument> etc) {
        ExternalFinanceDocument doc = (ExternalFinanceDocument)etc.getEntity();
        data.setAgent(doc.getAgent());
        data.setCustomer(doc.getCustomer());
        data.setDate(doc.getDate());
        data.setDocumentType(doc.getFinanceDocumentType());
        data.setNavigationKey(doc.getUid());
        data.setNumber(TextUtil.buildFullNumber((CompositeNumber)doc));
        data.setSupplier(doc.getSupplier());
        data.setPayer(doc.getPayer());
        data.setContract(doc.getContract());
        data.setTotalAmount(doc.getTotalAmount());
        EntityReference bookingFileRef = doc.getOwner();
        data.setBookingFile(bookingFileRef);
        if (bookingFileRef != null) {
            SearchQuery bookingFileQuery = new SearchQuery();
            bookingFileQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)"containerUid", (Object)bookingFileRef.getUid()));
            bookingFileQuery.getPreferredProperties().add(BookingFileIndex.Property.fullNumber.name());
            bookingFileQuery.setLimit(2);
            BookingFileIndex bookingFileIndex = (BookingFileIndex)CollectionUtil.single((Collection)EntityStorage.get().search(BookingFileIndex.class, bookingFileQuery).getData());
            data.setBookingFileNumber(bookingFileIndex.getFullNumber());
        }
        aggregator.aggregate((Object)doc.getAgent());
        aggregator.aggregate((Object)TextUtil.buildFullNumber((CompositeNumber)doc));
        aggregator.aggregate((Enum)doc.getType());
        aggregator.aggregate((Object)doc.getSupplier());
        aggregator.aggregate((Object)doc.getCustomer());
        aggregator.aggregate((Object)doc.getPayer());
        aggregator.aggregate((Object)doc.getOwner());
    }
}

