/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentIndex;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentIndexData;
import com.gridnine.xtrip.common.model.booking.Payment;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;

public class FinanceDocumentIndexHandler
implements IndexHandler<BookingFile, FinanceDocumentIndex> {
    public Class<? extends BaseIndexData<BookingFile, FinanceDocumentIndex>> getDataClass() {
        return FinanceDocumentIndexData.class;
    }

    public Class<FinanceDocumentIndex> getIndexClass() {
        return FinanceDocumentIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public void create(EntityContainer<BookingFile> etc, Collection<BaseIndexData<BookingFile, FinanceDocumentIndex>> indexes) {
        BookingFile bookingFile = (BookingFile)etc.getEntity();
        for (Payment payment : bookingFile.getPayments()) {
            String bookingNumber = TextUtil.buildFullNumber((CompositeNumber)payment.getBookingFile());
            EntityReference client = payment.getBookingFile() != null ? payment.getBookingFile().getCustomerProfile() : null;
            PaymentType clientFOPType = payment.getFop() != null ? payment.getFop().getType() : null;
            for (FinanceDocument financeDocument : payment.getFinanceDocuments()) {
                FinanceDocumentIndexData data = new FinanceDocumentIndexData();
                data.setNavigationKey(financeDocument.getUid());
                BigDecimal totalAmount = BigDecimal.ZERO;
                BigDecimal totalVAT = BigDecimal.ZERO;
                for (BillingItem billingItem : financeDocument.getBillingItems()) {
                    if (billingItem.getAmount() == null) continue;
                    BigDecimal amount = billingItem.getAmount().getTotal();
                    BigDecimal vat = billingItem.getAmount().getVatAmount();
                    if (amount != null) {
                        totalAmount = totalAmount.add(amount);
                    }
                    if (vat == null) continue;
                    totalVAT = totalVAT.add(vat);
                }
                EntityReference agency = null;
                String displayedRecordLocator = null;
                HashSet<String> recordLocators = new HashSet<String>();
                HashSet ticketNumbers = new HashSet();
                for (BillingItem billingItem : financeDocument.getBillingItems()) {
                    for (String productUid : billingItem.getProductUids()) {
                        BaseProduct baseProduct = BookingHelper.findProduct((BookingFile)bookingFile, (String)productUid);
                        if (baseProduct == null) continue;
                        if (TextUtil.isBlank(displayedRecordLocator)) {
                            displayedRecordLocator = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)baseProduct.getReservation());
                        }
                        recordLocators.addAll(IndexBuilderHelper.getRecordLocators(baseProduct.getReservation()));
                        ProductHandler productHandler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
                        if (productHandler == null) continue;
                        if (agency == null) {
                            agency = GeneralProductHelper.getAgency((BaseProduct)baseProduct);
                        }
                        ticketNumbers.addAll(productHandler.getProductNumbers(baseProduct));
                    }
                }
                data.setBookingNumber(bookingNumber);
                data.setRecordLocators(recordLocators);
                data.setDisplayedRecordLocator(displayedRecordLocator);
                data.setPaymentNumber(payment.getNumber());
                data.setAgent(payment.getAgent());
                data.setAgency(agency);
                data.setClient(client);
                data.setClientFopType(clientFOPType);
                data.setTicketNumbers(ticketNumbers);
                data.setTotalAmount(totalAmount);
                data.setTotalVat(totalVAT);
                data.setFinanceDocumentType(financeDocument.getType());
                data.setFinanceDocumentNumber(financeDocument.getNumber());
                data.setFinanceDocumentDate(financeDocument.getDate());
                this.performAdditionalDataUpdate(data, payment, financeDocument);
                DataAggregator aggregator = new DataAggregator();
                aggregator.aggregate((Object)bookingNumber);
                aggregator.aggregate(recordLocators);
                aggregator.aggregate((Object)payment.getAgent());
                aggregator.aggregate((Object)agency);
                aggregator.aggregate((Object)client);
                aggregator.aggregate((Object)payment.getNumber());
                aggregator.aggregate(ticketNumbers);
                aggregator.aggregate((Object)financeDocument.getNumber());
                this.performAdditionalDataAggregation(aggregator, payment, financeDocument);
                data.setAggregatedData(aggregator.toString());
                indexes.add((BaseIndexData<BookingFile, FinanceDocumentIndex>)data);
            }
        }
    }

    protected void performAdditionalDataUpdate(FinanceDocumentIndexData data, Payment payment, FinanceDocument financeDocument) {
    }

    protected void performAdditionalDataAggregation(DataAggregator aggregator, Payment payment, FinanceDocument financeDocument) {
    }
}

