/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentRecordIndex;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentRecordIndexData;
import com.gridnine.xtrip.common.model.finance.PaymentItem;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.helpers.FinanceDocumentHelper;
import java.math.BigDecimal;
import java.util.Collection;

public class FinanceDocumentRecordIndexHandler
implements IndexHandler<FinanceDocument, FinanceDocumentRecordIndex> {
    public Class<? extends BaseIndexData<FinanceDocument, FinanceDocumentRecordIndex>> getDataClass() {
        return FinanceDocumentRecordIndexData.class;
    }

    public Class<FinanceDocumentRecordIndex> getIndexClass() {
        return FinanceDocumentRecordIndex.class;
    }

    public Class<FinanceDocument> getEntityType() {
        return FinanceDocument.class;
    }

    public void create(EntityContainer<FinanceDocument> etc, Collection<BaseIndexData<FinanceDocument, FinanceDocumentRecordIndex>> indexes) {
        FinanceDocumentRecordIndexData data = new FinanceDocumentRecordIndexData();
        DataAggregator aggregator = new DataAggregator();
        this.updateData(data, aggregator, etc);
        data.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<FinanceDocument, FinanceDocumentRecordIndex>)data);
    }

    protected void updateData(FinanceDocumentRecordIndexData data, DataAggregator aggregator, EntityContainer<FinanceDocument> etc) {
        FinanceDocument doc = (FinanceDocument)etc.getEntity();
        data.setAgent(doc.getAgent());
        data.setCustomer(doc.getCustomer());
        data.setDate(doc.getDate());
        data.setDocumentType(doc.getType());
        data.setNavigationKey(doc.getUid());
        data.setNumber(TextUtil.buildFullNumber((CompositeNumber)doc));
        data.setSupplier(doc.getSupplier());
        data.setPayer(doc.getPayer());
        data.setContract(doc.getContract());
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalVatAmount = BigDecimal.ZERO;
        EntityStorageContext ctx = EntityStorageHelper.createContext();
        for (BillingItem item : FinanceDocumentHelper.getBillingItems(doc.getBillingItems(), ctx)) {
            if (item.getAmount() == null) continue;
            if (item.getAmount().getTotal() != null) {
                totalAmount = totalAmount.add(item.getAmount().getTotal());
            }
            if (item.getAmount().getVatAmount() == null) continue;
            totalVatAmount = totalVatAmount.add(item.getAmount().getVatAmount());
        }
        data.setTotalAmount(totalAmount);
        data.setTotalVatAmount(totalVatAmount);
        BigDecimal totalPayedAmount = BigDecimal.ZERO;
        for (NestedEntityReference item : doc.getPaymentItems()) {
            PaymentItem pi = (PaymentItem)EntityStorageHelper.resolve((NestedEntityReference)item, (EntityStorageContext)ctx);
            if (pi == null || pi.getAmount() == null || pi.getAmount().getValue() == null) continue;
            totalPayedAmount = totalPayedAmount.add(pi.getAmount().getValue());
        }
        data.setPayed(Boolean.valueOf(doc.isAmountChecked() || MiscUtil.equals((Object)totalAmount, (Object)totalPayedAmount)));
        data.setTotalPayedAmount(totalPayedAmount);
        data.setIncludedToDelivery(Boolean.valueOf(doc.getDelivery() != null));
        data.setRelatedShipments((Collection)doc.getRelatedShipments());
        aggregator.aggregate((Object)doc.getAgent());
        aggregator.aggregate((Object)TextUtil.buildFullNumber((CompositeNumber)doc));
        aggregator.aggregate((Enum)doc.getType());
        aggregator.aggregate((Object)doc.getSupplier());
        aggregator.aggregate((Object)doc.getCustomer());
        aggregator.aggregate((Object)doc.getPayer());
    }
}

