/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableNameUtil;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.GdsReference;
import com.gridnine.xtrip.common.model.profile.GdsReferenceIndex;
import com.gridnine.xtrip.common.model.profile.GdsReferenceIndexData;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GdsReferenceIndexHandler
implements IndexHandler<Person, GdsReferenceIndex> {
    private static final Logger log = LoggerFactory.getLogger(GdsReferenceIndexHandler.class);

    public Class<? extends BaseIndexData<Person, GdsReferenceIndex>> getDataClass() {
        return GdsReferenceIndexData.class;
    }

    public Class<GdsReferenceIndex> getIndexClass() {
        return GdsReferenceIndex.class;
    }

    public Class<Person> getEntityType() {
        return Person.class;
    }

    /*
     * Unable to fully structure code
     */
    public void create(EntityContainer<Person> etc, Collection<BaseIndexData<Person, GdsReferenceIndex>> indexes) {
        personReference = etc.toReference();
        person = (Person)etc.getEntity();
        for (GdsReference ref : person.getGdsReferences()) {
            data = new GdsReferenceIndexData();
            data.setAgency(ref.getAgency());
            data.setClosed(ref.getClosed());
            data.setGdsName(ref.getGdsName());
            data.setOpened(ref.getOpened());
            data.setReference(ref.getReference());
            data.setAgencyCode(ref.getAgencyCode());
            salesPoint = ref.getSalesPoint();
            data.setSalesPoint(salesPoint);
            subagency = null;
            if (salesPoint == null) {
                currentDate = MiscUtil.clearTime((Date)new Date());
                for (PersonEmployment personEmployment : person.getEmployments()) {
                    if (personEmployment.getOpened() != null && personEmployment.getOpened().compareTo(currentDate) > 0 || personEmployment.getClosed() != null && personEmployment.getClosed().compareTo(currentDate) < 0) continue;
                    subagency = personEmployment.getOrganization();
                    break;
                }
            } else {
                try {
                    spc = EntityStorage.get().resolve(salesPoint);
                    if (spc == null) ** GOTO lbl28
                    subagency = ((SalesPoint)spc.getEntity()).getAgency();
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(this.getClass()).error(String.format("Unable to load index for sales point %s", new Object[]{salesPoint}), (Throwable)e);
                }
            }
            communication = person.getCommunications().isEmpty() == false ? ((PersonCommunication)person.getCommunications().get(0)).getSense() : null;
            data.setCommunications(communication);
            data.setSubagency(subagency);
            data.setCode(person.getCode());
            data.setLoginName(person.getLoginName());
            fullName = PersonalLocalizableNameUtil.buildFullName((PersonalLocalizableName)person, (boolean)true, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false);
            data.setName(fullName);
            address = person.getAddresses().isEmpty() == false ? ProfileHelper.buildFullAddress((Address)((Address)person.getAddresses().get(0)), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false) : null;
            data.setAddresses(address);
            data.setPreferredLocale(person.getPreferredLocale());
            pccList = new ArrayList<String>();
            if ((GdsName.SABRE.equals((Object)ref.getGdsName()) || GdsName.GABRIEL.equals((Object)ref.getGdsName())) && ref.getSalesPoint() != null) {
                try {
                    point = EntityStorage.get().resolve(ref.getSalesPoint());
                    for (Pcc pcc : ((SalesPoint)point.getEntity()).getPccs()) {
                        if (!pcc.getGdsName().equals((Object)ref.getGdsName())) continue;
                        pccList.add(pcc.getCode());
                    }
                }
                catch (Exception e) {
                    GdsReferenceIndexHandler.log.warn("Cannot retrieve SalesPoint from cache", (Throwable)e);
                }
            }
            data.setPccValues(pccList);
            employmentsUids = new ArrayList<String>();
            for (PersonEmployment placeOfEmployment : person.getEmployments()) {
                if (placeOfEmployment.getOrganization() == null || employmentsUids.contains(placeOfEmployment.getOrganization().getUid())) continue;
                employmentsUids.add(placeOfEmployment.getOrganization().getUid());
            }
            data.setEmploymentsUids(employmentsUids);
            parentOrganizationUids = new ArrayList<String>();
            try {
                parentOrganizations = ProfileHelper.getOrganizationParents((Collection)ProfileHelper.getPersonOrganizations(Collections.singletonList(personReference), null, (Date)new Date()));
                for (EntityReference parentOrganization : parentOrganizations) {
                    parentOrganizationUids.add(parentOrganization.getUid());
                }
            }
            catch (Exception e) {
                GdsReferenceIndexHandler.log.error("failed retrieving parent organizations", (Throwable)e);
            }
            data.setParentOrganizationUids(parentOrganizationUids);
            data.setRestricted(Boolean.valueOf(ProfileHelper.isRestricted(etc)));
            aggregator = new DataAggregator();
            aggregator.aggregate((Object)ref.getAgency());
            aggregator.aggregate(ref.getClosed());
            aggregator.aggregate(ref.getOpened());
            aggregator.aggregate((Enum)ref.getGdsName());
            aggregator.aggregate((Object)ref.getReference());
            aggregator.aggregate((Object)ref.getRemarks());
            aggregator.aggregate((Object)person.getPreferredLocale());
            aggregator.aggregate((Object)address);
            aggregator.aggregate((Object)communication);
            aggregator.aggregate((Object)person.getNotes());
            aggregator.aggregate((Object)salesPoint);
            aggregator.aggregate((Object)subagency);
            aggregator.aggregate((Object)fullName);
            aggregator.aggregate(pccList);
            data.setAggregatedData(aggregator.toString());
            indexes.add((BaseIndexData<Person, GdsReferenceIndex>)data);
        }
    }
}

