/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ProfileGroup;
import com.gridnine.xtrip.common.model.dict.ProfileGroupReference;
import com.gridnine.xtrip.common.model.helpers.CommunicationFormat;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Holding;
import com.gridnine.xtrip.common.model.profile.HoldingIndex;
import com.gridnine.xtrip.common.model.profile.HoldingIndexData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoldingIndexHandler
implements IndexHandler<Holding, HoldingIndex> {
    private static transient Logger log = LoggerFactory.getLogger((String)HoldingIndexHandler.class.getName());

    public Class<? extends BaseIndexData<Holding, HoldingIndex>> getDataClass() {
        return HoldingIndexData.class;
    }

    public Class<HoldingIndex> getIndexClass() {
        return HoldingIndex.class;
    }

    public Class<Holding> getEntityType() {
        return Holding.class;
    }

    public void create(EntityContainer<Holding> etc, Collection<BaseIndexData<Holding, HoldingIndex>> indexes) {
        HoldingIndexData data = new HoldingIndexData();
        DataAggregator aggregator = new DataAggregator();
        List holdingOrganizations = ProfileHelper.getHoldingOrganizations(Collections.singletonList(etc.toReference()));
        this.updateData(data, aggregator, etc, holdingOrganizations);
        data.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<Holding, HoldingIndex>)data);
    }

    protected void updateData(HoldingIndexData holdingIndexData, DataAggregator aggregator, EntityContainer<Holding> holdingEntityContainer, List<EntityReference<Organization>> holdingOrganizations) {
        Holding holding = (Holding)holdingEntityContainer.getEntity();
        Collection<String> communications = this.buildCommunications(aggregator, holding);
        String shortNameEng = L10nStringHelper.getValue((L10nString)holding.getShortName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true);
        ArrayList<DictionaryReference<ProfileGroup>> groups = new ArrayList<DictionaryReference<ProfileGroup>>();
        for (Metadata metadata : holding.getMetadata()) {
            if (metadata.getKey() == null || metadata.getValue() == null) continue;
            String metadataKeyCode = metadata.getKey().getCode();
            if (!MetadataKey.KEY_HOLDING_PROFILE_GROUP.name().equals(metadataKeyCode)) continue;
            groups.add((DictionaryReference<ProfileGroup>)((ProfileGroupReference)metadata.getValue()));
        }
        holdingIndexData.setAddressLegal(ProfileHelper.buildFullAddress((Address)ProfileHelper.filterAddresses((Collection)holding.getAddresses(), (AddressType)AddressType.LEGAL), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        holdingIndexData.setAddressFactual(ProfileHelper.buildFullAddress((Address)ProfileHelper.filterAddresses((Collection)holding.getAddresses(), (AddressType)AddressType.FACTUAL), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        holdingIndexData.setAddressContact(ProfileHelper.buildFullAddress((Address)ProfileHelper.filterAddresses((Collection)holding.getAddresses(), (AddressType)AddressType.CONTACT), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        holdingIndexData.setAddressDelivery(ProfileHelper.buildFullAddress((Address)ProfileHelper.filterAddresses((Collection)holding.getAddresses(), (AddressType)AddressType.DELIVERY), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        holdingIndexData.setHasOrganizations(Boolean.valueOf(holdingOrganizations.size() > 0));
        this.updateHoldingIndexData(holdingIndexData, holding, communications, shortNameEng, groups);
        this.updateAggregator(aggregator, holding, shortNameEng);
    }

    private void updateHoldingIndexData(HoldingIndexData holdingIndexData, Holding holding, Collection<String> communications, String shortNameEng, List<DictionaryReference<ProfileGroup>> groups) {
        LoggerFactory.getLogger(this.getClass()).debug(String.format("creating holding balance index for person " + holding.toString(), new Object[0]));
        holdingIndexData.setDisabled(Boolean.valueOf(holding.isDisabled()));
        holdingIndexData.setCode(holding.getCode());
        holdingIndexData.setName(holding.getFullName());
        holdingIndexData.setPreferredLocale(holding.getPreferredLocale());
        holdingIndexData.setKpp(holding.getKpp());
        holdingIndexData.setLegalForm(holding.getLegalForm());
        holdingIndexData.setRegistrationId(holding.getRegistrationId());
        holdingIndexData.setShortName(holding.getShortName());
        holdingIndexData.setEnglishShortName(shortNameEng);
        holdingIndexData.setSimpleTaxed(Boolean.valueOf(holding.isSimpleTaxed()));
        holdingIndexData.setGroups(groups);
        holdingIndexData.setCommunications(communications);
    }

    private void updateAggregator(DataAggregator aggregator, Holding holding, String shortNameEng) {
        aggregator.aggregate((Object)holding.getCode());
        aggregator.aggregate(holding.getFullName());
        aggregator.aggregate((Object)holding.isActive());
        aggregator.aggregate((Object)holding.isForeign());
        aggregator.aggregate((Object)holding.getKpp());
        aggregator.aggregate((Object)holding.getLegalForm());
        aggregator.aggregate((Object)holding.getRegistrationId());
        aggregator.aggregate(holding.getShortName());
        aggregator.aggregate((Object)holding.getPreferredLocale());
        if (!TextUtil.isBlank((String)shortNameEng)) {
            aggregator.aggregate((Object)shortNameEng);
        }
    }

    private Collection<String> buildCommunications(DataAggregator aggregator, Holding holding) {
        ArrayList<String> communications = new ArrayList<String>();
        for (Communication communication : holding.getCommunications()) {
            if (TextUtil.isBlank((String)communication.getSense())) continue;
            CommunicationFormat phoneFormat = new CommunicationFormat("+C (T) N #I");
            CommunicationFormat emailFormat = new CommunicationFormat("N");
            CommunicationFormat webFormat = new CommunicationFormat("N");
            String communicationString = null;
            switch (communication.getType()) {
                case WORK_PHONE: 
                case HOME_PHONE: 
                case FAX: 
                case MOBILE: 
                case AGENCY: 
                case HOTEL: 
                case CELL: 
                case EMERGENCY: {
                    communicationString = phoneFormat.format(communication);
                    break;
                }
                case EMAIL: {
                    communicationString = emailFormat.format(communication);
                    break;
                }
                case WEB: {
                    communicationString = webFormat.format(communication);
                }
            }
            if (communicationString == null) continue;
            communications.add(communication.getType() != null ? communication.getType() + ": " + communicationString : communicationString);
        }
        return communications;
    }

    private List<String> buildAddresses(Holding holding) {
        ArrayList<String> addresses = new ArrayList<String>();
        for (Address address : holding.getAddresses()) {
            addresses.add(ProfileHelper.buildFullAddress((Address)address, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        }
        return addresses;
    }
}

