/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductFopIndex;
import com.gridnine.xtrip.common.model.booking.CommonProductFopIndexData;
import com.gridnine.xtrip.common.model.booking.FopType;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.MCOFees;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductFop;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.MCOFeesHelper;
import com.gridnine.xtrip.common.model.helpers.ProductStatusHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.helpers.CommonProductHelper;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HotelCommonProductFopIndexHandler
implements IndexHandler<BookingFile, CommonProductFopIndex> {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public Class<? extends BaseIndexData<BookingFile, CommonProductFopIndex>> getDataClass() {
        return CommonProductFopIndexData.class;
    }

    public Class<CommonProductFopIndex> getIndexClass() {
        return CommonProductFopIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public void create(EntityContainer<BookingFile> bookingFileContainer, Collection<BaseIndexData<BookingFile, CommonProductFopIndex>> datas) {
        for (Reservation reservation : ((BookingFile)bookingFileContainer.getEntity()).getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                if (!(baseProduct instanceof HotelProduct)) continue;
                HotelProduct product = (HotelProduct)baseProduct;
                if (ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) continue;
                this.updateData(datas, product);
            }
        }
    }

    protected void updateData(Collection<BaseIndexData<BookingFile, CommonProductFopIndex>> datas, HotelProduct product) {
        CommonProductFopIndexData data;
        DataAggregator aggregator = new DataAggregator();
        for (HotelProductFop fop : HotelProductHelper.getVendorFops((HotelProduct)product)) {
            data = new CommonProductFopIndexData();
            this.updateProductData(data, aggregator, product);
            data.setContractType(ContractType.VENDOR);
            this.updateFopData(data, aggregator, fop, product);
            data.setAggregatedData(aggregator.toString());
            aggregator.reset();
            datas.add((BaseIndexData<BookingFile, CommonProductFopIndex>)data);
        }
        for (HotelProductFop fop : HotelProductHelper.getSubagentFops((HotelProduct)product, (boolean)false)) {
            data = new CommonProductFopIndexData();
            this.updateProductData(data, aggregator, product);
            data.setContractType(ContractType.SUBAGENCY);
            this.updateFopData(data, aggregator, fop, product);
            data.setAggregatedData(aggregator.toString());
            aggregator.reset();
            datas.add((BaseIndexData<BookingFile, CommonProductFopIndex>)data);
        }
        for (HotelProductFop fop : HotelProductHelper.getClientFops((HotelProduct)product)) {
            data = new CommonProductFopIndexData();
            this.updateProductData(data, aggregator, product);
            data.setContractType(ContractType.CLIENT);
            this.updateFopData(data, aggregator, fop, product);
            data.setRefuse(Boolean.valueOf(fop.isRefused()));
            StringBuilder mcoFeesNumbers = new StringBuilder();
            BigDecimal mcoFeesSum = BigDecimal.ZERO;
            if (!GeneralProductHelper.isServiceFop((GeneralProductFop)fop)) {
                for (Reservation res : product.getReservation().getBookingFile().getReservations()) {
                    for (BaseProduct bp : res.getProducts()) {
                        MCOFees mcoFees;
                        if (!(bp instanceof MCOFees) || !MCOFeesHelper.getRelatedProductUids((MCOFees)(mcoFees = (MCOFees)bp)).contains(product.getUid()) || mcoFees.getTotal() == null) continue;
                        mcoFeesSum = mcoFeesSum.add(mcoFees.getTotal());
                        mcoFeesNumbers.append(mcoFeesNumbers.length() > 0 ? ", " + mcoFees.getScn() : mcoFees.getScn());
                    }
                }
                data.setMcoFeesNumbers(mcoFeesNumbers.toString());
                data.setMcoFeesSum(mcoFeesSum);
            }
            data.setAggregatedData(aggregator.toString());
            aggregator.reset();
            datas.add((BaseIndexData<BookingFile, CommonProductFopIndex>)data);
        }
    }

    protected void updateProductData(CommonProductFopIndexData data, DataAggregator aggregator, HotelProduct product) {
        data.setProductUid(product.getUid());
        String bookingNumber = TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile());
        data.setBookingNumber(bookingNumber);
        aggregator.aggregate((Object)bookingNumber);
        ProductType productType = ProductType.HOTEL_RESERVATION;
        data.setProductType(productType);
        aggregator.aggregate((Enum)productType);
        data.setClient(product.getReservation().getBookingFile().getCustomerProfile());
        aggregator.aggregate((Object)product.getReservation().getBookingFile().getCustomerProfile());
        EntityReference supplier = HotelProductHelper.getSupplier((HotelProduct)product);
        data.setSupplier(supplier);
        aggregator.aggregate((Object)supplier);
        EntityReference agency = HotelProductHelper.getAgency((HotelProduct)product);
        data.setAgency(agency);
        aggregator.aggregate((Object)agency);
        data.setBranch(product.getBranch());
        aggregator.aggregate((Object)product.getBranch());
        EntityReference subagency = HotelProductHelper.getSubagency((HotelProduct)product);
        data.setSubagency(subagency);
        aggregator.aggregate((Object)subagency);
        EntityContainer clientContainer = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
        if (clientContainer != null) {
            data.setHolding(((Organization)clientContainer.getEntity()).getHolding());
            aggregator.aggregate((Object)((Organization)clientContainer.getEntity()).getHolding());
        }
        data.setSalesPoint(product.getSalesPoint());
        aggregator.aggregate((Object)product.getSalesPoint());
        data.setAgent(product.getCashier());
        aggregator.aggregate((Object)product.getCashier());
        data.setTicketType(product.getTicketType());
        aggregator.aggregate((Enum)product.getTicketType());
        IndexBuilderHelper.updateReservationGdsNameInfo(product.getReservation(), data, aggregator);
        data.setIssueDate(product.getIssueDate());
        data.setIssueDateTime(product.getIssueDate());
        data.setUnholdDate(product.getUnholdDate());
        data.setUnholdDateTime(product.getUnholdDate());
        data.setStatus(product.getStatus());
        aggregator.aggregate((Enum)product.getStatus());
        data.setSystemNumberPrefix(CommonProductHelper.HOTEL_AGREGATOR_SYSTEM_NUMBER_PREFIX);
        aggregator.aggregate((Object)CommonProductHelper.HOTEL_AGREGATOR_SYSTEM_NUMBER_PREFIX);
        String systemNumber = product.getSystemNumber();
        ArrayList<String> systemNumbers = new ArrayList<String>();
        if (!TextUtil.isBlank((String)systemNumber)) {
            systemNumbers.add(systemNumber);
        }
        data.setSystemNumbers(systemNumbers);
        aggregator.aggregate(systemNumbers);
        HashSet<String> travellersNames = new HashSet<String>();
        for (Traveller traveller : product.getTravellers()) {
            if (TextUtil.isBlank((String)traveller.getName())) continue;
            travellersNames.add(traveller.getName());
        }
        data.setTravellersNames(travellersNames);
        aggregator.aggregate(travellersNames);
        Date firstCheckinDate = HotelProductHelper.getFirstCheckinDate((HotelProduct)product);
        data.setFirstTravelDate(firstCheckinDate);
        aggregator.aggregate(firstCheckinDate);
        Date lastCheckoutDate = HotelProductHelper.getLastCheckoutDate((HotelProduct)product);
        data.setLastTravelDate(lastCheckoutDate);
        aggregator.aggregate(lastCheckoutDate);
    }

    protected void updateFopData(CommonProductFopIndexData data, DataAggregator aggregator, HotelProductFop fop, HotelProduct product) {
        BigDecimal amount;
        data.setFopUid(fop.getUid());
        FopType fopType = HotelProductHelper.getFopType((HotelProductFop)fop);
        data.setFopType(fopType);
        aggregator.aggregate((Enum)fopType);
        data.setPaymentType(fop.getType());
        aggregator.aggregate((Enum)fop.getType());
        BigDecimal bigDecimal = amount = fop.getAmount() != null ? fop.getAmount().getValue() : null;
        if (amount != null && ProductStatusHelper.get().negatesPrice(product.getStatus())) {
            amount = amount.negate();
        }
        data.setAmount(amount);
        if (fop.getAmount() != null) {
            data.setCurrency(fop.getAmount().getCurrency());
            aggregator.aggregate((Object)fop.getAmount().getCurrency());
        }
        CardVendor cardVendor = null;
        String cardNumber = null;
        String cardSecurityCode = null;
        if (fop.getCard() != null) {
            Card card = fop.getCard();
            cardVendor = card.getVendor();
            cardNumber = card.getNumber();
            cardSecurityCode = card.getSecurityCode();
        }
        data.setCardVendor(cardVendor);
        aggregator.aggregate((Enum)cardVendor);
        data.setCardNumber(cardNumber);
        aggregator.aggregate((Object)cardNumber);
        data.setCardSecurityCode(cardSecurityCode);
        aggregator.aggregate((Object)cardSecurityCode);
        data.setPassengerStatus(fop.getPassengerStatus());
        aggregator.aggregate((Enum)fop.getPassengerStatus());
        data.setRelatedTicketNumber(fop.getRelatedTicketNumber());
        aggregator.aggregate((Object)fop.getRelatedTicketNumber());
        data.setFopAgent(fop.getAgent());
        aggregator.aggregate((Object)fop.getAgent());
        data.setFopDate(fop.getOperationDate());
        data.setPayer(fop.getPayer());
        aggregator.aggregate((Object)fop.getPayer());
        data.setHasComments(Boolean.valueOf(!TextUtil.isBlank((String)product.getReservation().getBookingFile().getNotes())));
    }
}

