/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.CommonProductIndexData;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.OperationBatch;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductFop;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.ProfileGroupReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProductStatusHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.handlers.ServerHandlersRegistry;
import com.gridnine.xtrip.server.model.handlers.index.CommonIndexHandler;
import com.gridnine.xtrip.server.model.helpers.CommonProductHelper;
import com.gridnine.xtrip.server.model.index.BaseCommonProductIndexHandler;
import com.gridnine.xtrip.server.model.index.MainHotelProductIndexHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HotelCommonProductIndexHandler
extends BaseCommonProductIndexHandler
implements IndexHandler<BookingFile, CommonProductIndex> {
    Logger log = LoggerFactory.getLogger(this.getClass());

    public Class<? extends BaseIndexData<BookingFile, CommonProductIndex>> getDataClass() {
        return CommonProductIndexData.class;
    }

    public Class<CommonProductIndex> getIndexClass() {
        return CommonProductIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public void create(EntityContainer<BookingFile> etc, Collection<BaseIndexData<BookingFile, CommonProductIndex>> indexes) {
        DataAggregator aggregator = new DataAggregator();
        for (Reservation reservation : ((BookingFile)etc.getEntity()).getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                if (!(baseProduct instanceof HotelProduct)) continue;
                aggregator.reset();
                try {
                    CommonProductIndexData data = new CommonProductIndexData();
                    List handlers = ServerHandlersRegistry.get().findCommonIndexHandlers(this.getIndexClass());
                    for (CommonIndexHandler<BaseProduct, BookingFile, CommonProductIndex> commonIndexHandler : handlers) {
                        commonIndexHandler.updateData((BaseIndexData<BookingFile, CommonProductIndex>)data, aggregator, etc, baseProduct);
                    }
                    this.updateData(data, aggregator, etc, (HotelProduct)baseProduct);
                    data.setAggregatedData(aggregator.toString());
                    indexes.add((BaseIndexData<BookingFile, CommonProductIndex>)data);
                }
                catch (Exception e) {
                    this.log.error("unable to create index", (Throwable)e);
                }
            }
        }
    }

    protected void updateData(CommonProductIndexData data, DataAggregator aggregator, EntityContainer<BookingFile> etc, HotelProduct product) {
        BigDecimal equivalentFare;
        EntityContainer subagency;
        data.setNavigationKey(product.getUid());
        data.setNextProductUid(product.getNextProduct() == null ? null : product.getNextProduct().getUid());
        data.setReservationType(product.getReservation().getType());
        String bookingNumber = TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile());
        data.setBookingNumber(bookingNumber);
        aggregator.aggregate((Object)bookingNumber);
        data.setBookingCreateDate(product.getReservation().getBookingFile().getCreateDate());
        aggregator.aggregate(product.getReservation().getBookingFile().getCreateDate());
        data.setTimeLimit(product.getReservation().getTimeLimit());
        aggregator.aggregate(product.getReservation().getTimeLimit());
        data.setProviderName(product.getHotelName());
        data.setProviderCode(product.getHotelName());
        aggregator.aggregate((Object)product.getHotelName());
        EntityReference agency = HotelProductHelper.getAgency((HotelProduct)product);
        data.setAgency(agency);
        aggregator.aggregate((Object)agency);
        data.setBlankOwner(product.getBlankOwnerRef());
        aggregator.aggregate((Object)product.getBlankOwnerRef());
        data.setBranch(product.getBranch());
        aggregator.aggregate((Object)product.getBranch());
        data.setAgent(product.getCashier());
        aggregator.aggregate((Object)product.getCashier());
        EntityReference supplier = HotelProductHelper.getSupplier((HotelProduct)product);
        data.setSupplier(supplier);
        aggregator.aggregate((Object)supplier);
        String militaryClaimNumber = GeneralProductHelper.getMilitaryClaimNumber((BaseProduct)product);
        data.setMilitaryClaimNumber(militaryClaimNumber);
        aggregator.aggregate((Object)militaryClaimNumber);
        data.setSystemNumberPrefix(CommonProductHelper.HOTEL_AGREGATOR_SYSTEM_NUMBER_PREFIX);
        data.setStatus(product.getStatus());
        aggregator.aggregate((Enum)product.getStatus());
        data.setIssueDate(product.getIssueDate());
        data.setIssueDateTime(product.getIssueDate());
        data.setLocalIssueDate(product.getLocalIssueDate());
        data.setUnholdDate(product.getUnholdDate());
        data.setUnholdDateTime(product.getUnholdDate());
        data.setOnHold(Boolean.valueOf(HotelProductHelper.isOnHoldLastSell2((HotelProduct)product)));
        String systemNumber = product.getSystemNumber();
        ArrayList<String> systemNumbers = new ArrayList<String>();
        if (!TextUtil.isBlank((String)systemNumber)) {
            systemNumbers.add(systemNumber);
        }
        data.setSystemNumbers(systemNumbers);
        aggregator.aggregate(systemNumbers);
        data.setFirstSystemNumber((String)CollectionUtil.head(systemNumbers));
        TicketType ticketType = product.getTicketType() != null ? product.getTicketType() : TicketType.OWN;
        data.setTicketType(ticketType);
        aggregator.aggregate((Enum)ticketType);
        data.setChecked(Boolean.valueOf(product.isChecked()));
        data.setCompleted(Boolean.valueOf(product.isCompleted()));
        EntityReference clientRelationMediator = GeneralProductHelper.getClientRelationMediator((BaseProduct)product);
        data.setMediator(clientRelationMediator);
        aggregator.aggregate((Object)clientRelationMediator);
        data.setClient(product.getReservation().getBookingFile().getCustomerProfile());
        aggregator.aggregate((Object)product.getReservation().getBookingFile().getCustomerProfile());
        EntityReference subagencyRef = HotelProductHelper.getSubagency((HotelProduct)product);
        if (subagencyRef != null) {
            try {
                subagency = EntityStorage.get().resolve(subagencyRef);
                ArrayList<ProfileGroupReference> subagencyGroups = new ArrayList<ProfileGroupReference>();
                for (Object metadata : ((Organization)subagency.getEntity()).getMetadata()) {
                    if (metadata.getKey() == null || !metadata.getKey().getCode().equals(MetadataKey.KEY_ORGANIZATION_PROFILE_GROUP.name()) || metadata.getValue() == null) continue;
                    subagencyGroups.add((ProfileGroupReference)metadata.getValue());
                }
                data.setSubagencyGroups(subagencyGroups);
                aggregator.aggregate(subagencyGroups);
            }
            catch (Throwable e) {
                this.log.error("unable to load profile " + subagencyRef, e);
            }
        }
        try {
            EntityContainer client = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
            if (client != null) {
                String code = SystemHelper.findMetadataAsString((Collection)((Organization)client.getEntity()).getMetadata(), (MetadataKey)MetadataKey.KEY_ACCOUNTING_SYSTEM_CODE);
                code = code != null ? code : ((Organization)client.getEntity()).getCode();
                data.setClientAccountingCode(code);
                aggregator.aggregate((Object)code);
                ArrayList<ProfileGroupReference> clientGroups = new ArrayList<ProfileGroupReference>();
                for (Metadata metadata : ((Organization)client.getEntity()).getMetadata()) {
                    if (metadata.getKey() == null || !metadata.getKey().getCode().equals(MetadataKey.KEY_ORGANIZATION_PROFILE_GROUP.name()) || metadata.getValue() == null) continue;
                    clientGroups.add((ProfileGroupReference)metadata.getValue());
                }
                data.setClientGroups(clientGroups);
                aggregator.aggregate(clientGroups);
            }
        }
        catch (Throwable e) {
            this.log.error("unable to load profile " + product.getReservation().getBookingFile().getCustomerProfile(), e);
        }
        subagency = HotelProductHelper.getSubagency((HotelProduct)product);
        data.setSubagency((EntityReference)subagency);
        aggregator.aggregate((Object)subagency);
        EntityContainer clientContainer = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
        if (clientContainer != null) {
            data.setHolding(((Organization)clientContainer.getEntity()).getHolding());
            aggregator.aggregate((Object)((Organization)clientContainer.getEntity()).getHolding());
        }
        data.setSalesPoint(product.getSalesPoint());
        aggregator.aggregate((Object)product.getSalesPoint());
        data.setEticket(Boolean.valueOf(true));
        Date refuseDate = null;
        for (GeneralProductFop fop2 : HotelProductHelper.getClientFops((HotelProduct)product)) {
            if (!fop2.isRefused() || fop2.getOperationDate() == null || refuseDate != null && !refuseDate.after(fop2.getOperationDate())) continue;
            refuseDate = fop2.getOperationDate();
        }
        if (refuseDate != null) {
            data.setCancellationDate(refuseDate);
            aggregator.aggregate(refuseDate);
        }
        if ((equivalentFare = HotelProductHelper.getEquivalentFare((HotelProduct)product)) == null) {
            equivalentFare = BigDecimal.ZERO;
        }
        aggregator.aggregate((Object)equivalentFare);
        HashSet<String> passportNumbers = new HashSet<String>();
        HashSet<String> travellersNames = new HashSet<String>();
        HashSet<EntityReference> passengers = new HashSet<EntityReference>();
        for (Traveller traveller : product.getTravellers()) {
            if (traveller.getPassport() != null && traveller.getPassport().getNumber() != null) {
                passportNumbers.add(traveller.getPassport().getNumber());
            }
            if (traveller.getName() != null) {
                travellersNames.add(traveller.getName());
            }
            if (traveller.getPassenger() == null) continue;
            passengers.add(traveller.getPassenger());
        }
        data.setTravellersPassportsNumbers(passportNumbers);
        data.setTravellersNames(travellersNames);
        data.setPassengers(passengers);
        aggregator.aggregate(passportNumbers);
        aggregator.aggregate(travellersNames);
        OperationBatch batch = BookingHelper.getOperationBatch((BaseProduct)product);
        String sortingNumber = BookingHelper.getSortingTicketNumber((BaseProduct)product);
        if (sortingNumber == null) {
            sortingNumber = product.getSystemNumber();
        }
        data.setOperationBatch(batch);
        aggregator.aggregate((Object)sortingNumber);
        data.setSortingTicketNumber(sortingNumber);
        aggregator.aggregate((Enum)batch);
        data.setWorkflowStatus(product.getReservation().getBookingFile().getWorkflowStatus());
        aggregator.aggregate((Enum)product.getReservation().getBookingFile().getWorkflowStatus());
        data.setReservationStatus(product.getReservation().getStatus());
        aggregator.aggregate((Enum)product.getReservation().getStatus());
        data.setTravelSubject(TravelSubject.HOTEL_RESERVATION);
        aggregator.aggregate((Enum)TravelSubject.HOTEL_RESERVATION);
        data.setProductType(ProductType.HOTEL_RESERVATION);
        data.setDescription(TravelSubject.HOTEL_RESERVATION.toString());
        aggregator.aggregate((Enum)ProductType.HOTEL_RESERVATION);
        boolean refund = ProductStatusHelper.get().negatesPrice(product.getStatus());
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            BigDecimal taxesSum;
            Object hotelCountry;
            GeoLocation loc;
            boolean exchange;
            boolean bl = exchange = product.getStatus() == ProductStatus.EXCHANGE;
            if (product.getPreviousProduct() != null) {
                String relatedTicketNo = product.getPreviousProduct().getSystemNumber();
                aggregator.aggregate((Object)relatedTicketNo);
                data.setRelatedTicketNo(relatedTicketNo);
                if (refund) {
                    EntityReference sellAgent = product.getPreviousProduct().getCashier();
                    data.setSellAgent(sellAgent);
                    aggregator.aggregate((Object)sellAgent);
                }
            }
            if (product.getHotelLocation() != null && (loc = (GeoLocation)DictionaryCache.get().resolveReference(product.getHotelLocation())) != null && (hotelCountry = (Country)DictionaryCache.get().resolveReference(loc.getCountry())) != null && hotelCountry.isDomestic()) {
                data.setIncludeVat(Boolean.TRUE);
            }
            BigDecimal penalty = BigDecimal.ZERO;
            aggregator.aggregate((Object)equivalentFare);
            data.setPenalty(penalty);
            data.setEquivalentFare(refund ? equivalentFare.negate() : equivalentFare);
            data.setEquivalentFareCurrency(product.getGdsCurrency());
            data.setValid(Boolean.TRUE);
            data.setHasWarnings(Boolean.FALSE);
            data.setHasOtherErrors(Boolean.FALSE);
            data.setHasStockControlErrors(Boolean.FALSE);
            data.setHasRulesErrors(Boolean.FALSE);
            data.setHasShipmentErrors(Boolean.FALSE);
            data.setHasErrors(Boolean.FALSE);
            for (ValidationMessage message : product.getValidationMessages()) {
                if (message.getSeverity() == ValidationMessageSeverity.WARNING) {
                    data.setHasWarnings(Boolean.TRUE);
                }
                if (message.getSeverity() == ValidationMessageSeverity.USER_ERROR) {
                    data.setHasUserErrors(Boolean.TRUE);
                    data.setHasErrors(Boolean.TRUE);
                }
                if (message.getSeverity() == ValidationMessageSeverity.SHIPMENT_ERROR) {
                    data.setHasShipmentErrors(Boolean.TRUE);
                }
                if (message.getSeverity() != ValidationMessageSeverity.ERROR) continue;
                data.setHasErrors(Boolean.TRUE);
                if (message.getCategory() == ValidationMessageCategory.OTHER) {
                    data.setValid(Boolean.FALSE);
                    data.setHasOtherErrors(Boolean.TRUE);
                }
                if (message.getCategory() == ValidationMessageCategory.STOCK_CONTROL) {
                    data.setHasStockControlErrors(Boolean.TRUE);
                }
                if (message.getCategory() != ValidationMessageCategory.RULES) continue;
                data.setHasRulesErrors(Boolean.TRUE);
            }
            if (!product.getRooms().isEmpty()) {
                data.setFirstTravelDate(((Room)product.getRooms().get(0)).getCheckInDate());
                aggregator.aggregate(((Room)product.getRooms().get(0)).getCheckInDate());
                data.setLastTravelDate(((Room)product.getRooms().get(product.getRooms().size() - 1)).getCheckOutDate());
                aggregator.aggregate(((Room)product.getRooms().get(product.getRooms().size() - 1)).getCheckOutDate());
            }
            if ((taxesSum = HotelProductHelper.calculateTaxesEquivalentAmount((HotelProduct)product)) == null) {
                taxesSum = BigDecimal.ZERO;
            }
            aggregator.aggregate((Object)taxesSum);
            data.setTaxesSum(refund ? taxesSum.negate() : taxesSum);
            VatAmount price = BookingHelper.calculateProductPrice((BaseProduct)product, (ContractType)ContractType.CLIENT);
            BigDecimal totalSum = price.getTotal();
            data.setTotalSum(totalSum);
            aggregator.aggregate((Object)totalSum);
            data.setVatRate(price.getVat());
            data.setVatValue(price.getVatAmount());
            try {
                data.setVendorCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
                data.setVendorBonusValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund));
                data.setVendorFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund));
                data.setVendorCommissionRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true));
                data.setVendorBonusRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true));
                data.setVendorFeeRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true));
                data.setSubagencyCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
                data.setSubagencyBonusValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund));
                data.setSubagencyFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund));
                data.setSubagencyHiddenFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, (Set)GeneralProductHelper.hiddenCommissionCategories)), (boolean)refund));
                data.setSubagencyCommissionRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true));
                data.setSubagencyBonusRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true));
                data.setSubagencyFeeRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true));
                data.setClientCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
                data.setClientBonusValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund));
                data.setClientFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund));
                data.setClientServiceFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.serviceFeePropertyTypes, null, null)), (boolean)refund));
                data.setClientPaymentFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.paymentFeePropertyTypes, null, null)), (boolean)refund));
                data.setClientCommissionRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true));
                data.setClientBonusRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true));
                data.setClientFeeRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true));
            }
            catch (Exception e) {
                this.log.error("failed calculating commissions ", (Throwable)e);
            }
            Date date = null;
            EntityReference agent = null;
            Object hasClientDebt = Boolean.FALSE;
            HashSet<PaymentType> clientFopTypes = new HashSet<PaymentType>();
            HashSet<PaymentType> clientFeesFopTypes = new HashSet<PaymentType>();
            BigDecimal clientFOPAmount = null;
            BigDecimal clientFOPAddAmount = null;
            BigDecimal clientFOPTotalAddAmount = null;
            EnumSet<PaymentType> addPaymentTypes = EnumSet.allOf(PaymentType.class);
            addPaymentTypes.remove(PaymentType.TICKET);
            addPaymentTypes.remove(PaymentType.VOUCHER);
            addPaymentTypes.remove(PaymentType.MTD);
            addPaymentTypes.remove(PaymentType.MTD_AGENCY);
            addPaymentTypes.remove(PaymentType.CREDIT);
            addPaymentTypes.remove(PaymentType.CREDIT_CARD);
            for (HotelProductFop productFop : HotelProductHelper.getClientFops((HotelProduct)product)) {
                GeneralProductFop fop3 = HotelProductHelper.toGeneralProductFop((HotelProductFop)productFop);
                if (fop3.getEquivalentAmount() != null) {
                    BigDecimal fopAmount = fop3.getEquivalentAmount();
                    BigDecimal bigDecimal = clientFOPAmount = clientFOPAmount != null ? clientFOPAmount.add(fopAmount) : fopAmount;
                }
                if (!exchange && fop3.getEquivalentAmount() != null && addPaymentTypes.contains(fop3.getType()) && GeneralProductHelper.productFopTypes.contains(GeneralProductHelper.getFopType((GeneralProductFop)fop3))) {
                    BigDecimal bigDecimal = clientFOPAddAmount = clientFOPAddAmount != null ? clientFOPAddAmount.add(fop3.getEquivalentAmount()) : fop3.getEquivalentAmount();
                }
                if (!exchange && fop3.getEquivalentAmount() != null && addPaymentTypes.contains(fop3.getType()) && !GeneralProductHelper.discountFopTypes.contains(GeneralProductHelper.getFopType((GeneralProductFop)fop3))) {
                    BigDecimal bigDecimal = clientFOPTotalAddAmount = clientFOPTotalAddAmount != null ? clientFOPTotalAddAmount.add(fop3.getEquivalentAmount()) : fop3.getEquivalentAmount();
                }
                if (fop3.getType() != null) {
                    if (GeneralProductHelper.isServiceFop((GeneralProductFop)fop3)) {
                        clientFopTypes.add(fop3.getType());
                    } else {
                        clientFeesFopTypes.add(fop3.getType());
                    }
                }
                if (fop3.getOperationDate() == null) {
                    hasClientDebt = Boolean.TRUE;
                    continue;
                }
                if (date != null && !date.before(fop3.getOperationDate())) continue;
                date = fop3.getOperationDate();
                agent = fop3.getAgent();
            }
            if (refund && clientFOPAmount != null) {
                clientFOPAmount = clientFOPAmount.negate();
            }
            data.setClientFopAmount(clientFOPAmount);
            aggregator.aggregate((Object)clientFOPAmount);
            if (refund && clientFOPAddAmount != null) {
                clientFOPAddAmount = clientFOPAddAmount.negate();
            }
            data.setClientFopAddAmount(clientFOPAddAmount);
            aggregator.aggregate((Object)clientFOPAddAmount);
            if (refund && clientFOPTotalAddAmount != null) {
                clientFOPTotalAddAmount = clientFOPTotalAddAmount.negate();
            }
            data.setClientFopTotalAddAmount(clientFOPTotalAddAmount);
            aggregator.aggregate((Object)clientFOPTotalAddAmount);
            data.setClientFopTypes(clientFopTypes);
            aggregator.aggregate(clientFopTypes);
            data.setClientFeesFopTypes(clientFeesFopTypes);
            aggregator.aggregate(clientFeesFopTypes);
            data.setDateOfClientPayment(date);
            aggregator.aggregate(date);
            data.setClientFopAgent(agent);
            aggregator.aggregate((Object)agent);
            data.setHasClientDebt((Boolean)hasClientDebt);
            data.setPayers((Collection)GeneralProductHelper.getClientFops((BaseProduct)product).stream().filter(fop -> fop.getPayer() != null).map(fop -> fop.getPayer()).collect(Collectors.toSet()));
            date = null;
            HashSet<PaymentType> vendorFopTypes = new HashSet<PaymentType>();
            BigDecimal vendorFOPAmount = null;
            for (HotelProductFop productFop : HotelProductHelper.getVendorFops((HotelProduct)product)) {
                GeneralProductFop fop4 = HotelProductHelper.toGeneralProductFop((HotelProductFop)productFop);
                if (fop4.getEquivalentAmount() != null) {
                    BigDecimal fopAmount = fop4.getEquivalentAmount();
                    BigDecimal bigDecimal = vendorFOPAmount = vendorFOPAmount != null ? vendorFOPAmount.add(fopAmount) : fopAmount;
                }
                if (fop4.getType() != null) {
                    vendorFopTypes.add(fop4.getType());
                }
                if (fop4.getOperationDate() == null || date != null && !date.before(fop4.getOperationDate())) continue;
                date = fop4.getOperationDate();
            }
            if (refund && vendorFOPAmount != null) {
                vendorFOPAmount = vendorFOPAmount.negate();
            }
            data.setVendorFopAmount(vendorFOPAmount);
            aggregator.aggregate((Object)vendorFOPAmount);
            data.setDateOfVendorPayment(date);
            aggregator.aggregate(date);
            data.setVendorFopTypes(vendorFopTypes);
            aggregator.aggregate(vendorFopTypes);
            HashSet<PaymentType> subagentFopTypes = new HashSet<PaymentType>();
            HashSet<PaymentType> subagentFeesFopTypes = new HashSet<PaymentType>();
            List subagentFops = HotelProductHelper.getSubagentFops((HotelProduct)product, (boolean)false);
            if (subagentFops != null) {
                for (HotelProductFop productFop : subagentFops) {
                    GeneralProductFop fop5 = HotelProductHelper.toGeneralProductFop((HotelProductFop)productFop);
                    if (fop5.getType() == null) continue;
                    if (GeneralProductHelper.isServiceFop((GeneralProductFop)fop5)) {
                        subagentFopTypes.add(fop5.getType());
                        continue;
                    }
                    subagentFeesFopTypes.add(fop5.getType());
                }
            }
            data.setSubagentFopTypes(subagentFopTypes);
            data.setSubagentFeesFopTypes(subagentFeesFopTypes);
            HotelProductContractRelationData subagentContractRelation = HotelProductHelper.getSubagentContractRelation((HotelProduct)product, (boolean)false);
            if (subagentContractRelation != null) {
                BigDecimal subagencyContractFare = (BigDecimal)MiscUtil.guarded((Object)MiscUtil.sum((BigDecimal[])new BigDecimal[]{subagentContractRelation.getServiceData().getDetalization().getFare()}), (Object)subagentContractRelation.getServiceData().getDetalization().getAdditionalFee());
                data.setSubagencyContractFare(refund ? subagencyContractFare.negate() : subagencyContractFare);
                data.setSubagencyContractPenalty(MiscUtil.guarded((BigDecimal)subagentContractRelation.getServiceData().getDetalization().getPenalty()));
                data.setSubagencyContractTotalSum(BookingHelper.calculateProductPrice((BaseProduct)product, (ContractType)ContractType.SUBAGENCY).getTotal());
            }
            data.setHotelBaseSum(MainHotelProductIndexHandler.getBaseSum(product));
            data.setHotelComissionSum(MainHotelProductIndexHandler.getHotelCommissionSum(product));
        } else {
            data.setValid(Boolean.TRUE);
            data.setHasOtherErrors(Boolean.FALSE);
            BaseCommonProductIndexHandler.setVoidFees(data, (BaseProduct)product);
        }
        data.setAggregator(aggregator);
        this.updateStatisticalData(data, product.getStatisticalData(), (EntityReference<Organization>)product.getReservation().getBookingFile().getCustomerProfile());
        data.setAggregator(null);
        String comments = TextUtil.getFieldOrTrimToLength((String)product.getComments(), (int)255);
        data.setComments(comments);
        aggregator.aggregate((Object)comments);
        String hotelName = product.getHotelName();
        data.setHotelName(hotelName);
        aggregator.aggregate((Object)hotelName);
        DictionaryReference hotelLocation = product.getHotelLocation();
        data.setHotelCity(hotelLocation);
        aggregator.aggregate((Object)hotelLocation);
        DictionaryReference hotelCountry = HotelProductHelper.getHotelCountry((HotelProduct)product);
        data.setHotelCountry(hotelCountry);
        aggregator.aggregate((Object)hotelCountry);
        data.setHotelCheckInDate(HotelProductHelper.getCheckInDate((HotelProduct)product));
        data.setHotelCheckOutDate(HotelProductHelper.getCheckOutDate((HotelProduct)product));
        Set shipments = product.getFopDetalizations().values().stream().flatMap(item -> item.getComponents().stream()).filter(item -> item.getShipment() != null).map(item -> item.getShipment()).collect(Collectors.toSet());
        data.setShipments(shipments);
        aggregator.aggregate(shipments);
        data.setShipmentsDate(product.getShipmentsDate());
        data.setShipmentsDateSubagent(product.getShipmentsDateSubagent());
        data.setFopComponentsAllUsed(Boolean.valueOf(product.getFopDetalizations().values().stream().flatMap(item -> item.getComponents().stream()).allMatch(item -> item.getShipment() != null)));
        ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)product);
        String routeLine = handler.getRouteLine((BaseProduct)product);
        data.setRouteLine(TextUtil.getFieldOrTrimToLength((String)routeLine, (int)255));
        EntityReference clientPrepaymentDocument = null;
        EntityReference subagentPrepaymentDocument = null;
        for (EntityReference prepaymentDocumentReference : product.getPrepaymentDocuments()) {
            EntityContainer contract;
            EntityContainer prepaymentDocument = EntityStorage.get().resolve(prepaymentDocumentReference);
            if (prepaymentDocument == null || (contract = EntityStorage.get().resolve(((FinanceDocument)prepaymentDocument.getEntity()).getContract())) == null) continue;
            if (((Contract)contract.getEntity()).getContractType() == ContractType.CLIENT) {
                clientPrepaymentDocument = prepaymentDocumentReference;
                continue;
            }
            if (((Contract)contract.getEntity()).getContractType() != ContractType.SUBAGENCY) continue;
            subagentPrepaymentDocument = prepaymentDocumentReference;
        }
        data.setClientPrepaymentDocument(clientPrepaymentDocument);
        data.setSubagentPrepaymentDocument(subagentPrepaymentDocument);
        aggregator.aggregate(clientPrepaymentDocument);
        aggregator.aggregate(subagentPrepaymentDocument);
        Set receipts = product.getFopDetalizations().values().stream().flatMap(fopDetalization -> fopDetalization.getComponents().stream()).map(FopComponent::getReceipt).collect(Collectors.toSet());
        data.setReceipts(receipts);
        Set travellersGroups = GeneralProductHelper.getHandler((BaseProduct)product).getTravellers((BaseProduct)product).stream().map(item -> EntityStorage.get().resolve(item.getPassenger())).filter(item -> item != null).flatMap(item -> ((Person)item.getEntity()).getMetadata().stream()).filter(item -> item.getKey() != null && item.getValue() != null && MiscUtil.equals((Object)item.getKey().getCode(), (Object)MetadataKey.KEY_PERSON_PROFILE_GROUP.name())).map(item -> (ProfileGroupReference)item.getValue()).collect(Collectors.toSet());
        data.setTravellersGroups(travellersGroups);
        aggregator.aggregate(travellersGroups);
        Set agentsGroups = Optional.ofNullable(EntityStorage.get().resolve(GeneralProductHelper.getHandler((BaseProduct)product).findIssuingAgent((BaseProduct)product))).map(item -> ((Person)item.getEntity()).getMetadata()).orElse(Collections.emptyList()).stream().filter(item -> item.getKey() != null && item.getValue() != null && MiscUtil.equals((Object)item.getKey().getCode(), (Object)MetadataKey.KEY_PERSON_PROFILE_GROUP.name())).map(item -> (ProfileGroupReference)item.getValue()).collect(Collectors.toSet());
        data.setAgentsGroups(agentsGroups);
        ServiceLocationType serviceLocationType = HotelProductHelper.getServiceLocationType((HotelProduct)product);
        data.setServiceLocationType(serviceLocationType);
        aggregator.aggregate(agentsGroups);
    }
}

