/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleData;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.index.settings.IndexSettings;
import com.gridnine.xtrip.common.model.system.index.settings.IndexSettingsIndex;
import com.gridnine.xtrip.common.model.system.index.settings.IndexSettingsIndexData;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;
import java.util.Locale;

public class IndexSettingsIndexHandler
implements IndexHandler<IndexSettings, IndexSettingsIndex> {
    public Class<? extends BaseIndexData<IndexSettings, IndexSettingsIndex>> getDataClass() {
        return IndexSettingsIndexData.class;
    }

    public Class<IndexSettingsIndex> getIndexClass() {
        return IndexSettingsIndex.class;
    }

    public Class<IndexSettings> getEntityType() {
        return IndexSettings.class;
    }

    public void create(EntityContainer<IndexSettings> etc, Collection<BaseIndexData<IndexSettings, IndexSettingsIndex>> indexes) {
        MetaRegistry.get().getIndexes().get(etc.getUid());
        IndexSettingsIndexData data = new IndexSettingsIndexData();
        L10nString indexName = new L10nString();
        IndexType indexType = SystemHelper.getIndexType((String)etc.getUid());
        for (LocaleData loc : LocaleManager.get().getSupportedLocales()) {
            String displayName = indexType.getDisplayName(loc.getLocale());
            if (TextUtil.isBlank((String)displayName)) continue;
            L10nStringHelper.setValue((L10nString)indexName, (String)displayName, (Locale)loc.getLocale());
        }
        data.setIndexName(indexName);
        DataAggregator aggregator = new DataAggregator();
        IndexSettings entity = (IndexSettings)etc.getEntity();
        data.setUsed(Boolean.valueOf(entity.isUsed()));
        aggregator.aggregate(indexName);
        data.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<IndexSettings, IndexSettingsIndex>)data);
    }
}

