/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentHelper;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentIndex;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentIndexData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsuranceAccidentIndexHandler
implements IndexHandler<BookingFile, InsuranceAccidentIndex> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public Class<? extends BaseIndexData<BookingFile, InsuranceAccidentIndex>> getDataClass() {
        return InsuranceAccidentIndexData.class;
    }

    public Class<InsuranceAccidentIndex> getIndexClass() {
        return InsuranceAccidentIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public void create(EntityContainer<BookingFile> etc, Collection<BaseIndexData<BookingFile, InsuranceAccidentIndex>> indexes) {
        for (Reservation reservation : ((BookingFile)etc.getEntity()).getReservations()) {
            DataAggregator aggregator = new DataAggregator();
            for (BaseProduct product : reservation.getProducts()) {
                if (!(product instanceof InsuranceAccident)) continue;
                InsuranceAccidentIndexData data = new InsuranceAccidentIndexData();
                aggregator.reset();
                try {
                    InsuranceAccident airProduct = (InsuranceAccident)product;
                    this.updateData(data, aggregator, airProduct);
                    data.setAggregatedData(aggregator.toString());
                }
                catch (Exception e) {
                    this.log.error("unable to create index", (Throwable)e);
                    continue;
                }
                indexes.add((BaseIndexData<BookingFile, InsuranceAccidentIndex>)data);
            }
        }
    }

    protected void updateData(InsuranceAccidentIndexData data, DataAggregator aggregator, InsuranceAccident product) throws Exception {
        String notes;
        String bookingNumber = TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile());
        data.setBookingNumber(bookingNumber);
        aggregator.aggregate((Object)bookingNumber);
        data.setArrivalLocationName(product.getArrivalLocationName());
        aggregator.aggregate((Object)product.getArrivalLocationName());
        data.setDepartureLocationName(product.getDepartureLocationName());
        aggregator.aggregate((Object)product.getDepartureLocationName());
        data.setDepartureDate(product.getDepartureDate());
        aggregator.aggregate(product.getDepartureDate());
        data.setFlightNumber(product.getFlightNumber());
        aggregator.aggregate((Object)product.getFlightNumber());
        EntityReference agency = InsuranceAccidentHelper.getAgency((InsuranceAccident)product);
        data.setAgency(agency);
        aggregator.aggregate((Object)agency);
        data.setAgent(product.getAgent());
        aggregator.aggregate((Object)product.getAgent());
        data.setBlankOwner(product.getBlankOwner());
        aggregator.aggregate((Object)product.getBlankOwner());
        data.setBlankType(product.getBlankType());
        aggregator.aggregate((Object)product.getBlankType());
        Date refuseDate = null;
        for (GeneralProductFop fop : InsuranceAccidentHelper.getClientFops((InsuranceAccident)product)) {
            if (!fop.isRefused() || fop.getOperationDate() == null || refuseDate != null && !refuseDate.after(fop.getOperationDate())) continue;
            refuseDate = fop.getOperationDate();
        }
        if (refuseDate != null) {
            data.setCancellationDate(refuseDate);
            aggregator.aggregate(refuseDate);
        }
        data.setChecked(Boolean.valueOf(product.isChecked()));
        data.setCompleted(Boolean.valueOf(product.isCompleted()));
        data.setClient(product.getReservation().getBookingFile().getCustomerProfile());
        aggregator.aggregate((Object)product.getReservation().getBookingFile().getCustomerProfile());
        String accountingCode = ProfileHelper.findAccountingCode((EntityReference)product.getReservation().getBookingFile().getCustomerProfile());
        data.setClientAccountingCode(accountingCode);
        aggregator.aggregate((Object)accountingCode);
        boolean refund = product.getStatus() == ProductStatus.REFUND;
        data.setNavigationKey(product.getUid());
        List<String> recordLocators = IndexBuilderHelper.getRecordLocators(product.getReservation());
        data.setRecordLocators(recordLocators);
        aggregator.aggregate(recordLocators);
        List<GdsName> gdsNames = IndexBuilderHelper.getGdsNames(product.getReservation());
        data.setGdsNames(gdsNames);
        aggregator.aggregate(gdsNames);
        data.setDisplayedRecordLocator(CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)product.getReservation()));
        data.setDisplayedGdsName(CommonReservationGdsNameInfoHelper.getDisplayedGdsName((Reservation)product.getReservation()));
        data.setRulesGdsName(product.getReservation().getGdsNameInfo().getRulesGdsName());
        ProductStatus status = product.getStatus();
        data.setStatus(status);
        aggregator.aggregate((Enum)status);
        Date issueDate = product.getIssueDate();
        data.setIssueDate(issueDate);
        aggregator.aggregate(issueDate);
        data.setTicketNumber(product.getSystemNumber());
        aggregator.aggregate((Object)product.getSystemNumber());
        TicketType ticketType = product.getTicketType() != null ? product.getTicketType() : TicketType.OWN;
        data.setTicketType(ticketType);
        aggregator.aggregate((Enum)ticketType);
        data.setScn(product.getScn());
        aggregator.aggregate((Object)product.getScn());
        data.setPcc(product.getPcc());
        aggregator.aggregate((Object)product.getPcc());
        EntityReference subagency = InsuranceAccidentHelper.getSubagency((InsuranceAccident)product);
        data.setSubagency(subagency);
        aggregator.aggregate((Object)subagency);
        EntityContainer clientContainer = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
        if (clientContainer != null) {
            data.setHolding(((Organization)clientContainer.getEntity()).getHolding());
            aggregator.aggregate((Object)((Organization)clientContainer.getEntity()).getHolding());
        }
        data.setBranch(product.getBranch());
        aggregator.aggregate((Object)product.getBranch());
        data.setSalesPoint(product.getSalesPoint());
        aggregator.aggregate((Object)product.getSalesPoint());
        EntityReference supplier = InsuranceAccidentHelper.getSupplier((InsuranceAccident)product);
        data.setSupplier(supplier);
        aggregator.aggregate((Object)supplier);
        data.setEticket(Boolean.valueOf(product.isEticket()));
        Traveller traveller = BookingHelper.findTraveller((BookingFile)product.getReservation().getBookingFile(), (String)product.getTravellerUid());
        if (traveller != null) {
            data.setTravellerName(traveller.getName());
            aggregator.aggregate((Object)traveller.getName());
        }
        if (status != ProductStatus.VOID) {
            BaseProduct relatedProduct;
            if (product.getEquivalentSum() != null && status == ProductStatus.REFUND) {
                data.setEquivalentSum(product.getEquivalentSum().negate());
            } else {
                data.setEquivalentSum(product.getEquivalentSum());
            }
            aggregator.aggregate((Object)product.getEquivalentSum());
            if (refund && product.getPreviousProduct() != null) {
                data.setSellAgent(product.getPreviousProduct().getAgent());
                aggregator.aggregate((Object)product.getPreviousProduct().getAgent());
            }
            if ((relatedProduct = BookingHelper.findProduct((BookingFile)product.getReservation().getBookingFile(), (String)product.getRelatedProductUid())) != null) {
                ProductHandler ph = HandlersRegistry.get().findProductHandler(relatedProduct.getClass());
                for (String prodNumber : ph.getProductNumbers(relatedProduct)) {
                    data.setRelatedTicketNo(prodNumber);
                    aggregator.aggregate((Object)prodNumber);
                }
                data.setFirstTravelDate(ph.findFirstTravelDate(relatedProduct));
            }
            for (ValidationMessage message : product.getValidationMessages()) {
                if (message.getSeverity() != ValidationMessageSeverity.ERROR) continue;
                data.setHasErrors(Boolean.valueOf(true));
                if (message.getCategory() == ValidationMessageCategory.OTHER) {
                    data.setHasOtherErrors(Boolean.valueOf(true));
                }
                if (message.getCategory() == ValidationMessageCategory.STOCK_CONTROL) {
                    data.setHasStockControlErrors(Boolean.valueOf(true));
                }
                if (message.getCategory() != ValidationMessageCategory.RULES) continue;
                data.setHasRulesErrors(Boolean.valueOf(true));
            }
            data.setVendorCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)InsuranceAccidentHelper.getUnmodifiableCommissions((InsuranceAccident)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
            data.setVendorBonusValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)InsuranceAccidentHelper.getUnmodifiableCommissions((InsuranceAccident)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund));
            data.setVendorFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)InsuranceAccidentHelper.getUnmodifiableCommissions((InsuranceAccident)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund));
            data.setVendorCommissionRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)InsuranceAccidentHelper.getUnmodifiableCommissions((InsuranceAccident)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true));
            data.setVendorBonusRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)InsuranceAccidentHelper.getUnmodifiableCommissions((InsuranceAccident)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true));
            data.setVendorFeeRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)InsuranceAccidentHelper.getUnmodifiableCommissions((InsuranceAccident)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true));
            data.setSubagencyCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)InsuranceAccidentHelper.getUnmodifiableCommissions((InsuranceAccident)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
            data.setSubagencyBonusValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)InsuranceAccidentHelper.getUnmodifiableCommissions((InsuranceAccident)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund));
            data.setSubagencyFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)InsuranceAccidentHelper.getUnmodifiableCommissions((InsuranceAccident)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund));
            data.setSubagencyCommissionRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)InsuranceAccidentHelper.getUnmodifiableCommissions((InsuranceAccident)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true));
            data.setSubagencyBonusRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)InsuranceAccidentHelper.getUnmodifiableCommissions((InsuranceAccident)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true));
            data.setSubagencyFeeRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)InsuranceAccidentHelper.getUnmodifiableCommissions((InsuranceAccident)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true));
            data.setClientCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)InsuranceAccidentHelper.getUnmodifiableCommissions((InsuranceAccident)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
            data.setClientBonusValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)InsuranceAccidentHelper.getUnmodifiableCommissions((InsuranceAccident)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund));
            data.setClientFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)InsuranceAccidentHelper.getUnmodifiableCommissions((InsuranceAccident)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund));
            data.setClientCommissionRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)InsuranceAccidentHelper.getUnmodifiableCommissions((InsuranceAccident)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true));
            data.setClientBonusRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)InsuranceAccidentHelper.getUnmodifiableCommissions((InsuranceAccident)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true));
            data.setClientFeeRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)InsuranceAccidentHelper.getUnmodifiableCommissions((InsuranceAccident)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true));
            Date date = null;
            EntityReference agent = null;
            boolean hasClientDebt = false;
            Iterator clientFopTypes = new HashSet<PaymentType>();
            HashSet<PaymentType> clientFeesFopTypes = new HashSet<PaymentType>();
            BigDecimal clientFOPAmount = BigDecimal.ZERO;
            for (GeneralProductFop fop : InsuranceAccidentHelper.getClientFops((InsuranceAccident)product)) {
                if (fop.getEquivalentAmount() == null) continue;
                clientFOPAmount = clientFOPAmount.add(fop.getEquivalentAmount());
                if (fop.getType() != null) {
                    if (GeneralProductHelper.isServiceFop((GeneralProductFop)fop)) {
                        clientFopTypes.add(fop.getType());
                    } else {
                        clientFeesFopTypes.add(fop.getType());
                    }
                }
                if (fop.getOperationDate() == null) {
                    hasClientDebt = true;
                    continue;
                }
                if (date != null && !date.before(fop.getOperationDate())) continue;
                date = fop.getOperationDate();
                agent = fop.getAgent();
            }
            data.setClientFopAmount(clientFOPAmount);
            data.setClientFopTypes(clientFopTypes);
            data.setClientFeesFopTypes(clientFeesFopTypes);
            data.setDateOfClientPayment(date);
            aggregator.aggregate(date);
            data.setClientFopAgent(agent);
            aggregator.aggregate(agent);
            data.setHasClientDebt(Boolean.valueOf(hasClientDebt));
            date = null;
            HashSet<PaymentType> vendorFopTypes = new HashSet<PaymentType>();
            BigDecimal vendorFOPAmount = BigDecimal.ZERO;
            for (GeneralProductFop fop : InsuranceAccidentHelper.getVendorFops((InsuranceAccident)product)) {
                if (fop.getEquivalentAmount() == null) continue;
                vendorFOPAmount = vendorFOPAmount.add(fop.getEquivalentAmount());
                if (fop.getType() != null) {
                    vendorFopTypes.add(fop.getType());
                }
                if (fop.getOperationDate() == null || date != null && !date.before(fop.getOperationDate())) continue;
                date = fop.getOperationDate();
            }
            data.setVendorFopAmount(vendorFOPAmount);
            data.setVendorFopTypes(vendorFopTypes);
            data.setDateOfVendorPayment(date);
            HashSet<PaymentType> subagentFopTypes = new HashSet<PaymentType>();
            HashSet<PaymentType> subagentFeesFopTypes = new HashSet<PaymentType>();
            List subagentFops = InsuranceAccidentHelper.getSubagentFops((InsuranceAccident)product, (boolean)false);
            if (subagentFops != null) {
                for (GeneralProductFop fop : subagentFops) {
                    if (fop.getType() == null) continue;
                    if (GeneralProductHelper.isServiceFop((GeneralProductFop)fop)) {
                        subagentFopTypes.add(fop.getType());
                        continue;
                    }
                    subagentFeesFopTypes.add(fop.getType());
                }
            }
            data.setSubagentFopTypes(subagentFopTypes);
            data.setSubagentFeesFopTypes(subagentFeesFopTypes);
            data.setAgentPenaltyForProduct(BookingHelper.calculateAgentPenaltyForProduct((BaseProduct)product));
            data.setAgentPenaltyForCommissions(null);
            data.setAgentPenaltyForFees(BookingHelper.calculateAgentPenaltyForFees((BaseProduct)product));
        }
        data.setHasNotes(Boolean.valueOf((notes = product.getReservation().getBookingFile().getNotes()) != null && !notes.trim().isEmpty()));
        boolean inFinanceDocuments = IndexBuilderHelper.isInFinanceDocuments((BaseProduct)product);
        data.setInFinanceDocuments(Boolean.valueOf(inFinanceDocuments));
        boolean inDelivery = IndexBuilderHelper.isInDelivery((BaseProduct)product);
        data.setInDelivery(Boolean.valueOf(inDelivery));
        List costCodes = StatisticsHelper.findCostCenterCostCodes((StatisticalData)product.getStatisticalData(), (EntityReference)product.getReservation().getBookingFile().getCustomerProfile());
        if (!costCodes.isEmpty()) {
            String value = IndexBuilderHelper.getCostCodesJoinValue(costCodes, CostCode::getValue);
            String localValue = IndexBuilderHelper.getCostCodesJoinValue(costCodes, CostCode::getLocalValue);
            String englishValue = IndexBuilderHelper.getCostCodesJoinValue(costCodes, CostCode::getEnglishValue);
            data.setCostCenter(value);
            data.setCostCenterLocalValue(localValue);
            data.setCostCenterEnglishValue(englishValue);
            aggregator.aggregate((Object)value);
            aggregator.aggregate((Object)localValue);
            aggregator.aggregate((Object)englishValue);
            data.setCostCenterList(IndexBuilderHelper.getCostCodeValues(costCodes, CostCode::getValue));
            data.setCostCenterLocalValueList(IndexBuilderHelper.getCostCodeValues(costCodes, CostCode::getLocalValue));
            data.setCostCenterEnglishValueList(IndexBuilderHelper.getCostCodeValues(costCodes, CostCode::getEnglishValue));
        }
        String comments = TextUtil.getFieldOrTrimToLength((String)product.getComments(), (int)255);
        data.setComments(comments);
        aggregator.aggregate((Object)comments);
    }
}

