/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.CommonProductIndexData;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.MCOFees;
import com.gridnine.xtrip.common.model.booking.OperationBatch;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ProfileGroupReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MCOFeesHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.handlers.ServerHandlersRegistry;
import com.gridnine.xtrip.server.model.handlers.index.CommonIndexHandler;
import com.gridnine.xtrip.server.model.helpers.CommonProductHelper;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import com.gridnine.xtrip.server.model.index.BaseCommonProductIndexHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MCOFeesCommonProductIndexHandler
extends BaseCommonProductIndexHandler
implements IndexHandler<BookingFile, CommonProductIndex> {
    Logger log = LoggerFactory.getLogger(this.getClass());

    public Class<? extends BaseIndexData<BookingFile, CommonProductIndex>> getDataClass() {
        return CommonProductIndexData.class;
    }

    public Class<CommonProductIndex> getIndexClass() {
        return CommonProductIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public void create(EntityContainer<BookingFile> etc, Collection<BaseIndexData<BookingFile, CommonProductIndex>> indexes) {
        DataAggregator aggregator = new DataAggregator();
        for (Reservation reservation : ((BookingFile)etc.getEntity()).getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                if (!(baseProduct instanceof MCOFees)) continue;
                aggregator.reset();
                try {
                    CommonProductIndexData data = new CommonProductIndexData();
                    List handlers = ServerHandlersRegistry.get().findCommonIndexHandlers(this.getIndexClass());
                    for (CommonIndexHandler<BaseProduct, BookingFile, CommonProductIndex> commonIndexHandler : handlers) {
                        commonIndexHandler.updateData((BaseIndexData<BookingFile, CommonProductIndex>)data, aggregator, etc, baseProduct);
                    }
                    this.updateData(data, aggregator, etc, (MCOFees)baseProduct);
                    data.setAggregatedData(aggregator.toString());
                    indexes.add((BaseIndexData<BookingFile, CommonProductIndex>)data);
                }
                catch (Exception e) {
                    this.log.error("unable to create index", (Throwable)e);
                }
            }
        }
    }

    protected void updateData(CommonProductIndexData data, DataAggregator aggregator, EntityContainer<BookingFile> etc, MCOFees product) throws Exception {
        data.setNavigationKey(product.getUid());
        data.setNextProductUid(product.getNextMCO() == null ? null : product.getNextMCO().getUid());
        data.setReservationType(product.getReservation().getType());
        data.setBookingNumber(TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile()));
        aggregator.aggregate((Object)TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile()));
        data.setBookingCreateDate(product.getReservation().getBookingFile().getCreateDate());
        aggregator.aggregate(product.getReservation().getBookingFile().getCreateDate());
        data.setStatus(product.getStatus());
        aggregator.aggregate((Enum)product.getStatus());
        data.setIssueDate(product.getIssueDate());
        data.setIssueDateTime(product.getIssueDate());
        data.setLocalIssueDate(product.getLocalIssueDate());
        data.setUnholdDate(null);
        data.setUnholdDateTime(null);
        data.setBlankOwner(product.getAgency());
        data.setTimeLimit(product.getReservation().getTimeLimit());
        aggregator.aggregate(product.getReservation().getTimeLimit());
        data.setAgency(product.getAgency());
        aggregator.aggregate((Object)product.getAgency());
        data.setSupplier(product.getAgency());
        data.setTaxesSum(BigDecimal.ZERO);
        data.setTaxesForBlankSum(BigDecimal.ZERO);
        data.setOtherTaxesSum(BigDecimal.ZERO);
        if (product.getAgency() != null) {
            try {
                EntityContainer ctr = EntityStorage.get().resolve(product.getAgency());
                if (ctr != null) {
                    Airline airline = (Airline)DictionaryCache.get().resolveReference(((Organization)ctr.getEntity()).getAirline());
                    if (airline != null) {
                        data.setBlankOwnerAirlineNumber(airline.getAirlineNumber());
                    }
                    data.setBlankOwnerCode(((Organization)ctr.getEntity()).getCode());
                    data.setProviderCode(((Organization)ctr.getEntity()).getCode());
                }
            }
            catch (Exception e) {
                this.log.error("unable to resolve blank owner", (Throwable)e);
            }
            data.setProviderName(product.getAgency().toString());
        }
        ArrayList<String> systemNumbers = new ArrayList<String>();
        if (!TextUtil.isBlank((String)product.getScn())) {
            systemNumbers.add(product.getScn());
        }
        data.setSystemNumbers(systemNumbers);
        aggregator.aggregate(systemNumbers);
        data.setFirstSystemNumber((String)CollectionUtil.head(systemNumbers));
        data.setSystemNumberPrefix(CommonProductHelper.MCO_FEES_SYSTEM_NUMBER_PREFIX);
        data.setTicketType(TicketType.OWN);
        aggregator.aggregate((Enum)TicketType.OWN);
        ArrayList<String> scns = new ArrayList<String>();
        if (!TextUtil.isBlank((String)product.getScn())) {
            scns.add(product.getScn());
        }
        data.setSncs(scns);
        aggregator.aggregate(scns);
        data.setChecked(Boolean.valueOf(product.isChecked()));
        data.setCompleted(Boolean.valueOf(product.isCompleted()));
        data.setAgent(product.getAgent());
        aggregator.aggregate((Object)product.getAgent());
        data.setClient(product.getReservation().getBookingFile().getCustomerProfile());
        EntityReference clientRelationMediator = GeneralProductHelper.getClientRelationMediator((BaseProduct)product);
        data.setMediator(clientRelationMediator);
        aggregator.aggregate((Object)clientRelationMediator);
        aggregator.aggregate((Object)product.getReservation().getBookingFile().getCustomerProfile());
        try {
            EntityContainer client = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
            if (client != null) {
                String code = SystemHelper.findMetadataAsString((Collection)((Organization)client.getEntity()).getMetadata(), (MetadataKey)MetadataKey.KEY_ACCOUNTING_SYSTEM_CODE);
                code = code != null ? code : ((Organization)client.getEntity()).getCode();
                data.setClientAccountingCode(code);
                aggregator.aggregate((Object)code);
                ArrayList<ProfileGroupReference> clientGroups = new ArrayList<ProfileGroupReference>();
                for (Metadata metadata : ((Organization)client.getEntity()).getMetadata()) {
                    if (metadata.getKey() == null || !metadata.getKey().getCode().equals(MetadataKey.KEY_ORGANIZATION_PROFILE_GROUP.name()) || metadata.getValue() == null) continue;
                    clientGroups.add((ProfileGroupReference)metadata.getValue());
                }
                data.setClientGroups(clientGroups);
                aggregator.aggregate(clientGroups);
            }
        }
        catch (Throwable e) {
            this.log.error("unable to load profile " + product.getReservation().getBookingFile().getCustomerProfile(), e);
        }
        data.setSubagency(product.getAgency());
        aggregator.aggregate((Object)product.getAgency());
        EntityContainer clientContainer = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
        if (clientContainer != null) {
            data.setHolding(((Organization)clientContainer.getEntity()).getHolding());
            aggregator.aggregate((Object)((Organization)clientContainer.getEntity()).getHolding());
        }
        data.setPayers((Collection)GeneralProductHelper.getClientFops((BaseProduct)product).stream().filter(fop -> fop.getPayer() != null).map(fop -> fop.getPayer()).collect(Collectors.toSet()));
        data.setBranch(product.getBranch());
        aggregator.aggregate((Object)product.getBranch());
        data.setSalesPoint(product.getSalesPoint());
        aggregator.aggregate((Object)product.getSalesPoint());
        data.setBlankType(product.getBlankType());
        aggregator.aggregate((Object)product.getBlankType());
        data.setEticket(Boolean.valueOf(BookingHelper.isEticket((DictionaryReference)product.getBlankType())));
        HashSet<String> passportNumbers = new HashSet<String>();
        HashSet<String> travellersNames = new HashSet<String>();
        HashSet<EntityReference> passengers = new HashSet<EntityReference>();
        TravelSubject subject = null;
        for (String productUid : MCOFeesHelper.getRelatedProductUids((MCOFees)product)) {
            BaseProduct bp = BookingHelper.findProduct((BookingFile)product.getReservation().getBookingFile(), (String)productUid);
            if (bp == null) continue;
            ProductHandler handler = ProductHandler.of((BaseProduct)bp);
            for (Traveller trav : handler.getTravellers(bp)) {
                if (trav.getPassport() != null && trav.getPassport().getNumber() != null) {
                    passportNumbers.add(trav.getPassport().getNumber());
                }
                if (trav.getName() != null) {
                    travellersNames.add(trav.getName());
                }
                if (trav.getPassenger() == null) continue;
                passengers.add(trav.getPassenger());
            }
            if (subject != null) continue;
            subject = handler.findTravelSubject(bp);
        }
        data.setTravellersPassportsNumbers(passportNumbers);
        data.setTravellersNames(travellersNames);
        data.setPassengers(passengers);
        data.setTravelSubject(subject);
        aggregator.aggregate(passportNumbers);
        aggregator.aggregate(travellersNames);
        aggregator.aggregate(subject);
        String sortingNumber = product.getScn();
        OperationBatch batch = null;
        if (product.getStatus() != null) {
            switch (product.getStatus()) {
                case BOOKING: 
                case VOID: 
                case VOID_BOOKING: {
                    batch = OperationBatch.VOID;
                    break;
                }
                case REFUND: {
                    batch = OperationBatch.REFUND;
                    sortingNumber = product.getScn() + "3";
                    break;
                }
                case SELL: {
                    batch = OperationBatch.SELL;
                    break;
                }
            }
        }
        data.setOperationBatch(batch);
        aggregator.aggregate((Object)sortingNumber);
        data.setSortingTicketNumber(sortingNumber);
        aggregator.aggregate((Enum)batch);
        data.setWorkflowStatus(product.getReservation().getBookingFile().getWorkflowStatus());
        aggregator.aggregate((Enum)product.getReservation().getBookingFile().getWorkflowStatus());
        data.setReservationStatus(product.getReservation().getStatus());
        aggregator.aggregate((Enum)product.getReservation().getStatus());
        data.setTravelSubject(TravelSubject.AIR);
        aggregator.aggregate((Enum)ProductType.MCO_FEES);
        data.setProductType(ProductType.MCO_FEES);
        data.setDescription(TravelSubject.AIR.toString());
        data.setValid(Boolean.valueOf(true));
        data.setHasOtherErrors(Boolean.valueOf(false));
        data.setHasStockControlErrors(Boolean.valueOf(false));
        data.setHasRulesErrors(Boolean.valueOf(false));
        data.setHasShipmentErrors(Boolean.valueOf(false));
        data.setHasErrors(Boolean.valueOf(false));
        for (ValidationMessage message : product.getValidationMessages()) {
            if (message.getSeverity() == ValidationMessageSeverity.WARNING) {
                data.setHasWarnings(Boolean.valueOf(true));
            }
            if (message.getSeverity() == ValidationMessageSeverity.USER_ERROR) {
                data.setHasUserErrors(Boolean.valueOf(true));
                data.setHasErrors(Boolean.valueOf(true));
            }
            if (message.getSeverity() == ValidationMessageSeverity.SHIPMENT_ERROR) {
                data.setHasShipmentErrors(Boolean.valueOf(true));
            }
            if (message.getSeverity() != ValidationMessageSeverity.ERROR) continue;
            data.setHasErrors(Boolean.valueOf(true));
            if (message.getCategory() == ValidationMessageCategory.OTHER) {
                data.setValid(Boolean.valueOf(false));
                data.setHasOtherErrors(Boolean.valueOf(true));
            }
            if (message.getCategory() == ValidationMessageCategory.STOCK_CONTROL) {
                data.setHasStockControlErrors(Boolean.valueOf(true));
            }
            if (message.getCategory() != ValidationMessageCategory.RULES) continue;
            data.setHasRulesErrors(Boolean.valueOf(true));
        }
        String notes = product.getReservation().getBookingFile().getNotes();
        data.setHasNotes(Boolean.valueOf(notes != null && !notes.trim().isEmpty()));
        boolean inFinanceDocuments = IndexBuilderHelper.isInFinanceDocuments((BaseProduct)product);
        data.setInFinanceDocuments(Boolean.valueOf(inFinanceDocuments));
        boolean inDelivery = IndexBuilderHelper.isInDelivery((BaseProduct)product);
        data.setInDelivery(Boolean.valueOf(inDelivery));
        StringBuilder email = new StringBuilder();
        if (product.getReservation().getBookingFile() != null && product.getReservation().getBookingFile().getCustomer() != null) {
            for (Communication c : product.getReservation().getBookingFile().getCustomer().getCommunications()) {
                if (c == null || !CommunicationType.EMAIL.equals((Object)c.getType()) || TextUtil.isBlank((String)c.getSense())) continue;
                email = email.append(email.length() > 0 ? ", " + c.getSense() : c.getSense());
            }
        }
        if (!TextUtil.isBlank((String)email.toString())) {
            data.setEmail(TextUtil.adjustStringToLimit((String)email.toString(), (String)", ", (int)255));
            aggregator.aggregate((Object)email.toString());
        }
        data.setAggregator(aggregator);
        this.updateStatisticalData(data, product.getStatisticalData(), (EntityReference<Organization>)product.getReservation().getBookingFile().getCustomerProfile());
        data.setAggregator(null);
        Set shipments = product.getFopDetalizations().values().stream().flatMap(item -> item.getComponents().stream()).filter(item -> item.getShipment() != null).map(item -> item.getShipment()).collect(Collectors.toSet());
        data.setShipments(shipments);
        aggregator.aggregate(shipments);
        data.setShipmentsDate(product.getShipmentsDate());
        data.setShipmentsDateSubagent(product.getShipmentsDateSubagent());
        data.setFopComponentsAllUsed(Boolean.valueOf(product.getFopDetalizations().values().stream().flatMap(item -> item.getComponents().stream()).allMatch(item -> item.getShipment() != null)));
        String comments = TextUtil.getFieldOrTrimToLength((String)product.getComments(), (int)255);
        data.setComments(comments);
        aggregator.aggregate((Object)comments);
        EntityReference clientPrepaymentDocument = null;
        EntityReference subagentPrepaymentDocument = null;
        for (EntityReference prepaymentDocumentReference : product.getPrepaymentDocuments()) {
            EntityContainer contract;
            EntityContainer prepaymentDocument = EntityStorage.get().resolve(prepaymentDocumentReference);
            if (prepaymentDocument == null || (contract = EntityStorage.get().resolve(((FinanceDocument)prepaymentDocument.getEntity()).getContract())) == null) continue;
            if (((Contract)contract.getEntity()).getContractType() == ContractType.CLIENT) {
                clientPrepaymentDocument = prepaymentDocumentReference;
                continue;
            }
            if (((Contract)contract.getEntity()).getContractType() != ContractType.SUBAGENCY) continue;
            subagentPrepaymentDocument = prepaymentDocumentReference;
        }
        data.setClientPrepaymentDocument(clientPrepaymentDocument);
        data.setSubagentPrepaymentDocument(subagentPrepaymentDocument);
        aggregator.aggregate(clientPrepaymentDocument);
        aggregator.aggregate(subagentPrepaymentDocument);
        Set receipts = product.getFopDetalizations().values().stream().flatMap(fopDetalization -> fopDetalization.getComponents().stream()).map(FopComponent::getReceipt).collect(Collectors.toSet());
        data.setReceipts(receipts);
    }
}

