/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.MCOFees;
import com.gridnine.xtrip.common.model.booking.MCOFeesIndex;
import com.gridnine.xtrip.common.model.booking.MCOFeesIndexData;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.MCOFeesHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MCOFeesIndexHandler
implements IndexHandler<BookingFile, MCOFeesIndex> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public Class<? extends BaseIndexData<BookingFile, MCOFeesIndex>> getDataClass() {
        return MCOFeesIndexData.class;
    }

    public Class<MCOFeesIndex> getIndexClass() {
        return MCOFeesIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public void create(EntityContainer<BookingFile> etc, Collection<BaseIndexData<BookingFile, MCOFeesIndex>> indexes) {
        for (Reservation reservation : ((BookingFile)etc.getEntity()).getReservations()) {
            DataAggregator aggregator = new DataAggregator();
            for (BaseProduct product : reservation.getProducts()) {
                if (!(product instanceof MCOFees)) continue;
                MCOFeesIndexData data = new MCOFeesIndexData();
                aggregator.reset();
                try {
                    MCOFees airProduct = (MCOFees)product;
                    this.updateData(data, aggregator, airProduct);
                    data.setAggregatedData(aggregator.toString());
                }
                catch (Exception e) {
                    this.log.error("unable to create index", (Throwable)e);
                    continue;
                }
                indexes.add((BaseIndexData<BookingFile, MCOFeesIndex>)data);
            }
        }
    }

    protected void updateData(MCOFeesIndexData data, DataAggregator aggregator, MCOFees product) throws Exception {
        data.setTicketType(product.getTicketType());
        aggregator.aggregate((Enum)product.getTicketType());
        String bookingNumber = TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile());
        data.setBookingNumber(bookingNumber);
        aggregator.aggregate((Object)bookingNumber);
        data.setAgency(product.getAgency());
        aggregator.aggregate((Object)product.getAgency());
        EntityContainer clientContainer = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
        if (clientContainer != null) {
            data.setHolding(((Organization)clientContainer.getEntity()).getHolding());
            aggregator.aggregate((Object)((Organization)clientContainer.getEntity()).getHolding());
        }
        data.setAgent(product.getAgent());
        aggregator.aggregate((Object)product.getAgent());
        data.setBlankType(product.getBlankType());
        aggregator.aggregate((Object)product.getBlankType());
        data.setChecked(Boolean.valueOf(product.isChecked()));
        data.setCompleted(Boolean.valueOf(product.isCompleted()));
        data.setStatus(product.getStatus());
        aggregator.aggregate((Enum)product.getStatus());
        for (Object message : product.getValidationMessages()) {
            if (message.getSeverity() != ValidationMessageSeverity.ERROR) continue;
            data.setHasErrors(Boolean.valueOf(true));
            if (message.getCategory() == ValidationMessageCategory.OTHER) {
                data.setHasOtherErrors(Boolean.valueOf(true));
            }
            if (message.getCategory() == ValidationMessageCategory.STOCK_CONTROL) {
                data.setHasStockControlErrors(Boolean.valueOf(true));
            }
            if (message.getCategory() != ValidationMessageCategory.RULES) continue;
            data.setHasRulesErrors(Boolean.valueOf(true));
        }
        data.setIssueDate(product.getIssueDate());
        aggregator.aggregate(product.getIssueDate());
        data.setNavigationKey(product.getUid());
        data.setBranch(product.getBranch());
        aggregator.aggregate((Object)product.getBranch());
        data.setSalesPoint(product.getSalesPoint());
        aggregator.aggregate((Object)product.getSalesPoint());
        data.setScn(product.getScn());
        aggregator.aggregate((Object)product.getScn());
        data.setType(product.getType());
        aggregator.aggregate((Enum)product.getType());
        data.setTotal(product.getTotal());
        aggregator.aggregate((Object)product.getTotal());
        data.setFare(product.getTotal());
        aggregator.aggregate((Object)product.getTotal());
        data.setPaymentType(product.getPaymentType());
        aggregator.aggregate((Enum)product.getPaymentType());
        LinkedHashSet numbers = new LinkedHashSet();
        for (String uid : MCOFeesHelper.getRelatedProductUids((MCOFees)product)) {
            BaseProduct bp = BookingHelper.findProduct((BookingFile)product.getReservation().getBookingFile(), (String)uid);
            if (bp == null) continue;
            ProductHandler handler = HandlersRegistry.get().findProductHandler(bp.getClass());
            numbers.addAll(handler.getProductNumbers(bp));
        }
        data.setClientName(product.getClientName());
        aggregator.aggregate((Object)product.getClientName());
        data.setRelatedProductNumbers(numbers);
        aggregator.aggregate(numbers);
        aggregator.aggregate((Object)product.getPurpose());
        aggregator.aggregate((Object)product.getRemarks());
        boolean inFinanceDocuments = IndexBuilderHelper.isInFinanceDocuments((BaseProduct)product);
        data.setInFinanceDocuments(Boolean.valueOf(inFinanceDocuments));
        boolean inDelivery = IndexBuilderHelper.isInDelivery((BaseProduct)product);
        data.setInDelivery(Boolean.valueOf(inDelivery));
        List costCodes = StatisticsHelper.findCostCenterCostCodes((StatisticalData)product.getStatisticalData(), (EntityReference)product.getReservation().getBookingFile().getCustomerProfile());
        if (!costCodes.isEmpty()) {
            String value = IndexBuilderHelper.getCostCodesJoinValue(costCodes, CostCode::getValue);
            String localValue = IndexBuilderHelper.getCostCodesJoinValue(costCodes, CostCode::getLocalValue);
            String englishValue = IndexBuilderHelper.getCostCodesJoinValue(costCodes, CostCode::getEnglishValue);
            data.setCostCenter(value);
            data.setCostCenterLocalValue(localValue);
            data.setCostCenterEnglishValue(englishValue);
            aggregator.aggregate((Object)value);
            aggregator.aggregate((Object)localValue);
            aggregator.aggregate((Object)englishValue);
            data.setCostCenterList(IndexBuilderHelper.getCostCodeValues(costCodes, CostCode::getValue));
            data.setCostCenterLocalValueList(IndexBuilderHelper.getCostCodeValues(costCodes, CostCode::getLocalValue));
            data.setCostCenterEnglishValueList(IndexBuilderHelper.getCostCodeValues(costCodes, CostCode::getEnglishValue));
        }
        String comments = TextUtil.getFieldOrTrimToLength((String)product.getComments(), (int)255);
        data.setComments(comments);
        aggregator.aggregate((Object)comments);
    }
}

