/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.mail.MailDocument;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndexData;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;

public class MailDocumentBasicDocumentIndexHandler
implements IndexHandler<BaseFileDocument, BasicDocumentIndex> {
    public Class<BasicDocumentIndex> getIndexClass() {
        return BasicDocumentIndex.class;
    }

    public Class<BaseFileDocument> getEntityType() {
        return BaseFileDocument.class;
    }

    public Class<? extends BaseIndexData<BaseFileDocument, BasicDocumentIndex>> getDataClass() {
        return BasicDocumentIndexData.class;
    }

    public void create(EntityContainer<BaseFileDocument> etc, Collection<BaseIndexData<BaseFileDocument, BasicDocumentIndex>> indexes) {
        if (!MailDocument.class.isAssignableFrom(((BaseFileDocument)etc.getEntity()).getClass())) {
            return;
        }
        BasicDocumentIndexData data = new BasicDocumentIndexData();
        BaseFileDocument entity = (BaseFileDocument)etc.getEntity();
        data.setContentType(entity.getContentType());
        data.setCreated(entity.getCreated());
        data.setName(entity.getName());
        data.setTitle(TextUtil.getFieldOrTrimToLength((String)entity.getTitle(), (int)255));
        data.setCheckSum(entity.getCheckSum());
        data.setSize(entity.getContent() == null ? 0 : entity.getContent().length);
        data.setType(DocumentType.MAIL_DOCUMENT);
        data.setOwner(entity.getOwner());
        data.setNavigationKey(entity.getNavigationKey());
        DataAggregator aggregator = new DataAggregator();
        aggregator.aggregate((Object)entity.getName());
        aggregator.aggregate(entity.getCreated());
        aggregator.aggregate((Enum)entity.getContentType());
        aggregator.aggregate((Object)entity.getDescription());
        aggregator.aggregate((Object)entity.getTitle());
        aggregator.aggregate((Object)entity.getOwner());
        data.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<BaseFileDocument, BasicDocumentIndex>)data);
    }
}

