/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.MainHotelProductGuestIndex;
import com.gridnine.xtrip.common.model.booking.xtriphotels.MainHotelProductGuestIndexData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.PersonalNameImpl;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainHotelProductGuestsIndexHandler
implements IndexHandler<BookingFile, MainHotelProductGuestIndex> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void create(EntityContainer<BookingFile> etc, Collection<BaseIndexData<BookingFile, MainHotelProductGuestIndex>> indexes) {
        BookingFile bookingFile = (BookingFile)etc.getEntity();
        for (Reservation reservation : bookingFile.getReservations()) {
            for (BaseProduct product : reservation.getProducts()) {
                if (!(product instanceof HotelProduct)) continue;
                HotelProduct hotelProduct = (HotelProduct)product;
                MainHotelProductGuestIndexData data = new MainHotelProductGuestIndexData();
                try {
                    for (Traveller traveller : hotelProduct.getTravellers()) {
                        this.updateData(data, hotelProduct, bookingFile, traveller);
                    }
                }
                catch (Exception e) {
                    this.log.error("unable to create index", (Throwable)e);
                    continue;
                }
                indexes.add((BaseIndexData<BookingFile, MainHotelProductGuestIndex>)data);
            }
        }
    }

    protected void updateData(MainHotelProductGuestIndexData data, HotelProduct product, BookingFile bookingFile, Traveller traveller) throws Exception {
        PersonalNameImpl personalName = new PersonalNameImpl();
        TextUtil.splitFullName((String)traveller.getName(), (PersonalName)personalName);
        data.setFirstName(StringUtils.lowerCase((String)personalName.getFirstName()));
        data.setLastName(StringUtils.lowerCase((String)personalName.getLastName()));
        data.setPassenger(traveller.getPassenger());
        data.setClient(bookingFile.getCustomerProfile());
        Room firstRoom = (Room)CollectionUtil.head((Iterable)product.getRooms());
        data.setCheckInDate(firstRoom.getCheckInDate());
        data.setCheckOutDate(firstRoom.getCheckOutDate());
        data.setBookingWorkflowStatus(bookingFile.getWorkflowStatus());
        data.setReservationStatus(product.getReservation().getStatus());
        data.setHotelLocation(product.getHotelLocation());
        data.setNavigationKey(product.getUid());
    }

    public Class<? extends BaseIndexData<BookingFile, MainHotelProductGuestIndex>> getDataClass() {
        return MainHotelProductGuestIndexData.class;
    }

    public Class<MainHotelProductGuestIndex> getIndexClass() {
        return MainHotelProductGuestIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }
}

