/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalService;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalServiceStatus;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductFop;
import com.gridnine.xtrip.common.model.booking.xtriphotels.MainHotelProductIndex;
import com.gridnine.xtrip.common.model.booking.xtriphotels.MainHotelProductIndexData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.RoomSizeDict;
import com.gridnine.xtrip.common.model.dict.RoomSizeDictReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.handlers.standard.XtripHotelProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProductStatusHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainHotelProductIndexHandler
implements IndexHandler<BookingFile, MainHotelProductIndex> {
    Logger log = LoggerFactory.getLogger(this.getClass());

    static BigDecimal getBaseSum(HotelProduct product) {
        BigDecimal commissionsValue = GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.VENDOR));
        if (ProductStatusHelper.get().negatesPrice(product.getStatus())) {
            commissionsValue = MiscUtil.negate((BigDecimal)commissionsValue);
        }
        return MiscUtil.sum((BigDecimal[])new BigDecimal[]{MainHotelProductIndexHandler.getVendorProductPrice(product), MiscUtil.negate((BigDecimal)commissionsValue)});
    }

    private static String systemNumber(HotelProduct nextProduct) {
        return nextProduct == null ? null : nextProduct.getSystemNumber();
    }

    private static BigDecimal getVendorProductPrice(HotelProduct product) {
        XtripHotelProductHandler handler = (XtripHotelProductHandler)HandlersRegistry.get().findProductHandler(HotelProduct.class);
        return handler.calculateProductPrice(product, ContractType.VENDOR).getTotal();
    }

    static BigDecimal getHotelCommissionSum(HotelProduct product) {
        try {
            return MainHotelProductIndexHandler.maybeRefund(product, GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static BigDecimal maybeRefund(HotelProduct product, BigDecimal amount) {
        return product.getStatus() == ProductStatus.REFUND ? MiscUtil.negate((BigDecimal)amount) : amount;
    }

    public void create(EntityContainer<BookingFile> etc, Collection<BaseIndexData<BookingFile, MainHotelProductIndex>> indexes) {
        BookingFile bookingFile = (BookingFile)etc.getEntity();
        for (Reservation reservation : bookingFile.getReservations()) {
            DataAggregator aggregator = new DataAggregator();
            for (BaseProduct product : reservation.getProducts()) {
                if (!(product instanceof HotelProduct)) continue;
                HotelProduct hotelProduct = (HotelProduct)product;
                MainHotelProductIndexData data = new MainHotelProductIndexData();
                aggregator.reset();
                try {
                    this.updateData(data, aggregator, hotelProduct, bookingFile);
                    data.setAggregatedData(aggregator.toString());
                }
                catch (Exception e) {
                    this.log.error("unable to create index", (Throwable)e);
                    continue;
                }
                indexes.add((BaseIndexData<BookingFile, MainHotelProductIndex>)data);
            }
        }
    }

    protected void updateData(MainHotelProductIndexData data, DataAggregator aggregator, HotelProduct product, BookingFile bookingFile) throws Exception {
        String bookingNumber = TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile());
        data.setBookingNumber(bookingNumber);
        aggregator.aggregate((Object)bookingNumber);
        data.setProductUid(product.getUid());
        aggregator.aggregate((Object)product.getUid());
        data.setUnholdDate(product.getUnholdDate());
        data.setHotelDictionaryCode(product.getHotelPropertyId());
        aggregator.aggregate((Object)product.getHotelPropertyId());
        data.setNavigationKey(product.getUid());
        data.setProvider(product.getProvider());
        data.setSubProvider(product.getSubProvider());
        data.setAgentPenaltyForProduct(BookingHelper.calculateAgentPenaltyForProduct((BaseProduct)product));
        data.setAgentPenaltyForCommissions(null);
        data.setAgentPenaltyForFees(BookingHelper.calculateAgentPenaltyForFees((BaseProduct)product));
        aggregator.aggregate((Object)product.getUid());
        data.setHotelCheckInDate(HotelProductHelper.getCheckInDate((HotelProduct)product));
        data.setHotelCheckOutDate(HotelProductHelper.getCheckOutDate((HotelProduct)product));
        data.setHotelName(product.getHotelName());
        aggregator.aggregate((Object)product.getHotelName());
        data.setHotelCity(product.getHotelLocation());
        aggregator.aggregate((Object)product.getHotelLocation());
        DictionaryReference country = HotelProductHelper.getHotelCountry((HotelProduct)product);
        aggregator.aggregate((Object)country);
        data.setHotelCountry(country);
        ArrayList<String> travellersNames = new ArrayList<String>();
        for (Traveller traveller : product.getTravellers()) {
            if (TextUtil.isBlank((String)traveller.getName())) continue;
            travellersNames.add(traveller.getName());
            aggregator.aggregate((Object)traveller.getName());
        }
        data.setTravellersNames(travellersNames);
        EntityReference agency = HotelProductHelper.getAgency((HotelProduct)product);
        data.setAgency(agency);
        data.setBranch(product.getBranch());
        aggregator.aggregate((Object)agency);
        data.setBlankOwner(product.getBlankOwnerRef());
        aggregator.aggregate((Object)product.getBlankOwnerRef());
        Date refuseDate = null;
        for (GeneralProductFop fop : HotelProductHelper.getClientFops((HotelProduct)product)) {
            if (!fop.isRefused() || fop.getOperationDate() == null || refuseDate != null && !refuseDate.after(fop.getOperationDate())) continue;
            refuseDate = fop.getOperationDate();
        }
        if (refuseDate != null) {
            data.setCancellationDate(refuseDate);
            aggregator.aggregate(refuseDate);
        }
        data.setChecked(Boolean.valueOf(product.isChecked()));
        data.setCompleted(Boolean.valueOf(product.isCompleted()));
        data.setFinalized(product.getFinalized());
        data.setClient(product.getReservation().getBookingFile().getCustomerProfile());
        aggregator.aggregate((Object)product.getReservation().getBookingFile().getCustomerProfile());
        String accountingCode = ProfileHelper.findAccountingCode((EntityReference)product.getReservation().getBookingFile().getCustomerProfile());
        data.setClientAccountingCode(accountingCode);
        aggregator.aggregate((Object)accountingCode);
        data.setNavigationKey(product.getUid());
        List<String> recordLocators = IndexBuilderHelper.getRecordLocators(product.getReservation());
        data.setRecordLocators(recordLocators);
        aggregator.aggregate(recordLocators);
        data.setDisplayedRecordLocator(CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)product.getReservation()));
        List<GdsName> gdsNames = IndexBuilderHelper.getGdsNames(product.getReservation());
        data.setGdsNames(gdsNames);
        aggregator.aggregate(gdsNames);
        data.setDisplayedGdsName(CommonReservationGdsNameInfoHelper.getDisplayedGdsName((Reservation)product.getReservation()));
        data.setRulesGdsName(product.getReservation().getGdsNameInfo().getRulesGdsName());
        ProductStatus status = product.getStatus();
        data.setStatus(product.getStatus());
        data.setStatus(status);
        aggregator.aggregate((Enum)status);
        Date issueDate = product.getIssueDate();
        data.setIssueDate(issueDate);
        aggregator.aggregate(issueDate);
        data.setSystemNumber(product.getSystemNumber());
        aggregator.aggregate((Object)product.getSystemNumber());
        TicketType ticketType = product.getTicketType() != null ? product.getTicketType() : TicketType.OWN;
        data.setTicketType(ticketType);
        aggregator.aggregate((Enum)ticketType);
        EntityReference subagency = HotelProductHelper.getSubagency((HotelProduct)product);
        data.setSubagency(subagency);
        aggregator.aggregate((Object)subagency);
        EntityContainer clientContainer = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
        if (clientContainer != null) {
            data.setHolding(((Organization)clientContainer.getEntity()).getHolding());
            aggregator.aggregate((Object)((Organization)clientContainer.getEntity()).getHolding());
        }
        data.setSalesPoint(product.getSalesPoint());
        aggregator.aggregate((Object)product.getSalesPoint());
        data.setAgent(product.getCashier());
        aggregator.aggregate((Object)product.getCashier());
        try {
            String additionServicesDescription = product.getAdditionalServices().stream().map(s -> s.getType().toString()).filter(Objects::nonNull).collect(Collectors.joining(", "));
            data.setAdditionalServicesDescription(additionServicesDescription);
        }
        catch (Exception e) {
            this.log.error("failed to create additional services description", (Throwable)e);
        }
        BigDecimal additionServicesTotalSum = product.getAdditionalServices().stream().map(AdditionalService::getEquivalentAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, (a, b) -> b.add((BigDecimal)a));
        data.setAdditionalServicesTotalSum(MainHotelProductIndexHandler.maybeRefund(product, additionServicesTotalSum));
        Boolean value = product.getAdditionalServices().stream().map(AdditionalService::getStatus).filter(Objects::nonNull).reduce(Boolean.FALSE, (a, b) -> a != false || b == AdditionalServiceStatus.REQUESTED, (a, b) -> a != false || b != false);
        data.setHasAdditionalServiceOnRequest(value);
        data.setHotelChainCode(product.getHotelChainCode());
        EntityReference supplier = HotelProductHelper.getSupplier((HotelProduct)product);
        data.setSupplier(supplier);
        aggregator.aggregate((Object)supplier);
        data.setEticket(Boolean.valueOf(true));
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            boolean refund;
            boolean bl = refund = product.getStatus() == ProductStatus.REFUND;
            if (refund && product.getPreviousProduct() != null) {
                EntityReference sellAgent = product.getPreviousProduct().getCashier();
                data.setSellAgent(sellAgent);
                aggregator.aggregate((Object)sellAgent);
            }
            BigDecimal equivalentFare = HotelProductHelper.getEquivalentFare((HotelProduct)product);
            data.setEquivalentFare(MainHotelProductIndexHandler.maybeRefund(product, equivalentFare));
            data.setEquivalentFareCurrency(product.getGdsCurrency());
            BigDecimal totalSum = HotelProductHelper.calculateTotalEquivalentFare((HotelProduct)product);
            data.setTotalSum(MainHotelProductIndexHandler.maybeRefund(product, totalSum));
            Money fullBasePrice = HotelProductHelper.calcFullBasePrice((HotelProduct)product);
            if (fullBasePrice != null) {
                data.setTotalBaseSum(MainHotelProductIndexHandler.maybeRefund(product, fullBasePrice.getValue()));
            }
            BigDecimal equivalentTax = HotelProductHelper.calculateTaxesEquivalentAmount((HotelProduct)product);
            data.setEquivalentTax(MainHotelProductIndexHandler.maybeRefund(product, equivalentTax));
            aggregator.aggregate((Object)equivalentTax);
            for (ValidationMessage message : product.getValidationMessages()) {
                if (message.getSeverity() == ValidationMessageSeverity.WARNING) {
                    data.setHasWarnings(Boolean.TRUE);
                }
                if (message.getSeverity() != ValidationMessageSeverity.ERROR) continue;
                if (message.getCategory() == ValidationMessageCategory.OTHER) {
                    data.setHasOtherErrors(Boolean.TRUE);
                }
                if (message.getCategory() != ValidationMessageCategory.STOCK_CONTROL) continue;
                data.setHasStockControlErrors(Boolean.TRUE);
            }
            data.setVendorCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
            data.setVendorBonusValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund));
            data.setVendorFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund));
            data.setVendorCommissionRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true));
            data.setVendorBonusRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true));
            data.setVendorFeeRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true));
            data.setSubagencyCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
            data.setSubagencyBonusValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund));
            data.setSubagencyFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund));
            data.setSubagencyCommissionRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true));
            data.setSubagencyBonusRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true));
            data.setSubagencyFeeRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true));
            data.setClientCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
            data.setClientBonusValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund));
            data.setClientFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund));
            data.setClientCommissionRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true));
            data.setClientBonusRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true));
            data.setClientFeeRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)HotelProductHelper.getUnmodifiableCommissions((HotelProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true));
            Date date = null;
            EntityReference agent = null;
            boolean hasClientDebt = false;
            HashSet<PaymentType> clientFopTypes = new HashSet<PaymentType>();
            HashSet<PaymentType> clientFeesFopTypes = new HashSet<PaymentType>();
            BigDecimal clientFOPAmount = BigDecimal.ZERO;
            for (HotelProductFop fop : HotelProductHelper.getClientFops((HotelProduct)product)) {
                if (fop.getAmount() == null || fop.getAmount().getValue() == null) continue;
                clientFOPAmount = clientFOPAmount.add(fop.getAmount().getValue());
                if (fop.getType() != null) {
                    if (GeneralProductHelper.isServiceFop((GeneralProductFop)fop)) {
                        clientFopTypes.add(fop.getType());
                    } else {
                        clientFeesFopTypes.add(fop.getType());
                    }
                }
                if (fop.getOperationDate() == null) {
                    hasClientDebt = true;
                    continue;
                }
                if (date != null && !date.before(fop.getOperationDate())) continue;
                date = fop.getOperationDate();
                agent = fop.getAgent();
            }
            data.setClientFopAmount(MainHotelProductIndexHandler.maybeRefund(product, clientFOPAmount));
            data.setClientFopTypes(clientFopTypes);
            data.setClientFeesFopTypes(clientFeesFopTypes);
            data.setDateOfClientPayment(date);
            aggregator.aggregate(date);
            data.setClientFopAgent(agent);
            aggregator.aggregate(agent);
            data.setHasClientDebt(Boolean.valueOf(hasClientDebt));
            date = null;
            HashSet<PaymentType> vendorFopTypes = new HashSet<PaymentType>();
            BigDecimal vendorFOPAmount = BigDecimal.ZERO;
            for (HotelProductFop fop : HotelProductHelper.getVendorFops((HotelProduct)product)) {
                if (fop.getAmount() == null || fop.getAmount().getValue() == null) continue;
                vendorFOPAmount = vendorFOPAmount.add(fop.getAmount().getValue());
                if (fop.getType() != null) {
                    vendorFopTypes.add(fop.getType());
                }
                if (fop.getOperationDate() == null || date != null && !date.before(fop.getOperationDate())) continue;
                date = fop.getOperationDate();
            }
            data.setVendorFopAmount(MainHotelProductIndexHandler.maybeRefund(product, vendorFOPAmount));
            data.setVendorFopTypes(vendorFopTypes);
            data.setDateOfVendorPayment(date);
            HashSet<PaymentType> subagentFopTypes = new HashSet<PaymentType>();
            HashSet<PaymentType> subagentFeesFopTypes = new HashSet<PaymentType>();
            List subagentFops = HotelProductHelper.getSubagentFops((HotelProduct)product, (boolean)false);
            if (subagentFops != null) {
                for (HotelProductFop fop : subagentFops) {
                    if (fop.getType() == null) continue;
                    if (GeneralProductHelper.isServiceFop((GeneralProductFop)fop)) {
                        subagentFopTypes.add(fop.getType());
                        continue;
                    }
                    subagentFeesFopTypes.add(fop.getType());
                }
            }
            data.setSubagentFopAmount(MainHotelProductIndexHandler.maybeRefund(product, GeneralProductHelper.getSubagentFopAmount((BaseProduct)product)));
            data.setSubagentFopTypes(subagentFopTypes);
            data.setSubagentFeesFopTypes(subagentFeesFopTypes);
            data.setOnHold(Boolean.valueOf(HotelProductHelper.isOnHoldLastSell((HotelProduct)product)));
            data.setNextProductSystemNumber(MainHotelProductIndexHandler.systemNumber(product.getNextProduct()));
            data.setBaseSum(MainHotelProductIndexHandler.getBaseSum(product));
            data.setHotelComissionSum(MainHotelProductIndexHandler.getHotelCommissionSum(product));
            Money basePrice = HotelProductHelper.calcBasePrice((HotelProduct)product);
            if (basePrice != null) {
                data.setBaseFare(MainHotelProductIndexHandler.maybeRefund(product, basePrice.getValue()));
                data.setBaseFareCurrency(basePrice.getCurrency());
            }
        } else {
            BigDecimal vendorFeeValue = IndexBuilderHelper.getVoidFeeValue((BaseProduct)product, ContractType.VENDOR);
            BigDecimal subagencyFeeValue = IndexBuilderHelper.getVoidFeeValue((BaseProduct)product, ContractType.SUBAGENCY);
            BigDecimal clientFeeValue = IndexBuilderHelper.getVoidFeeValue((BaseProduct)product, ContractType.CLIENT);
            Double vendorFeeRate = IndexBuilderHelper.getVoidFeeRate((BaseProduct)product, ContractType.VENDOR);
            Double subagencyFeeRate = IndexBuilderHelper.getVoidFeeRate((BaseProduct)product, ContractType.SUBAGENCY);
            Double clientFeeRate = IndexBuilderHelper.getVoidFeeRate((BaseProduct)product, ContractType.CLIENT);
            data.setVendorFeeValue(vendorFeeValue);
            data.setSubagencyFeeValue(subagencyFeeValue);
            data.setClientFeeValue(clientFeeValue);
            data.setVendorFeeRate(vendorFeeRate);
            data.setSubagencyFeeRate(subagencyFeeRate);
            data.setClientFeeRate(clientFeeRate);
            data.setVendorFopAmount(vendorFeeValue);
            data.setSubagentFopAmount(subagencyFeeValue);
            data.setClientFopAmount(clientFeeValue);
        }
        List costCodes = StatisticsHelper.findCostCenterCostCodes((StatisticalData)product.getStatisticalData(), (EntityReference)product.getReservation().getBookingFile().getCustomerProfile());
        if (!costCodes.isEmpty()) {
            String value2 = IndexBuilderHelper.getCostCodesJoinValue(costCodes, CostCode::getValue);
            String localValue = IndexBuilderHelper.getCostCodesJoinValue(costCodes, CostCode::getLocalValue);
            String englishValue = IndexBuilderHelper.getCostCodesJoinValue(costCodes, CostCode::getEnglishValue);
            data.setCostCenter(value2);
            data.setCostCenterLocalValue(localValue);
            data.setCostCenterEnglishValue(englishValue);
            aggregator.aggregate((Object)value2);
            aggregator.aggregate((Object)localValue);
            aggregator.aggregate((Object)englishValue);
            data.setCostCenterList(IndexBuilderHelper.getCostCodeValues(costCodes, CostCode::getValue));
            data.setCostCenterLocalValueList(IndexBuilderHelper.getCostCodeValues(costCodes, CostCode::getLocalValue));
            data.setCostCenterEnglishValueList(IndexBuilderHelper.getCostCodeValues(costCodes, CostCode::getEnglishValue));
        }
        data.setBookingCreationDate(bookingFile.getCreateDate());
        data.setReservationCreationDate(product.getReservation().getResDate());
        data.setReservationType(product.getReservation().getType());
        String comments = TextUtil.getFieldOrTrimToLength((String)product.getComments(), (int)255);
        data.setComments(comments);
        aggregator.aggregate((Object)comments);
        List roomNames = product.getRooms().stream().filter(room -> !TextUtil.isBlank((String)room.getRoomName())).map(Room::getRoomName).collect(Collectors.toList());
        data.setRoomNames(roomNames);
        ArrayList<RoomSizeDictReference> roomSizes = new ArrayList<RoomSizeDictReference>();
        Integer numberOfPeople = null;
        for (Room room2 : product.getRooms()) {
            RoomSizeDict roomSize = (RoomSizeDict)DictionaryCache.get().findByCode(RoomSizeDict.class, room2.getRoomSize());
            if (roomSize != null && !roomSizes.contains(roomSize.toReference())) {
                roomSizes.add(roomSize.toReference());
            }
            if (numberOfPeople != null || room2.getNumberOfPeople() == null) continue;
            numberOfPeople = room2.getNumberOfPeople();
        }
        data.setRoomSizes(roomSizes);
        data.setHotelNumberOfPeople(numberOfPeople);
        data.setHotelGuaranteeType(product.getGuaranteeType());
        data.setHotelGuaranteeCode(product.getGuaranteeCode());
        if (product.getGuaranteeCard() != null) {
            data.setHotelGuaranteePrefix(product.getGuaranteeCard().getCardType());
        }
        if (CollectionUtil.isNotEmpty((Collection)product.getRooms())) {
            data.setIncludeVat(((Room)product.getRooms().get(0)).getVat());
            data.setVatRate(((Room)product.getRooms().get(0)).getEquivVatRate());
            data.setVatValue(((Room)product.getRooms().get(0)).getEquivalentVatPrice());
        }
    }

    public Class<? extends BaseIndexData<BookingFile, MainHotelProductIndex>> getDataClass() {
        return MainHotelProductIndexData.class;
    }

    public Class<MainHotelProductIndex> getIndexClass() {
        return MainHotelProductIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }
}

