/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.model.profile.ModelContract2Organization;
import com.gridnine.xtrip.common.model.profile.ModelContractIndex;
import com.gridnine.xtrip.common.model.profile.ModelContractIndexData;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Collectors;

public class ModelContractIndexHandler
implements IndexHandler<ModelContract, ModelContractIndex> {
    public Class<? extends BaseIndexData<ModelContract, ModelContractIndex>> getDataClass() {
        return ModelContractIndexData.class;
    }

    public Class<ModelContractIndex> getIndexClass() {
        return ModelContractIndex.class;
    }

    public Class<ModelContract> getEntityType() {
        return ModelContract.class;
    }

    public void create(EntityContainer<ModelContract> etc, Collection<BaseIndexData<ModelContract, ModelContractIndex>> indexes) {
        ModelContract entity = (ModelContract)etc.getEntity();
        ModelContractIndexData data = new ModelContractIndexData();
        DataAggregator aggregator = new DataAggregator();
        this.fillIndexData(etc, data, aggregator);
        String aggregatedData = aggregator.toString();
        if (aggregatedData.length() > 2712) {
            aggregatedData = aggregatedData.substring(0, 2712);
        }
        data.setAggregatedData(aggregatedData);
        aggregator.reset();
        indexes.add((BaseIndexData<ModelContract, ModelContractIndex>)data);
    }

    protected void fillIndexData(EntityContainer<ModelContract> etc, ModelContractIndexData data, DataAggregator aggregator) {
        ModelContract entity = (ModelContract)etc.getEntity();
        data.setName(entity.getName());
        data.setDisabled(Boolean.valueOf(entity.isDisabled()));
        data.setPriority(Double.valueOf(entity.getPriority()));
        data.setContractType(entity.getContractType());
        data.setSuppliers((Collection)entity.getSuppliers().stream().map(ModelContract2Organization::getOrganization).distinct().collect(Collectors.toList()));
        data.setCustomers((Collection)entity.getCustomers().stream().map(ModelContract2Organization::getOrganization).distinct().collect(Collectors.toList()));
        data.setSourceContract(entity.getSourceContract());
        aggregator.aggregate((Object)entity.getName());
        aggregator.aggregate((Object)entity.getNotes());
        if (entity.getRuleSet() == null) {
            return;
        }
        data.setRulesCount(Integer.valueOf(entity.getRuleSet().getRules().size()));
        HashSet<RuleTarget> targets = new HashSet<RuleTarget>();
        for (RuleSettings rs : entity.getRuleSet().getRules()) {
            if (rs.getTarget() == null) continue;
            targets.add(rs.getTarget());
        }
        data.setTargetNames((Collection)targets.stream().map(RuleTarget::getDisplayName).filter(Objects::nonNull).peek(str -> aggregator.aggregate(str)).sorted().collect(Collectors.toList()));
    }
}

