/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.DimensionType;
import com.gridnine.xtrip.common.model.helpers.BalanceHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.CreditLimitInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationBalanceIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationBalanceIndexData;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganizationBalanceIndexHandler
implements IndexHandler<Organization, OrganizationBalanceIndex> {
    private static transient Logger log = LoggerFactory.getLogger((String)OrganizationBalanceIndexHandler.class.getName());

    public Class<? extends BaseIndexData<Organization, OrganizationBalanceIndex>> getDataClass() {
        return OrganizationBalanceIndexData.class;
    }

    public Class<OrganizationBalanceIndex> getIndexClass() {
        return OrganizationBalanceIndex.class;
    }

    public Class<Organization> getEntityType() {
        return Organization.class;
    }

    public void create(EntityContainer<Organization> etc, Collection<BaseIndexData<Organization, OrganizationBalanceIndex>> indexes) throws Exception {
        Organization entity = (Organization)etc.getEntity();
        long start = System.currentTimeMillis();
        log.debug(String.format("creating organization balance index for organization %s", entity.toString()));
        List parentUids = ProfileHelper.getOrganizationParents(Collections.singletonList(etc.toReference())).stream().map(item -> item.getUid()).collect(Collectors.toList());
        List<EntityReference<Organization>> suppliers = this.searchSuppliersByContracts((EntityReference<Organization>)etc.toReference());
        for (EntityReference<Organization> supplier : suppliers) {
            OrganizationBalanceIndexData data = new OrganizationBalanceIndexData();
            DataAggregator aggregator = new DataAggregator();
            data.setParentUids(parentUids);
            this.updateData(data, aggregator, supplier, etc);
            data.setAggregatedData(aggregator.toString());
            indexes.add((BaseIndexData<Organization, OrganizationBalanceIndex>)data);
        }
        log.debug(String.format("%s organization balance indexes created for organization %s, it takes %s ms", Integer.toString(indexes.size()), etc.toReference(), Long.toString(System.currentTimeMillis() - start)));
    }

    protected void updateData(OrganizationBalanceIndexData data, DataAggregator aggregator, EntityReference<Organization> supplier, EntityContainer<Organization> etc) throws Exception {
        BigDecimal creditLimit = null;
        BigDecimal terminalCreditLimit = null;
        Date terminalCreditDateStart = null;
        Date terminalCreditDateEnd = null;
        boolean unlimited = false;
        CreditLimitInfo creditLimitInfo = ProfileHelper.getOrganizationCreditLimit(etc, supplier);
        if (creditLimitInfo != null) {
            creditLimit = creditLimitInfo.getCreditLimit();
            terminalCreditLimit = creditLimitInfo.getTerminalCreditLimit();
            terminalCreditDateStart = creditLimitInfo.getTerminalCreditDateStart();
            terminalCreditDateEnd = creditLimitInfo.getTerminalCreditDateEnd();
            unlimited = creditLimitInfo.isUnlimited();
        }
        data.setNavigationKey("finance" + ((Organization)etc.getEntity()).getUid());
        data.setDisabled(Boolean.valueOf(((Organization)etc.getEntity()).isDisabled()));
        EntityReference customer = etc.toReference();
        data.setClient(customer);
        aggregator.aggregate((Object)customer);
        data.setClientCode(((Organization)etc.getEntity()).getCode());
        aggregator.aggregate((Object)((Organization)etc.getEntity()).getCode());
        data.setClientTypes((Collection)((Organization)etc.getEntity()).getTypes());
        data.setAgency(supplier);
        aggregator.aggregate(supplier);
        data.setAgencyTypes((Collection)Optional.ofNullable(EntityStorage.get().resolve(supplier)).map(item -> ((Organization)item.getEntity()).getTypes()).orElse(Collections.emptySet()));
        BigDecimal creditAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{creditLimit, terminalCreditLimit != null && MiscUtil.isBetween((Date)terminalCreditDateStart, (Date)terminalCreditDateEnd, (Date)new Date()) ? terminalCreditLimit : null});
        BigDecimal supplierBalanceAmount = BalanceHelper.calculateBalance((EntityReference)customer, null, null, (ChartOfAccountsElementType)ChartOfAccountsElementType.SUPPLIER, (DictionaryReference)new CurrencyInfoReference(DictHelper.getLocalCurrencyCode()), Collections.singletonMap(DimensionType.ORGANIZATION, supplier));
        BigDecimal supplierCommissionBalanceAmount = BalanceHelper.calculateBalance((EntityReference)customer, null, null, (ChartOfAccountsElementType)ChartOfAccountsElementType.SUPPLIER_COMMISSION, (DictionaryReference)new CurrencyInfoReference(DictHelper.getLocalCurrencyCode()), Collections.singletonMap(DimensionType.ORGANIZATION, supplier));
        Date yesterdayDate = MiscUtil.setDayEndTime((Date)MiscUtil.addDaysToDate((Date)new Date(), (int)-1));
        BigDecimal supplierYesterdayBalanceAmount = BalanceHelper.calculateBalance((EntityReference)customer, (Date)yesterdayDate, null, (ChartOfAccountsElementType)ChartOfAccountsElementType.SUPPLIER, (DictionaryReference)new CurrencyInfoReference(DictHelper.getLocalCurrencyCode()), Collections.singletonMap(DimensionType.ORGANIZATION, supplier));
        BigDecimal supplierCommissionYesterdayBalanceAmount = BalanceHelper.calculateBalance((EntityReference)customer, (Date)yesterdayDate, null, (ChartOfAccountsElementType)ChartOfAccountsElementType.SUPPLIER_COMMISSION, (DictionaryReference)new CurrencyInfoReference(DictHelper.getLocalCurrencyCode()), Collections.singletonMap(DimensionType.ORGANIZATION, supplier));
        Date endOfPrevMonthDate = MiscUtil.getMonthEnd((Date)MiscUtil.addMonthsToDate((Date)new Date(), (int)-1));
        BigDecimal supplierEndOfPrevMonthBalanceAmount = BalanceHelper.calculateBalance((EntityReference)customer, (Date)endOfPrevMonthDate, null, (ChartOfAccountsElementType)ChartOfAccountsElementType.SUPPLIER, (DictionaryReference)new CurrencyInfoReference(DictHelper.getLocalCurrencyCode()), Collections.singletonMap(DimensionType.ORGANIZATION, supplier));
        BigDecimal supplierCommissionEndOfPrevMonthBalanceAmount = BalanceHelper.calculateBalance((EntityReference)customer, (Date)endOfPrevMonthDate, null, (ChartOfAccountsElementType)ChartOfAccountsElementType.SUPPLIER_COMMISSION, (DictionaryReference)new CurrencyInfoReference(DictHelper.getLocalCurrencyCode()), Collections.singletonMap(DimensionType.ORGANIZATION, supplier));
        BigDecimal supplierHoldServiceBalanceAmount = BalanceHelper.calculateBalance((EntityReference)customer, null, null, (ChartOfAccountsElementType)ChartOfAccountsElementType.SUPPLIER_HOLD_SERVICE, (DictionaryReference)new CurrencyInfoReference(DictHelper.getLocalCurrencyCode()), Collections.singletonMap(DimensionType.ORGANIZATION, supplier));
        BigDecimal balanceAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{supplierBalanceAmount, supplierCommissionBalanceAmount});
        BigDecimal yesterdayBalanceAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{supplierYesterdayBalanceAmount, supplierCommissionYesterdayBalanceAmount});
        BigDecimal endOfPreviousMonthBalanceAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{supplierEndOfPrevMonthBalanceAmount, supplierCommissionEndOfPrevMonthBalanceAmount});
        BigDecimal availableAmount = !unlimited ? MiscUtil.sum((BigDecimal[])new BigDecimal[]{supplierBalanceAmount, creditAmount}) : BigDecimal.valueOf(Integer.MAX_VALUE);
        BigDecimal availableAmountIncludingCommission = !unlimited ? MiscUtil.sum((BigDecimal[])new BigDecimal[]{supplierBalanceAmount, supplierCommissionBalanceAmount, creditAmount}) : BigDecimal.valueOf(Integer.MAX_VALUE);
        data.setSupplierBalanceAmount(supplierBalanceAmount);
        data.setSupplierCommissionBalanceAmount(supplierCommissionBalanceAmount);
        data.setSupplierHoldServiceBalanceAmount(supplierHoldServiceBalanceAmount);
        data.setBalanceAmount(balanceAmount);
        data.setYesterdayBalanceAmount(yesterdayBalanceAmount);
        data.setEndOfPreviousMonthBalanceAmount(endOfPreviousMonthBalanceAmount);
        data.setAvailableAmount(availableAmount);
        data.setAvailableAmountIncludingCommission(availableAmountIncludingCommission);
        data.setUnlimited(Boolean.valueOf(unlimited));
        data.setCreditLimit(creditLimit);
        data.setTerminalCreditLimit(terminalCreditLimit);
        data.setTerminalCreditDateStart(terminalCreditDateStart);
        data.setTerminalCreditDateEnd(terminalCreditDateEnd);
        data.setRegistrationId(((Organization)etc.getEntity()).getRegistrationId());
        aggregator.aggregate((Object)((Organization)etc.getEntity()).getRegistrationId());
        data.setKpp(((Organization)etc.getEntity()).getKpp());
        aggregator.aggregate((Object)((Organization)etc.getEntity()).getKpp());
    }

    private List<EntityReference<Organization>> searchSuppliersByContracts(EntityReference<Organization> customer) {
        SearchQuery query = new SearchQuery();
        query.getPreferredProperties().add(ContractIndex.Property.supplier.name());
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.customer.name(), customer));
        return EntityStorage.get().search(ContractIndex.class, query).getData().stream().map(ContractIndex::getSupplier).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }
}

