/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.ProfileGroupReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommunicationFormat;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.ExternalSystemCode;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationIndexData;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.ProfileKeyContactPerson;
import com.gridnine.xtrip.common.model.profile.SabreProfilesUniqueIDSettings;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.entity.LogicalEntityStorage;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.index.OrganizationMetadataIndexHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganizationIndexHandler
implements IndexHandler<Organization, OrganizationIndex> {
    private static transient Logger log = LoggerFactory.getLogger((String)OrganizationMetadataIndexHandler.class.getName());

    public Class<? extends BaseIndexData<Organization, OrganizationIndex>> getDataClass() {
        return OrganizationIndexData.class;
    }

    public Class<OrganizationIndex> getIndexClass() {
        return OrganizationIndex.class;
    }

    public Class<Organization> getEntityType() {
        return Organization.class;
    }

    public void create(EntityContainer<Organization> etc, Collection<BaseIndexData<Organization, OrganizationIndex>> indexes) {
        OrganizationIndexData data = new OrganizationIndexData();
        DataAggregator aggregator = new DataAggregator();
        this.updateData(data, aggregator, etc);
        data.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<Organization, OrganizationIndex>)data);
    }

    protected void updateData(OrganizationIndexData data, DataAggregator aggregator, EntityContainer<Organization> etc) {
        EntityContainer authorCtr;
        EntityReference organizationReference = etc.toReference();
        Organization entity = (Organization)etc.getEntity();
        LoggerFactory.getLogger(this.getClass()).debug("creating organization index for organization " + entity.toString());
        boolean dataSourceModified = true;
        try {
            dataSourceModified = LogicalEntityStorage.isDataSourceModified((VersionInfo)etc.getVersionInfo());
        }
        catch (Exception e) {
            log.error("unable to check data source", (Throwable)e);
        }
        if (dataSourceModified) {
            data.setDataSource(etc.getVersionInfo().getDataSource());
        }
        data.setNavigationKey(entity.getUid());
        data.setDisabled(Boolean.valueOf(entity.isDisabled()));
        data.setCode(MiscUtil.guarded((String)entity.getCode()));
        data.setClientId(entity.getClientID());
        data.setName(entity.getFullName());
        data.setAirline(entity.getAirline());
        List addresses = ProfileHelper.getOrganizationAddresses((Organization)entity);
        data.setAddressLegal(MiscUtil.guarded((String)ProfileHelper.buildFullAddress((Address)ProfileHelper.filterAddresses((Collection)addresses, (AddressType)AddressType.LEGAL), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false)));
        data.setAddressFactual(MiscUtil.guarded((String)ProfileHelper.buildFullAddress((Address)ProfileHelper.filterAddresses((Collection)addresses, (AddressType)AddressType.FACTUAL), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false)));
        data.setAddressContact(MiscUtil.guarded((String)ProfileHelper.buildFullAddress((Address)ProfileHelper.filterAddresses((Collection)addresses, (AddressType)AddressType.CONTACT), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false)));
        data.setAddressDelivery(MiscUtil.guarded((String)ProfileHelper.buildFullAddress((Address)ProfileHelper.filterAddresses((Collection)addresses, (AddressType)AddressType.DELIVERY), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false)));
        ArrayList<String> bankAccounts = new ArrayList<String>();
        for (BankAccount account : entity.getBankAccounts()) {
            if (TextUtil.isBlank((String)account.getCorrespondentAccount())) continue;
            bankAccounts.add(account.getCorrespondentAccount() != null ? account.getBankName() + ": " + account.getCorrespondentAccount() : account.getBankName());
        }
        data.setBankAccounts(bankAccounts);
        HashSet<String> phones = new HashSet<String>();
        ArrayList<String> communications = new ArrayList<String>();
        for (Communication communication : entity.getCommunications()) {
            if (TextUtil.isBlank((String)communication.getSense())) continue;
            CommunicationFormat phoneFormat = new CommunicationFormat("+C (T) N #I");
            CommunicationFormat emailFormat = new CommunicationFormat("N");
            CommunicationFormat webFormat = new CommunicationFormat("N");
            String communicationString = null;
            boolean phone = false;
            if (communication.getType() != null) {
                switch (communication.getType()) {
                    case WORK_PHONE: 
                    case HOME_PHONE: 
                    case FAX: 
                    case MOBILE: 
                    case AGENCY: 
                    case HOTEL: 
                    case CELL: 
                    case EMERGENCY: {
                        communicationString = phoneFormat.format(communication);
                        phone = true;
                        break;
                    }
                    case EMAIL: {
                        communicationString = emailFormat.format(communication);
                        phone = false;
                        break;
                    }
                    case WEB: {
                        communicationString = webFormat.format(communication);
                        phone = false;
                    }
                }
            }
            if (communicationString == null) continue;
            if (phone) {
                phones.add(communicationString);
            }
            communications.add(communication.getType() != null ? communication.getType() + ": " + communicationString : communicationString);
        }
        data.setCommunications(communications);
        data.setPhones(phones);
        data.setPreferredLocale(entity.getPreferredLocale());
        data.setAbroad(Boolean.valueOf(entity.isForeign()));
        data.setKpp(entity.getKpp());
        data.setLegalForm(entity.getLegalForm());
        data.setRegistrationId(entity.getRegistrationId());
        data.setBin(entity.getBin());
        data.setVatSeriesNumber(entity.getVatSeriesNumber());
        data.setVatSeriesDate(entity.getVatSeriesDate());
        data.setAuthor(entity.getAuthor());
        aggregator.aggregate((Object)entity.getAuthor());
        Set authorEmploymentsUids = Collections.emptySet();
        if (entity.getAuthor() != null && (authorCtr = EntityStorage.get().resolve(entity.getAuthor())) != null) {
            authorEmploymentsUids = ProfileHelper.getEmploymentsRefs((Person)((Person)authorCtr.getEntity()), (boolean)false).stream().map(it -> it.getUid()).collect(Collectors.toSet());
        }
        data.setAuthorEmploymentsUids(authorEmploymentsUids);
        data.setShortName(entity.getShortName());
        String shortNameEng = L10nStringHelper.getValue((L10nString)entity.getShortName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true);
        if (!TextUtil.isBlank((String)shortNameEng)) {
            shortNameEng = shortNameEng.toUpperCase();
        }
        data.setEnglishShortName(shortNameEng);
        data.setSimpleTaxed(Boolean.valueOf(entity.isSimpleTaxed()));
        data.setParent(entity.getParent());
        String tchAgencyCode = SystemHelper.findMetadataAsString((Collection)entity.getMetadata(), (MetadataKey)MetadataKey.KEY_TCH_AGENCY_CODE);
        data.setTchAgencyCode(tchAgencyCode);
        String taAgencyCode = SystemHelper.findMetadataAsString((Collection)entity.getMetadata(), (MetadataKey)MetadataKey.KEY_TA_AGENCY_CODE);
        data.setTaAgencyCode(taAgencyCode);
        data.setTypes((Collection)entity.getTypes());
        data.setBookingPccs((Collection)entity.getBookingPccs());
        ArrayList<ProfileGroupReference> groups = new ArrayList<ProfileGroupReference>();
        ArrayList<EntityReference> accountManagers = new ArrayList<EntityReference>();
        String brandCodeOwner = "";
        String brandCodeValue = "";
        HashSet<String> filialUids = new HashSet<String>();
        HashSet<String> filialNames = new HashSet<String>();
        for (Metadata metadata : entity.getMetadata()) {
            if (metadata.getKey() == null || metadata.getValue() == null) continue;
            if (metadata.getKey().getCode().equals(MetadataKey.KEY_ORGANIZATION_PROFILE_GROUP.name())) {
                groups.add((ProfileGroupReference)metadata.getValue());
            }
            if (metadata.getKey().getCode().equals(MetadataKey.KEY_ORGANIZATION_BRAND_CODE_OWNER.name())) {
                brandCodeOwner = (String)metadata.getValue();
            }
            if (metadata.getKey().getCode().equals(MetadataKey.KEY_ORGANIZATION_BRAND_CODE_VALUE.name())) {
                brandCodeValue = (String)metadata.getValue();
            }
            if (metadata.getKey().getCode().equals(MetadataKey.KEY_ORGANIZATION_AGENCY_SUBDIVISION.name()) && metadata.getValue() instanceof EntityReference) {
                EntityReference orgRef = (EntityReference)metadata.getValue();
                filialNames.add(orgRef.getCaption());
                filialUids.add(orgRef.getUid());
            }
            if (!metadata.getKey().getCode().equals("KEY_ORGANIZATION_ACCOUNT_MANAGER") || !(metadata.getValue() instanceof EntityReference)) continue;
            accountManagers.add((EntityReference)metadata.getValue());
        }
        data.setGroups(groups);
        data.setBrandCodeOwner(brandCodeOwner);
        data.setBrandCodeValue(brandCodeValue);
        data.setFilialNames(filialNames);
        data.setFilialUids(filialUids);
        data.setAccountManagers(accountManagers);
        data.setNotSynchronizeWithSabreProfile(Boolean.valueOf(entity.isNotSynchronizeWithSabreProfile()));
        data.setSabreProfilesLoadAllowed(Boolean.valueOf(entity.isSabreProfilesLoadAllowed()));
        Set employeeCategories = entity.getEmployeeCategories().stream().filter(Objects::nonNull).filter(cat -> cat.getName() != null).map(cat -> cat.getName().toString()).filter(Objects::nonNull).collect(Collectors.toSet());
        data.setEmployeeCategories(employeeCategories);
        ArrayList<String> parentUids = new ArrayList<String>();
        EntityReference parent = entity.getParent();
        while (parent != null && !parentUids.contains(parent.getUid())) {
            parentUids.add(parent.getUid());
            EntityContainer parentContainer = EntityStorage.get().resolve(parent);
            parent = parentContainer != null ? ((Organization)parentContainer.getEntity()).getParent() : null;
        }
        data.setParentUids(parentUids);
        data.setKeyContacts((Collection)entity.getKeyContacts().stream().map(ProfileKeyContactPerson::getPerson).collect(Collectors.toList()));
        data.setHolding(entity.getHolding());
        data.setSabreProfilesLastSyncDate(entity.getSabreProfilesLastSyncDate());
        data.setSabreProfilesLastSyncAttemptDate(entity.getSabreProfilesLastSyncAttemptDate());
        data.setSabreProfilesLastSyncStatus(entity.getSabreProfilesLastSyncStatus());
        data.setSabreProfilesLastOperationType(entity.getSabreProfilesLastOperationType());
        List sabreProfilesMessages = entity.getSabreProfilesMessages().stream().filter(Objects::nonNull).map(Message::getMessage).filter(Objects::nonNull).map(L10nMessage::toString).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        data.setSabreProfilesMessages(sabreProfilesMessages);
        data.setSabreProfilesUniqueIds((Collection)entity.getSabreProfilesUniqueIDs().stream().filter(Objects::nonNull).map(SabreProfilesUniqueIDSettings::getUniqueID).filter(TextUtil::nonBlank).collect(Collectors.toList()));
        List pccAndUniqueIds = entity.getSabreProfilesUniqueIDs().stream().filter(Objects::nonNull).filter(item -> TextUtil.nonBlank((String)item.getPcc()) && TextUtil.nonBlank((String)item.getUniqueID())).map(item -> ProfileHelper.createPccAndUniqueIdIndexItem((String)item.getPcc(), (String)item.getUniqueID())).collect(Collectors.toList());
        data.setSabreProfilesPccUniqueIds(pccAndUniqueIds);
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), (Object)organizationReference));
        List contractCustomerIndexes = EntityStorage.get().search(ContractCustomerIndex.class, query).getData();
        HashSet<String> supplierUids = new HashSet<String>();
        for (ContractCustomerIndex contractCustomerIndex : contractCustomerIndexes) {
            if (contractCustomerIndex == null || contractCustomerIndex.getSupplier() == null) continue;
            supplierUids.add(contractCustomerIndex.getSupplier().getUid());
        }
        data.setSupplierUids(supplierUids);
        data.setCompanyGroup(entity.getCompanyGroup());
        data.setExternalCodes(OrganizationIndexHandler.collectExternalCodes(entity));
        if (entity.getFopCheckRules() != null) {
            data.setFopCheckRulesUid(entity.getFopCheckRules().getUid());
        }
        if (entity.getQualityCheckRules() != null) {
            data.setQualityCheckRulesUid(entity.getQualityCheckRules().getUid());
        }
        if (entity.getRedappSettings() != null) {
            data.setRedappLicenseKey(entity.getRedappSettings().getLicenseKey());
        }
        aggregator.aggregate((Object)entity.getAirline());
        aggregator.aggregate((Iterable)entity.getTypes());
        aggregator.aggregate((Object)entity.getParent());
        aggregator.aggregate(bankAccounts);
        aggregator.aggregate((Object)entity.getCode());
        aggregator.aggregate((Object)entity.getClientID());
        aggregator.aggregate(entity.getFullName());
        aggregator.aggregate((Object)entity.isActive());
        aggregator.aggregate((Object)entity.isForeign());
        aggregator.aggregate((Object)entity.getKpp());
        aggregator.aggregate((Object)entity.getLegalForm());
        aggregator.aggregate((Object)entity.getBin());
        aggregator.aggregate((Object)entity.getRegistrationId());
        aggregator.aggregate(entity.getShortName());
        aggregator.aggregate((Object)entity.getPreferredLocale());
        aggregator.aggregate((Object)tchAgencyCode);
        aggregator.aggregate((Object)taAgencyCode);
        aggregator.aggregate(employeeCategories);
        aggregator.aggregate(filialNames);
        aggregator.aggregate((Object)entity.getCompanyGroup());
        if (!TextUtil.isBlank((String)shortNameEng)) {
            aggregator.aggregate((Object)shortNameEng);
        }
        if (!TextUtil.isBlank((String)brandCodeOwner)) {
            aggregator.aggregate((Object)brandCodeOwner);
        }
        if (!TextUtil.isBlank((String)brandCodeValue)) {
            aggregator.aggregate((Object)brandCodeValue);
        }
        for (String communicationText : communications) {
            aggregator.aggregate((Object)communicationText);
        }
        aggregator.aggregate((Object)entity.getHolding());
        aggregator.aggregate(pccAndUniqueIds);
    }

    private static List<String> collectExternalCodes(Organization entity) {
        String code;
        ArrayList<String> mixedCodes = new ArrayList<String>();
        for (ExternalSystemCode externalSystemCode : entity.getExternalCodes()) {
            code = externalSystemCode.getCode();
            if (code == null) continue;
            mixedCodes.add(code);
        }
        for (ExternalSystemCode externalSystemCode : entity.getExternalCodesV2()) {
            code = externalSystemCode.getCode();
            if (code == null) continue;
            mixedCodes.add(code);
        }
        return mixedCodes;
    }
}

