/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationMetadataIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationMetadataIndexData;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganizationMetadataIndexHandler
implements IndexHandler<Organization, OrganizationMetadataIndex> {
    private static transient Logger log = LoggerFactory.getLogger((String)OrganizationMetadataIndexHandler.class.getName());

    public Class<? extends BaseIndexData<Organization, OrganizationMetadataIndex>> getDataClass() {
        return OrganizationMetadataIndexData.class;
    }

    public Class<OrganizationMetadataIndex> getIndexClass() {
        return OrganizationMetadataIndex.class;
    }

    public Class<Organization> getEntityType() {
        return Organization.class;
    }

    public void create(EntityContainer<Organization> etc, Collection<BaseIndexData<Organization, OrganizationMetadataIndex>> indexes) {
        Organization entity = (Organization)etc.getEntity();
        ArrayList<String> parentUids = new ArrayList<String>();
        try {
            Collection parents = ProfileHelper.getOrganizationParents(Collections.singletonList(etc.toReference()));
            for (EntityReference parent : parents) {
                parentUids.add(parent.getUid());
            }
        }
        catch (Exception e) {
            log.error("failed retrieving parents", (Throwable)e);
        }
        for (Metadata metadata : entity.getMetadata()) {
            if (metadata.getKey() == null) continue;
            OrganizationMetadataIndexData data = new OrganizationMetadataIndexData();
            data.setDisabled(Boolean.valueOf(entity.isDisabled()));
            data.setCode(entity.getCode());
            data.setName(L10nStringHelper.getValue((L10nString)entity.getFullName(), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
            data.setShortName(L10nStringHelper.getValue((L10nString)entity.getShortName(), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
            data.setTypes((Collection)entity.getTypes());
            data.setMetadataKey(metadata.getKey());
            DataAggregator aggregator = new DataAggregator();
            boolean isString = false;
            if (metadata.getValue() instanceof String) {
                String string = (String)metadata.getValue();
                data.setMetadataStringValue(string);
                aggregator.aggregate((Object)string);
                isString = true;
            }
            if (metadata.getValue() instanceof Boolean) {
                data.setMetadataBooleanValue((Boolean)metadata.getValue());
            }
            if (metadata.getValue() instanceof Date) {
                Date date = (Date)metadata.getValue();
                data.setMetadataDateValue(date);
                aggregator.aggregate(date);
            }
            if (metadata.getValue() instanceof DictionaryReference) {
                DictionaryReference dictionaryReference = (DictionaryReference)metadata.getValue();
                String code = dictionaryReference.getCode();
                data.setMetadataDictValue(code);
                aggregator.aggregate((Object)code);
                aggregator.aggregate((Object)dictionaryReference);
            }
            if (metadata.getValue() instanceof Enum) {
                Enum enumm = (Enum)metadata.getValue();
                String name = enumm.name();
                data.setMetadataDictValue(name);
                aggregator.aggregate((Object)name);
            }
            if (metadata.getValue() instanceof EntityReference) {
                EntityReference value = (EntityReference)metadata.getValue();
                data.setMetadataEntityValue(value);
                aggregator.aggregate((Object)value);
            }
            if (!isString && metadata.getValue() != null) {
                data.setMetadataStringValue(metadata.getValue().toString());
            }
            data.setTypes((Collection)entity.getTypes());
            data.setParentUids(parentUids);
            aggregator.aggregate((Iterable)entity.getTypes());
            aggregator.aggregate((Object)entity.getCode());
            aggregator.aggregate(entity.getFullName());
            aggregator.aggregate(entity.getShortName());
            data.setAggregatedData(aggregator.toString());
            indexes.add((BaseIndexData<Organization, OrganizationMetadataIndex>)data);
        }
    }
}

