/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableNameUtil;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.PassengerPassportIndex;
import com.gridnine.xtrip.common.model.PassengerPassportIndexData;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.AirlineBonusCard;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;

public class PassengerPassportIndexHandler
implements IndexHandler<Person, PassengerPassportIndex> {
    public Class<? extends BaseIndexData<Person, PassengerPassportIndex>> getDataClass() {
        return PassengerPassportIndexData.class;
    }

    public Class<PassengerPassportIndex> getIndexClass() {
        return PassengerPassportIndex.class;
    }

    public Class<Person> getEntityType() {
        return Person.class;
    }

    public void create(EntityContainer<Person> etc, Collection<BaseIndexData<Person, PassengerPassportIndex>> indexes) {
        Person person = (Person)etc.getEntity();
        if (person.getTypes().contains(PersonType.PASSENGER)) {
            for (Passport passport : person.getPassports()) {
                if (passport.getType() == null) continue;
                PassengerPassportIndexData data = new PassengerPassportIndexData();
                this.fillPassengerPassportIndexData(data, etc, passport);
                indexes.add((BaseIndexData<Person, PassengerPassportIndex>)data);
            }
        }
    }

    protected void fillPassengerPassportIndexData(PassengerPassportIndexData data, EntityContainer<Person> etc, Passport passport) {
        Person person = (Person)etc.getEntity();
        data.setParent(person.getParent());
        EntityReference<Organization> companyRef = PassengerPassportIndexHandler.getCompanyIfAvailable(person);
        if (companyRef != null) {
            data.setCompany(companyRef);
        }
        data.setFirstName(passport.getFirstName());
        data.setLastName(passport.getLastName());
        data.setName(PersonalLocalizableNameUtil.buildFullName((PersonalLocalizableName)person, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        data.setMiddleName(passport.getMiddleName());
        data.setGender(passport.getGender());
        data.setPassportUid(passport.getUid());
        data.setPassportNumber(TextUtil.trim((String)passport.getNumber()));
        data.setPassportType(passport.getType());
        data.setCitizenship(passport.getCitizenship());
        data.setBirthDay(passport.getBirthday());
        data.setBirthPlace(passport.getBirthPlace());
        data.setIssued(passport.getIssued());
        data.setExpired(passport.getExpired());
        data.setRestricted(Boolean.valueOf(ProfileHelper.isRestricted(etc)));
        ArrayList<String> bonusCards = new ArrayList<String>(person.getAirlineBonusCards().size());
        for (AirlineBonusCard bonusCard : person.getAirlineBonusCards()) {
            bonusCards.add(String.format("%s:%s", bonusCard.getAirline() != null ? bonusCard.getAirline().getCode() : "", !TextUtil.isBlank((String)bonusCard.getNumber()) ? bonusCard.getNumber() : ""));
        }
        data.setBonusCards(bonusCards);
        bonusCards = new ArrayList(person.getRailwayBonusCards().size());
        for (AirlineBonusCard bonusCard : person.getRailwayBonusCards()) {
            bonusCards.add(String.format("%s:%s", !TextUtil.isBlank((String)bonusCard.getRailwayCarrierCode()) ? bonusCard.getRailwayCarrierCode() : "", !TextUtil.isBlank((String)bonusCard.getNumber()) ? bonusCard.getNumber() : ""));
        }
        data.setRailwayBonusCards(bonusCards);
        for (PersonCommunication comm : person.getCommunications()) {
            if (comm.getType() == null) continue;
            switch (comm.getType()) {
                case EMAIL: {
                    data.setEmail(comm.getSense());
                    break;
                }
                case MOBILE: 
                case WORK_PHONE: 
                case HOME_PHONE: {
                    data.setCommType(comm.getType());
                    data.setCommCountryCode(comm.getCountryCode() != null ? comm.getCountryCode() : "");
                    data.setCommCityCode(comm.getCityCode() != null ? comm.getCityCode() : "");
                    data.setCommSense(comm.getSense() != null ? comm.getSense() : "");
                    break;
                }
            }
        }
    }

    public static EntityReference<Organization> getCompanyIfAvailable(Person person) {
        if (person == null) {
            return null;
        }
        Date now = new Date();
        EntityReference result = null;
        for (PersonEmployment pe : person.getEmployments()) {
            if (result != null && (pe.getOrganization() == null || !pe.isMainEmployment()) || pe.getOpened() != null && !pe.getOpened().before(now) || pe.getClosed() != null && !pe.getClosed().after(now)) continue;
            result = pe.getOrganization();
        }
        return result;
    }
}

