/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.Payment;
import com.gridnine.xtrip.common.model.booking.PaymentIndex;
import com.gridnine.xtrip.common.model.booking.PaymentIndexData;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import java.util.Collection;
import java.util.HashSet;

public class PaymentIndexHandler
implements IndexHandler<BookingFile, PaymentIndex> {
    public Class<? extends BaseIndexData<BookingFile, PaymentIndex>> getDataClass() {
        return PaymentIndexData.class;
    }

    public Class<PaymentIndex> getIndexClass() {
        return PaymentIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public void create(EntityContainer<BookingFile> etc, Collection<BaseIndexData<BookingFile, PaymentIndex>> indexes) {
        BookingFile bookingFile = (BookingFile)etc.getEntity();
        for (Payment payment : bookingFile.getPayments()) {
            Object item2;
            PaymentIndexData data = new PaymentIndexData();
            data.setNavigationKey(payment.getUid());
            String bookingNumber = TextUtil.buildFullNumber((CompositeNumber)bookingFile);
            data.setBookingNumber(bookingNumber);
            String paymentNumber = TextUtil.buildFullNumber((CompositeNumber)payment);
            data.setPaymentNumber(paymentNumber);
            data.setDate(payment.getDate());
            data.setAgent(payment.getAgent());
            data.setFopType(payment.getFop() != null ? payment.getFop().getType() : null);
            HashSet<String> relatedNumbers = new HashSet<String>();
            HashSet<String> recordLocators = new HashSet<String>();
            String displayedRecordLocator = null;
            for (Object item2 : payment.getBillingItems()) {
                for (String productUid : item2.getProductUids()) {
                    BaseProduct prod = BookingHelper.findProduct((BookingFile)bookingFile, (String)productUid);
                    if (!(prod instanceof Product)) continue;
                    Product product = (Product)prod;
                    if (!TextUtil.isBlank((String)product.getSystemNumber())) {
                        relatedNumbers.add(product.getSystemNumber());
                    }
                    recordLocators.addAll(IndexBuilderHelper.getRecordLocators(product.getReservation()));
                    if (!TextUtil.isBlank(displayedRecordLocator) || product.getReservation() == null) continue;
                    displayedRecordLocator = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)product.getReservation());
                }
            }
            data.setRecordLocators(recordLocators);
            data.setDisplayedRecordLocator(displayedRecordLocator);
            data.setTicketNumbers(relatedNumbers);
            HashSet<String> financeDocuments = new HashSet<String>();
            item2 = payment.getFinanceDocuments().iterator();
            while (item2.hasNext()) {
                FinanceDocument doc = (FinanceDocument)item2.next();
                if (doc.getTemplate() == null || TextUtil.isBlank((String)doc.getTemplate().toString())) continue;
                financeDocuments.add(doc.getTemplate().toString());
            }
            data.setFinanceDocumentNumbers(financeDocuments);
            indexes.add((BaseIndexData<BookingFile, PaymentIndex>)data);
            DataAggregator aggregator = new DataAggregator();
            aggregator.aggregate((Object)bookingNumber);
            aggregator.aggregate((Object)payment.getAgent());
            aggregator.aggregate((Object)paymentNumber);
            aggregator.aggregate(relatedNumbers);
            aggregator.aggregate(recordLocators);
            aggregator.aggregate(financeDocuments);
            data.setAggregatedData(aggregator.toString());
        }
    }
}

