/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.helpers.BillingTransactionHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.CreditLimitInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonBalanceIndex;
import com.gridnine.xtrip.common.model.profile.PersonBalanceIndexData;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.index.PersonMetadataIndexHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonBalanceIndexHandler
implements IndexHandler<Person, PersonBalanceIndex> {
    private static transient Logger log = LoggerFactory.getLogger((String)PersonMetadataIndexHandler.class.getName());

    public Class<? extends BaseIndexData<Person, PersonBalanceIndex>> getDataClass() {
        return PersonBalanceIndexData.class;
    }

    public Class<PersonBalanceIndex> getIndexClass() {
        return PersonBalanceIndex.class;
    }

    public Class<Person> getEntityType() {
        return Person.class;
    }

    public void create(EntityContainer<Person> etc, Collection<BaseIndexData<Person, PersonBalanceIndex>> indexes) {
        EntityReference personReference = etc.toReference();
        Person person = (Person)etc.getEntity();
        long start = System.currentTimeMillis();
        log.debug(String.format("creating person balance index for person %s", person.toString()));
        EntityReference agentReference = etc.toReference();
        for (CreditLimitInfo creditLimitInfo : person.getFinanceRestrictions().getCreditLimits()) {
            EntityReference organizationReference = creditLimitInfo.getCreditor();
            PersonBalanceIndexData data = new PersonBalanceIndexData();
            DataAggregator aggregator = new DataAggregator();
            data.setNavigationKey("finance" + ((Person)etc.getEntity()).getUid());
            data.setClient(organizationReference);
            data.setAgent(agentReference);
            BigDecimal balanceAmount = BigDecimal.ZERO;
            try {
                balanceAmount = this.calculateBalance((EntityReference<Organization>)organizationReference, (EntityReference<? extends BaseProfile>)agentReference);
            }
            catch (Exception exception) {
                // empty catch block
            }
            data.setBalanceAmount(balanceAmount);
            aggregator.aggregate((Object)organizationReference);
            aggregator.aggregate((Object)agentReference);
            BigDecimal creditAmount = BigDecimal.ZERO;
            if (creditLimitInfo.getCreditLimit() != null) {
                creditAmount = creditAmount.add(creditLimitInfo.getCreditLimit());
            }
            if (creditLimitInfo.getTerminalCreditLimit() != null && MiscUtil.isBetween((Date)creditLimitInfo.getTerminalCreditDateStart(), (Date)creditLimitInfo.getTerminalCreditDateEnd(), (Date)new Date())) {
                creditAmount = creditAmount.add(creditLimitInfo.getTerminalCreditLimit());
            }
            BigDecimal availableAmount = !creditLimitInfo.isUnlimited() ? balanceAmount.add(creditAmount) : BigDecimal.valueOf(Integer.MAX_VALUE);
            data.setAvailableAmount(availableAmount);
            data.setUnlimited(Boolean.valueOf(creditLimitInfo.isUnlimited()));
            data.setCreditLimit(creditLimitInfo.getCreditLimit());
            data.setTerminalCreditLimit(creditLimitInfo.getTerminalCreditLimit());
            data.setTerminalCreditDateStart(creditLimitInfo.getTerminalCreditDateStart());
            data.setTerminalCreditDateEnd(creditLimitInfo.getTerminalCreditDateEnd());
            ArrayList<String> employmentsUids = new ArrayList<String>();
            for (PersonEmployment placeOfEmployment : person.getEmployments()) {
                if (placeOfEmployment.getOrganization() == null || employmentsUids.contains(placeOfEmployment.getOrganization().getUid())) continue;
                employmentsUids.add(placeOfEmployment.getOrganization().getUid());
            }
            data.setEmploymentsUids(employmentsUids);
            ArrayList<String> parentOrganizationUids = new ArrayList<String>();
            try {
                Collection parentOrganizations = ProfileHelper.getOrganizationParents((Collection)ProfileHelper.getPersonOrganizations(Collections.singletonList(personReference), null, (Date)new Date()));
                for (EntityReference parentOrganization : parentOrganizations) {
                    parentOrganizationUids.add(parentOrganization.getUid());
                }
            }
            catch (Exception e) {
                log.error("failed retrieving parent organizations", (Throwable)e);
            }
            data.setParentOrganizationUids(parentOrganizationUids);
            data.setRestricted(Boolean.valueOf(ProfileHelper.isRestricted(etc)));
            data.setAggregatedData(aggregator.toString());
            indexes.add((BaseIndexData<Person, PersonBalanceIndex>)data);
        }
        log.debug(String.format("%s person balance indexes created for person %s, it takes %s ms", Integer.toString(indexes.size()), etc.toString(), Long.toString(System.currentTimeMillis() - start)));
    }

    protected BigDecimal calculateBalance(EntityReference<Organization> organizationReference, EntityReference<? extends BaseProfile> agentReference) throws Exception {
        return BillingTransactionHelper.calculateBillingTransactionsSum(null, organizationReference, null, agentReference, null, null, null, null);
    }
}

