/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableNameUtil;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonEmploymentIndex;
import com.gridnine.xtrip.common.model.profile.PersonEmploymentIndexData;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;
import java.util.Locale;
import java.util.stream.Collectors;

public class PersonEmploymentIndexHandler
implements IndexHandler<Person, PersonEmploymentIndex> {
    public Class<? extends BaseIndexData<Person, PersonEmploymentIndex>> getDataClass() {
        return PersonEmploymentIndexData.class;
    }

    public Class<PersonEmploymentIndex> getIndexClass() {
        return PersonEmploymentIndex.class;
    }

    public Class<Person> getEntityType() {
        return Person.class;
    }

    public void create(EntityContainer<Person> etc, Collection<BaseIndexData<Person, PersonEmploymentIndex>> indexes) {
        Person person = (Person)etc.getEntity();
        for (int i = 0; i < person.getEmployments().size(); ++i) {
            PersonEmployment employment = (PersonEmployment)person.getEmployments().get(i);
            DataAggregator aggregator = new DataAggregator();
            PersonEmploymentIndexData indexData = this.createIndexData(etc, employment, aggregator);
            indexData.setAggregatedData(aggregator.toString());
            indexes.add((BaseIndexData<Person, PersonEmploymentIndex>)indexData);
        }
    }

    protected PersonEmploymentIndexData createIndexData(EntityContainer<Person> etc, PersonEmployment employment, DataAggregator aggregator) {
        PersonEmploymentIndexData employmentData = new PersonEmploymentIndexData();
        Person person = (Person)etc.getEntity();
        employmentData.setName(PersonalLocalizableNameUtil.buildFullName((PersonalLocalizableName)person, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        employmentData.setCode(person.getCode());
        employmentData.setLogin(person.getLoginName());
        employmentData.setAuthorized(Boolean.valueOf(employment.isAuthorized()));
        employmentData.setOrganization(employment.getOrganization());
        employmentData.setPosition(employment.getPosition());
        employmentData.setWorkStartDate(employment.getOpened());
        employmentData.setWorkEndDate(employment.getClosed());
        employmentData.setTypes((Collection)person.getTypes());
        employmentData.setMainEmployment(Boolean.valueOf(employment.isMainEmployment()));
        employmentData.setRestricted(Boolean.valueOf(ProfileHelper.isRestricted(etc)));
        employmentData.setAuthorityLettersUids((Collection)person.getAuthorityLetters().stream().map(BaseIdentity::getUid).collect(Collectors.toList()));
        aggregator.aggregate((Object)PersonalLocalizableNameUtil.buildFullName((PersonalLocalizableName)person, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        aggregator.aggregate((Object)person.getCode());
        aggregator.aggregate((Object)person.getLoginName());
        aggregator.aggregate((Object)employment.getOrganization());
        aggregator.aggregate((Object)employment.getPosition());
        aggregator.aggregate(employment.getOpened());
        aggregator.aggregate(employment.getClosed());
        aggregator.aggregate((Iterable)person.getTypes());
        return employmentData;
    }
}

