/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableNameUtil;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.ProfileGroupReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommunicationFormat;
import com.gridnine.xtrip.common.model.helpers.PersonHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.ExternalSystemCode;
import com.gridnine.xtrip.common.model.profile.ExternalSystemCodeV2;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.PersonIndexData;
import com.gridnine.xtrip.common.model.profile.PersonMetadata;
import com.gridnine.xtrip.common.model.profile.SabreProfilesUniqueIDSettings;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.TranslitUtil;
import com.gridnine.xtrip.server.db.storage.entity.LogicalEntityStorage;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonIndexHandler
implements IndexHandler<Person, PersonIndex> {
    private static transient Logger log = LoggerFactory.getLogger((String)PersonIndexHandler.class.getName());

    public Class<? extends BaseIndexData<Person, PersonIndex>> getDataClass() {
        return PersonIndexData.class;
    }

    public Class<PersonIndex> getIndexClass() {
        return PersonIndex.class;
    }

    public Class<Person> getEntityType() {
        return Person.class;
    }

    public void create(EntityContainer<Person> etc, Collection<BaseIndexData<Person, PersonIndex>> indexes) {
        PersonIndexData data = new PersonIndexData();
        DataAggregator aggregator = new DataAggregator();
        this.updateData(data, aggregator, etc);
        data.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<Person, PersonIndex>)data);
    }

    protected void updateData(PersonIndexData data, DataAggregator aggregator, EntityContainer<Person> etc) {
        EntityReference personReference = etc.toReference();
        Person person = (Person)etc.getEntity();
        boolean dataSourceModified = true;
        try {
            dataSourceModified = LogicalEntityStorage.isDataSourceModified((VersionInfo)etc.getVersionInfo());
        }
        catch (Exception e2) {
            log.error("unable to check data source", (Throwable)e2);
        }
        if (dataSourceModified) {
            data.setDataSource(etc.getVersionInfo().getDataSource());
        }
        data.setDisabled(Boolean.valueOf(person.isDisabled()));
        data.setRestricted(Boolean.valueOf(ProfileHelper.isRestricted(etc)));
        data.setDraftState(Boolean.valueOf(person.isDraftState()));
        data.setCode(person.getCode());
        data.setRegistrationIdKz(person.getRegistrationIdKz());
        data.setName(PersonalLocalizableNameUtil.buildFullName((PersonalLocalizableName)person, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        L10nString lastName = person.getLastName();
        for (String x : lastName.getValues().values()) {
            aggregator.aggregate((Object)PersonIndexHandler.normalize(x));
        }
        Object lastNameEng = L10nStringHelper.getValue((L10nString)lastName, (Locale)LocaleUtil.LOCALE_EN, (boolean)true);
        lastNameEng = PersonIndexHandler.normalize((String)lastNameEng);
        data.setEnglishLastName((String)lastNameEng);
        L10nString firstName = person.getFirstName();
        for (String x : firstName.getValues().values()) {
            aggregator.aggregate((Object)PersonIndexHandler.normalize(x));
        }
        Object firstNameEng = L10nStringHelper.getValue((L10nString)firstName, (Locale)LocaleUtil.LOCALE_EN, (boolean)true);
        firstNameEng = PersonIndexHandler.normalize((String)firstNameEng);
        data.setEnglishFirstName((String)firstNameEng);
        L10nString middleName = person.getMiddleName();
        for (String x : middleName.getValues().values()) {
            aggregator.aggregate((Object)PersonIndexHandler.normalize(x));
        }
        String middleNameEng = L10nStringHelper.getValue((L10nString)middleName, (Locale)LocaleUtil.LOCALE_EN, (boolean)true);
        middleNameEng = PersonIndexHandler.normalize(middleNameEng);
        data.setEnglishMiddleName(middleNameEng);
        String loginName = person.getLoginName();
        data.setLoginName(loginName);
        data.setParent(person.getParent());
        aggregator.aggregate((Object)person.getParent());
        data.setTypes((Collection)person.getTypes());
        aggregator.aggregate((Iterable)person.getTypes());
        ArrayList<String> gdsReferences = new ArrayList<String>();
        ArrayList<String> gdsNames = new ArrayList<String>();
        for (Object ref : person.getGdsReferences()) {
            GdsName gds = ref.getGdsName();
            String reference = ref.getReference();
            if (gds == null || TextUtil.isBlank((String)reference)) continue;
            gdsReferences.add(gds.name() + ":" + reference);
            gdsNames.add(gds.name());
        }
        data.setGdsReferences(gdsReferences);
        data.setGdsNames(gdsNames);
        ArrayList<String> communications = new ArrayList<String>();
        for (Communication communication : person.getCommunications()) {
            if (TextUtil.isBlank((String)communication.getSense()) || communication.getType() == null) continue;
            CommunicationFormat phoneFormat = new CommunicationFormat("+C (T) N #I");
            CommunicationFormat emailFormat = new CommunicationFormat("N");
            CommunicationFormat webFormat = new CommunicationFormat("N");
            String communicationString = null;
            switch (communication.getType()) {
                case WORK_PHONE: 
                case HOME_PHONE: 
                case FAX: 
                case MOBILE: 
                case AGENCY: 
                case HOTEL: 
                case CELL: 
                case EMERGENCY: {
                    communicationString = phoneFormat.format(communication);
                    break;
                }
                case EMAIL: {
                    communicationString = emailFormat.format(communication);
                    break;
                }
                case WEB: {
                    communicationString = webFormat.format(communication);
                }
            }
            if (communicationString == null) continue;
            communications.add(communication.getType() != null ? communication.getType() + ": " + communicationString : communicationString);
        }
        EntityContainer parentCtr = EntityStorage.get().resolve(person.getParent());
        if (parentCtr != null) {
            List employments = ProfileHelper.getEmployments((Person)((Person)parentCtr.getEntity()), (boolean)false);
            if (employments.size() > 1) {
                employments = ProfileHelper.getEmployments((Person)((Person)parentCtr.getEntity()), (boolean)true);
            }
            EntityReference parentMainEmployment = employments.isEmpty() ? null : ((EntityContainer)employments.get(0)).toReference();
            data.setParentMainEmployment(parentMainEmployment);
            aggregator.aggregate((Object)parentMainEmployment);
        }
        data.setCommunications(communications);
        data.setAddressHome(ProfileHelper.buildFullAddress((Address)ProfileHelper.filterAddresses((Collection)person.getAddresses(), (AddressType)AddressType.HOME), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        data.setAddressBusiness(ProfileHelper.buildFullAddress((Address)ProfileHelper.filterAddresses((Collection)person.getAddresses(), (AddressType)AddressType.BUSINESS), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        ArrayList<String> employmentsUids = new ArrayList<String>();
        ArrayList<String> employments = new ArrayList<String>();
        ArrayList<String> departmentSuffixes = new ArrayList<String>();
        ArrayList<String> departments = new ArrayList<String>();
        ArrayList<DictionaryReference> positions = new ArrayList<DictionaryReference>();
        ArrayList<String> employeeCategoriesNames = new ArrayList<String>();
        HashSet<String> filialUids = new HashSet<String>();
        HashSet<String> filialNames = new HashSet<String>();
        boolean hasEmployerSynchronizedToSP = false;
        for (PersonEmployment placeOfEmployment : person.getEmployments()) {
            String name;
            if (placeOfEmployment.getOrganization() != null) {
                try {
                    EntityStorage.get().actualize(placeOfEmployment.getOrganization());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                employmentsUids.add(placeOfEmployment.getOrganization().getUid());
                EntityContainer organizationContainer = null;
                try {
                    organizationContainer = EntityStorage.get().resolve(placeOfEmployment.getOrganization());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (organizationContainer != null) {
                    Organization organization = (Organization)organizationContainer.getEntity();
                    Locale locale = LocaleHelper.getCurrentLocale();
                    String name2 = L10nStringHelper.getValue((L10nString)organization.getShortName(), (Locale)locale, (boolean)false);
                    if (TextUtil.isBlank((String)name2)) {
                        name2 = L10nStringHelper.getValue((L10nString)organization.getFullName(), (Locale)locale, (boolean)false);
                    }
                    if (organization.getSabreProfilesLastSyncDate() != null) {
                        hasEmployerSynchronizedToSP = true;
                    }
                    for (Metadata metadata : organization.getMetadata()) {
                        if (metadata.getKey() == null || !metadata.getKey().getCode().equals(MetadataKey.KEY_ORGANIZATION_AGENCY_SUBDIVISION.name()) || metadata.getValue() == null || !(metadata.getValue() instanceof EntityReference)) continue;
                        EntityReference orgRef = (EntityReference)metadata.getValue();
                        filialNames.add(orgRef.getCaption());
                        filialUids.add(orgRef.getUid());
                    }
                    employments.add(name2);
                    aggregator.aggregate((Object)organization.getShortName().getValues());
                    aggregator.aggregate((Object)organization.getFullName().getValues());
                } else {
                    employments.add(placeOfEmployment.getOrganization().getCaption());
                    aggregator.aggregate((Object)placeOfEmployment.getOrganization().getCaption());
                }
            }
            if (placeOfEmployment.getPosition() != null) {
                positions.add(placeOfEmployment.getPosition());
                aggregator.aggregate((Object)placeOfEmployment.getPosition().toString());
            }
            if (!TextUtil.isBlank((String)placeOfEmployment.getDepartmentSuffix())) {
                departmentSuffixes.add(placeOfEmployment.getDepartmentSuffix().toUpperCase());
                departments.add(placeOfEmployment.getDepartmentSuffix());
            } else {
                departmentSuffixes.add("+");
            }
            if (placeOfEmployment.getEmployeeCategory() == null || placeOfEmployment.getEmployeeCategory().getName() == null || !TextUtil.nonBlank((String)(name = placeOfEmployment.getEmployeeCategory().getName().toString()))) continue;
            employeeCategoriesNames.add(name);
            aggregator.aggregate((Object)name);
        }
        data.setSabreProfilesHasEmployerSynchronized(Boolean.valueOf(hasEmployerSynchronizedToSP));
        data.setEmploymentsUids(employmentsUids);
        data.setEmployments(employments);
        data.setPositions(positions);
        data.setEmploymentsSuffixes(departmentSuffixes);
        data.setDepartments(departments);
        data.setEmployeeCategoriesNames(employeeCategoriesNames);
        data.setFilialNames(filialNames);
        data.setFilialUids(filialUids);
        data.setResourceIdForGetThere(person.getResourceIdForGetThere());
        data.setExternalCode(person.getExternalCode());
        data.setExternalCodes(this.getExternalCodes(person));
        data.setSabreProfilesLastSyncDate(person.getSabreProfilesLastSyncDate());
        data.setSabreProfilesLastSyncAttemptDate(person.getSabreProfilesLastSyncAttemptDate());
        data.setSabreProfilesLastSyncStatus(person.getSabreProfilesLastSyncStatus());
        data.setSabreProfilesLastOperationType(person.getSabreProfilesLastOperationType());
        List sabreProfilesMessages = person.getSabreProfilesMessages().stream().filter(Objects::nonNull).map(Message::getMessage).filter(Objects::nonNull).map(L10nMessage::toString).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        data.setSabreProfilesMessages(sabreProfilesMessages);
        data.setLoadedFromSabreProfiles(Boolean.valueOf(person.isLoadedFromSabreProfiles()));
        data.setSabreProfilesUniqueIds((Collection)person.getSabreProfilesUniqueIDs().stream().filter(Objects::nonNull).map(SabreProfilesUniqueIDSettings::getUniqueID).filter(TextUtil::nonBlank).collect(Collectors.toList()));
        List pccAndUniqueIds = person.getSabreProfilesUniqueIDs().stream().filter(Objects::nonNull).filter(item -> TextUtil.nonBlank((String)item.getPcc()) && TextUtil.nonBlank((String)item.getUniqueID())).map(item -> ProfileHelper.createPccAndUniqueIdIndexItem((String)item.getPcc(), (String)item.getUniqueID())).collect(Collectors.toList());
        data.setSabreProfilesPccUniqueIds(pccAndUniqueIds);
        aggregator.aggregate(pccAndUniqueIds);
        aggregator.aggregate(filialNames);
        aggregator.aggregate(departments);
        data.setPreferredLocale(person.getPreferredLocale());
        ArrayList<String> salesPointsUids = new ArrayList<String>();
        ArrayList<String> salesPointsCaptions = new ArrayList<String>();
        for (Object placeOfSales : person.getSalesPoints()) {
            if (placeOfSales.getSalesPoint() == null) continue;
            salesPointsUids.add(placeOfSales.getSalesPoint().getUid());
            salesPointsCaptions.add(placeOfSales.getSalesPoint().getCaption());
            aggregator.aggregate((Object)placeOfSales.getSalesPoint().getCaption());
        }
        data.setSalesPointsUids(salesPointsUids);
        data.setSalesPoints(salesPointsCaptions);
        HashSet<String> emails = new HashSet<String>();
        for (Object comm : person.getCommunications()) {
            if (comm.getType() != CommunicationType.EMAIL || TextUtil.isBlank((String)comm.getSense())) continue;
            emails.add(comm.getSense());
            aggregator.aggregate((Object)comm.getSense());
        }
        data.setEmails(emails);
        HashSet<String> phones = new HashSet<String>();
        for (Object comm : person.getCommunications()) {
            if (comm.getType() != CommunicationType.MOBILE && comm.getType() != CommunicationType.WORK_PHONE && comm.getType() != CommunicationType.HOME_PHONE && comm.getType() != CommunicationType.CELL && comm.getType() != CommunicationType.AGENCY && comm.getType() != CommunicationType.HOTEL && comm.getType() != CommunicationType.FAX || TextUtil.isBlank((String)comm.getSense())) continue;
            phones.add(this.getPhone((Communication)comm));
            aggregator.aggregate((Object)this.getPhone((Communication)comm));
        }
        data.setPhones(phones);
        HashSet<String> passportNumbers = new HashSet<String>();
        for (Passport passport : person.getPassports()) {
            String passportNumber = passport.getNumber();
            if (TextUtil.isBlank((String)passportNumber)) continue;
            passportNumbers.add(passportNumber);
            aggregator.aggregate((Object)passportNumber);
        }
        data.setPassportNumbers(passportNumbers);
        ArrayList<String> parentOrganizationUids = new ArrayList<String>();
        try {
            Collection parentOrganizations = ProfileHelper.getOrganizationParents((Collection)ProfileHelper.getPersonOrganizationByContainers(Collections.singletonList(etc), null, (Date)new Date()));
            for (EntityReference parentOrganization : parentOrganizations) {
                parentOrganizationUids.add(parentOrganization.getUid());
            }
        }
        catch (Exception e3) {
            log.error("failed retrieving parent organizations", (Throwable)e3);
        }
        data.setParentOrganizationUids(parentOrganizationUids);
        ArrayList<ProfileGroupReference> groups = new ArrayList<ProfileGroupReference>();
        for (PersonMetadata metadata : person.getMetadata()) {
            if (metadata.getKey() == null || !metadata.getKey().getCode().equals(MetadataKey.KEY_PERSON_PROFILE_GROUP.name()) || metadata.getValue() == null) continue;
            groups.add((ProfileGroupReference)metadata.getValue());
        }
        data.setGroups(groups);
        ArrayList<String> supplierOrganizationUids = new ArrayList<String>();
        List personEmployments = person.getEmployments();
        SearchQuery query = new SearchQuery();
        SearchCriterion[] searchCriterions = personEmployments.stream().filter(personEmployment -> personEmployment.getOrganization() != null).map(personEmployment -> SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), (Object)personEmployment.getOrganization())).collect(Collectors.toList()).toArray(new SearchCriterion[0]);
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])searchCriterions));
        List contractCustomerIndexes = EntityStorage.get().search(ContractCustomerIndex.class, query).getData();
        for (ContractCustomerIndex contractCustomerIndex : contractCustomerIndexes) {
            if (contractCustomerIndex == null || contractCustomerIndex.getSupplier() == null) continue;
            supplierOrganizationUids.add(contractCustomerIndex.getSupplier().getUid());
        }
        data.setSupplierOrganizationUids(supplierOrganizationUids);
        data.setBirthday(ProfileHelper.getPersonBirthday((Person)person));
        data.setSearchFirstNames(this.buildSearchNames(person.getFirstName()));
        data.setSearchLastNames(this.buildSearchNames(person.getLastName()));
        data.setLastNameValues(this.collectValues(person.getLastName()));
        data.setFirstNameValues(this.collectValues(person.getFirstName()));
        data.setMiddleNameValues(this.collectValues(person.getMiddleName()));
        List employmentsList = person.getEmployments();
        if (!employmentsList.isEmpty() && employmentsList.stream().allMatch(e -> e.getClosed() != null)) {
            data.setWorkEndDate(employmentsList.stream().map(e -> e.getClosed()).max(Date::compareTo).get());
        }
        List costCodeValues = person.getCostCodes().stream().map(CostCode::getValue).filter(TextUtil::nonBlank).distinct().collect(Collectors.toList());
        data.setCostCodesValues(costCodeValues);
        List costCodeLocalValues = person.getCostCodes().stream().map(CostCode::getLocalValue).filter(TextUtil::nonBlank).distinct().collect(Collectors.toList());
        data.setCostCodesLocalValues(costCodeLocalValues);
        List costCodeEnglishValues = person.getCostCodes().stream().map(CostCode::getEnglishValue).filter(TextUtil::nonBlank).distinct().collect(Collectors.toList());
        data.setCostCodesEnglishValues(costCodeEnglishValues);
        List allEmployments = ProfileHelper.getEmployments((Person)person);
        data.setHoldings((Collection)allEmployments.stream().filter(employment -> employment.getEntity() != null).map(employment -> ((Organization)employment.getEntity()).getHolding()).filter(Objects::nonNull).collect(Collectors.toList()));
        aggregator.aggregate((Object)person.getCode());
        aggregator.aggregate((Object)PersonalLocalizableNameUtil.buildFullName((PersonalLocalizableName)person, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        aggregator.aggregate((Object)loginName);
        aggregator.aggregate((Object)person.getResourceIdForGetThere());
        aggregator.aggregate((Object)person.getPreferredLocale());
        aggregator.aggregate((Object)person.getNotes());
        aggregator.aggregate(costCodeValues);
        aggregator.aggregate(costCodeLocalValues);
        aggregator.aggregate(costCodeEnglishValues);
    }

    private String getPhone(Communication communication) {
        CommunicationFormat phoneFormat = new CommunicationFormat("+C (T) N #I");
        String communicationString = phoneFormat.format(communication);
        if (communicationString != null) {
            return communication.getType() != null ? communication.getType() + ": " + communicationString : communicationString;
        }
        return "";
    }

    private Collection<String> buildSearchNames(L10nString name) {
        HashSet<String> result = new HashSet<String>();
        Stream.of(LocaleHelper.EN_LOCALE, LocaleHelper.RU_LOCALE, LocaleHelper.getCurrentLocale()).distinct().map(locale -> PersonHelper.refineName((String)L10nStringHelper.getValue((L10nString)name, (Locale)locale, (boolean)false))).filter(Objects::nonNull).forEach(searchName -> {
            result.add((String)searchName);
            if (TextUtil.isCyrillic((String)searchName, (boolean)true)) {
                result.add(TextUtil.translit((String)searchName, (boolean)true));
                result.add(TranslitUtil.cyr2lat((String)searchName, (TranslitUtil.TranslitRules)TranslitUtil.TranslitRules.GOST_52535_1_2006));
            }
        });
        return result;
    }

    private Collection<String> collectValues(L10nString lString) {
        if (lString == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        lString.getValues().values().stream().filter(Objects::nonNull).map(String::toLowerCase).forEach(result::add);
        return result;
    }

    private List<String> getExternalCodes(Person person) {
        return Stream.concat(person.getExternalCodes().stream().map(ExternalSystemCode::getCode).filter(TextUtil::nonBlank), person.getExternalCodesV2().stream().map(ExternalSystemCodeV2::getCode).filter(TextUtil::nonBlank)).distinct().collect(Collectors.toList());
    }

    private static String normalize(String s) {
        return TextUtil.isBlank((String)s) ? null : s.trim().toUpperCase();
    }
}

