/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableNameUtil;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonMetadata;
import com.gridnine.xtrip.common.model.profile.PersonMetadataIndex;
import com.gridnine.xtrip.common.model.profile.PersonMetadataIndexData;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonMetadataIndexHandler
implements IndexHandler<Person, PersonMetadataIndex> {
    private static transient Logger log = LoggerFactory.getLogger((String)PersonMetadataIndexHandler.class.getName());

    public Class<? extends BaseIndexData<Person, PersonMetadataIndex>> getDataClass() {
        return PersonMetadataIndexData.class;
    }

    public Class<PersonMetadataIndex> getIndexClass() {
        return PersonMetadataIndex.class;
    }

    public Class<Person> getEntityType() {
        return Person.class;
    }

    public void create(EntityContainer<Person> etc, Collection<BaseIndexData<Person, PersonMetadataIndex>> indexes) {
        EntityReference personReference = etc.toReference();
        Person person = (Person)etc.getEntity();
        for (PersonMetadata metadata : person.getMetadata()) {
            if (metadata.getKey() == null) continue;
            PersonMetadataIndexData data = new PersonMetadataIndexData();
            data.setDisabled(Boolean.valueOf(person.isDisabled()));
            data.setRestricted(Boolean.valueOf(ProfileHelper.isRestricted(etc)));
            data.setCode(person.getCode());
            data.setName(PersonalLocalizableNameUtil.buildFullName((PersonalLocalizableName)person, (boolean)true, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
            data.setTypes((Collection)person.getTypes());
            data.setMetadataKey(metadata.getKey());
            data.setMetadataOrganization(metadata.getOrganization());
            DataAggregator aggregator = new DataAggregator();
            boolean isString = false;
            if (metadata.getValue() instanceof String) {
                String string = (String)metadata.getValue();
                data.setMetadataStringValue(string);
                aggregator.aggregate((Object)string);
                isString = true;
            }
            if (metadata.getValue() instanceof Boolean) {
                data.setMetadataBooleanValue((Boolean)metadata.getValue());
            }
            if (metadata.getValue() instanceof Date) {
                Date date = (Date)metadata.getValue();
                data.setMetadataDateValue(date);
                aggregator.aggregate(date);
            }
            if (metadata.getValue() instanceof DictionaryReference) {
                DictionaryReference dictionaryReference = (DictionaryReference)metadata.getValue();
                String code = dictionaryReference.getCode();
                data.setMetadataDictValue(code);
                aggregator.aggregate((Object)code);
                aggregator.aggregate((Object)dictionaryReference);
            }
            if (metadata.getValue() instanceof Enum) {
                Enum enumm = (Enum)metadata.getValue();
                String name = enumm.name();
                data.setMetadataDictValue(name);
                aggregator.aggregate((Object)name);
            }
            if (metadata.getValue() instanceof EntityReference) {
                EntityReference value = (EntityReference)metadata.getValue();
                data.setMetadataEntityValue(value);
                aggregator.aggregate((Object)value);
            }
            if (!isString && metadata.getValue() != null) {
                data.setMetadataStringValue(metadata.getValue().toString());
            }
            data.setTypes((Collection)person.getTypes());
            ArrayList<String> employmentsUids = new ArrayList<String>();
            for (PersonEmployment placeOfEmployment : person.getEmployments()) {
                if (placeOfEmployment.getOrganization() == null || employmentsUids.contains(placeOfEmployment.getOrganization().getUid())) continue;
                employmentsUids.add(placeOfEmployment.getOrganization().getUid());
            }
            data.setEmploymentsUids(employmentsUids);
            ArrayList<String> parentOrganizationUids = new ArrayList<String>();
            try {
                Collection parentOrganizations = ProfileHelper.getOrganizationParents((Collection)ProfileHelper.getPersonOrganizations(Collections.singletonList(personReference), null, (Date)new Date()));
                for (EntityReference parentOrganization : parentOrganizations) {
                    parentOrganizationUids.add(parentOrganization.getUid());
                }
            }
            catch (Exception e) {
                log.error("failed retrieving parent organizations", (Throwable)e);
            }
            data.setParentOrganizationUids(parentOrganizationUids);
            aggregator.aggregate((Iterable)person.getTypes());
            aggregator.aggregate((Object)person.getCode());
            aggregator.aggregate((Object)PersonalLocalizableNameUtil.buildFullName((PersonalLocalizableName)person, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
            aggregator.aggregate((Object)metadata.getOrganization());
            data.setAggregatedData(aggregator.toString());
            indexes.add((BaseIndexData<Person, PersonMetadataIndex>)data);
        }
    }
}

