/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.PersonPassportIndex;
import com.gridnine.xtrip.common.model.PersonPassportIndexData;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

public class PersonPassportIndexHandler
implements IndexHandler<Person, PersonPassportIndex> {
    public Class<? extends BaseIndexData<Person, PersonPassportIndex>> getDataClass() {
        return PersonPassportIndexData.class;
    }

    public Class<PersonPassportIndex> getIndexClass() {
        return PersonPassportIndex.class;
    }

    public Class<Person> getEntityType() {
        return Person.class;
    }

    public void create(EntityContainer<Person> etc, Collection<BaseIndexData<Person, PersonPassportIndex>> indexes) {
        Person person = (Person)etc.getEntity();
        for (Passport passport : person.getPassports()) {
            PersonPassportIndexData data = this.buildPersonPassportIndexData(etc, passport);
            if (data == null) continue;
            indexes.add((BaseIndexData<Person, PersonPassportIndex>)data);
        }
    }

    protected PersonPassportIndexData buildPersonPassportIndexData(EntityContainer<Person> etc, Passport passport) {
        if (passport.getType() == null || StringUtils.isBlank((String)passport.getNumber())) {
            return null;
        }
        PersonPassportIndexData result = new PersonPassportIndexData();
        result.setPassportNumber(passport.getNumber());
        result.setPassportType(passport.getType());
        result.setRestricted(Boolean.valueOf(ProfileHelper.isRestricted(etc)));
        return result;
    }
}

