/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableNameUtil;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.GdsReference;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PlaceOfSales;
import com.gridnine.xtrip.common.model.profile.PlaceOfSalesIndex;
import com.gridnine.xtrip.common.model.profile.PlaceOfSalesIndexData;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;

public class PlaceOfSalesIndexHandler
implements IndexHandler<Person, PlaceOfSalesIndex> {
    public Class<? extends BaseIndexData<Person, PlaceOfSalesIndex>> getDataClass() {
        return PlaceOfSalesIndexData.class;
    }

    public Class<PlaceOfSalesIndex> getIndexClass() {
        return PlaceOfSalesIndex.class;
    }

    public Class<Person> getEntityType() {
        return Person.class;
    }

    public void create(EntityContainer<Person> etc, Collection<BaseIndexData<Person, PlaceOfSalesIndex>> indexes) {
        for (PlaceOfSales salesPoint : ((Person)etc.getEntity()).getSalesPoints()) {
            PlaceOfSalesIndexData data = new PlaceOfSalesIndexData();
            if (salesPoint.getSalesPoint().getType().getName().equals(SalesPoint.class.getName())) {
                data.setSalesPoint(salesPoint.getSalesPoint());
            }
            data.setOpened(salesPoint.getOpened());
            data.setClosed(salesPoint.getClosed());
            data.setCode(((Person)etc.getEntity()).getCode());
            data.setLogin(((Person)etc.getEntity()).getLoginName());
            data.setRestricted(Boolean.valueOf(ProfileHelper.isRestricted(etc)));
            data.setName(PersonalLocalizableNameUtil.buildFullName((PersonalLocalizableName)((PersonalLocalizableName)etc.getEntity()), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
            ArrayList<String> employments = new ArrayList<String>();
            for (PersonEmployment placeOfEmployment : ((Person)etc.getEntity()).getEmployments()) {
                if (placeOfEmployment.getOrganization() == null) continue;
                EntityContainer organizationContainer = null;
                try {
                    EntityStorage.get().actualize(placeOfEmployment.getOrganization());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    organizationContainer = EntityStorage.get().resolve(placeOfEmployment.getOrganization());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (organizationContainer != null) {
                    Organization organization = (Organization)organizationContainer.getEntity();
                    Locale locale = LocaleHelper.getCurrentLocale();
                    String name = L10nStringHelper.getValue((L10nString)organization.getShortName(), (Locale)locale, (boolean)false);
                    if (TextUtil.isBlank((String)name)) {
                        name = L10nStringHelper.getValue((L10nString)organization.getFullName(), (Locale)locale, (boolean)false);
                    }
                    employments.add(name);
                    continue;
                }
                employments.add(placeOfEmployment.getOrganization().getCaption());
            }
            data.setEmployments(employments);
            ArrayList<String> gdsReferences = new ArrayList<String>();
            for (GdsReference ref : ((Person)etc.getEntity()).getGdsReferences()) {
                GdsName gds = ref.getGdsName();
                String reference = ref.getReference();
                if (gds == null || TextUtil.isBlank((String)reference)) continue;
                gdsReferences.add(gds.name() + ":" + reference);
            }
            data.setGdsReferences(gdsReferences);
            indexes.add((BaseIndexData<Person, PlaceOfSalesIndex>)data);
        }
    }
}

