/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.ExpiryWarningTime;
import com.gridnine.xtrip.common.model.booking.MCOFees;
import com.gridnine.xtrip.common.model.booking.OperationBatch;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductIndexData;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SpecialServiceRequest;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.ProfileGroupReference;
import com.gridnine.xtrip.common.model.dict.SpecialServiceRequestStatus;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MCOFeesHelper;
import com.gridnine.xtrip.common.model.helpers.ProductStatusHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonMetadata;
import com.gridnine.xtrip.common.model.profile.ReasonCode;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.FormattedNumberUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.Predicates;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductIndexHandler
implements IndexHandler<BookingFile, ProductIndex> {
    private final Set<GeneralProductHelper.CommissionType> supplierBspNonDirectCommissionType = new HashSet<GeneralProductHelper.CommissionType>();
    Logger log = LoggerFactory.getLogger(this.getClass());

    public Class<? extends BaseIndexData<BookingFile, ProductIndex>> getDataClass() {
        return ProductIndexData.class;
    }

    public Class<ProductIndex> getIndexClass() {
        return ProductIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public ProductIndexHandler() {
        this.supplierBspNonDirectCommissionType.add(GeneralProductHelper.CommissionType.STANDARD);
        this.supplierBspNonDirectCommissionType.add(GeneralProductHelper.CommissionType.SUBAGENT);
    }

    public void create(EntityContainer<BookingFile> etc, Collection<BaseIndexData<BookingFile, ProductIndex>> indexes) {
        for (Reservation reservation : ((BookingFile)etc.getEntity()).getReservations()) {
            DataAggregator aggregator = new DataAggregator();
            for (BaseProduct product : reservation.getProducts()) {
                if (!(product instanceof Product)) continue;
                Product airProduct = (Product)product;
                ProductIndexData data = new ProductIndexData();
                this.updateData(data, aggregator, airProduct);
                data.setAggregatedData(aggregator.toString());
                indexes.add((BaseIndexData<BookingFile, ProductIndex>)data);
                aggregator.reset();
            }
        }
    }

    protected void updateData(ProductIndexData data, DataAggregator aggregator, Product product) {
        String notes;
        String routeLine;
        BigDecimal equivalentFare;
        List clientFops = AirProductHelper.getClientFops((Product)product);
        List payers = clientFops.stream().map(ProductFop::getPayer).collect(Collectors.toList());
        data.setPayers(payers);
        EntityReference clientRelationMediator = GeneralProductHelper.getClientRelationMediator((BaseProduct)product);
        data.setMediator(clientRelationMediator);
        aggregator.aggregate((Object)clientRelationMediator);
        data.setNavigationKey(product.getUid());
        String bookingNumber = TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile());
        data.setBookingNumber(bookingNumber);
        data.setReservationType(product.getReservation().getType());
        data.setReservationUid(product.getReservation().getUid());
        data.setCouponStatusState(product.getCouponStatusState());
        List<String> recordLocators = IndexBuilderHelper.getRecordLocators(product.getReservation());
        data.setRecordLocators(recordLocators);
        aggregator.aggregate(recordLocators);
        List<GdsName> gdsNames = IndexBuilderHelper.getGdsNames(product.getReservation());
        data.setGdsNames(gdsNames);
        aggregator.aggregate(gdsNames);
        data.setDisplayedRecordLocator(CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)product.getReservation()));
        data.setDisplayedGdsName(CommonReservationGdsNameInfoHelper.getDisplayedGdsName((Reservation)product.getReservation()));
        data.setRulesGdsName(product.getReservation().getGdsNameInfo().getRulesGdsName());
        String blankOwnerNumber = product.getBlankOwnerNumber();
        data.setBlankOwnerNumber(blankOwnerNumber);
        data.setBlankOwner(product.getBlankOwnerRef());
        ProductStatus status = product.getStatus();
        data.setStatus(status);
        Date issueDate = product.getIssueDate();
        data.setIssueDate(issueDate);
        data.setIssueDateTime(issueDate);
        data.setLocalIssueDate(product.getLocalIssueDate());
        data.setWarningAboutExpiring(MiscUtil.minimum((Date[])((Date[])product.getReservation().getTimeLimitExpiryWarningTime().stream().filter(expiryWarningTime -> !expiryWarningTime.isPassed()).map(ExpiryWarningTime::getTimeLimitExpiryWarningTime).toArray(Date[]::new))));
        data.setPcc(product.getPcc());
        data.setBookingPccList(IndexBuilderHelper.getBookingPccList(product.getReservation()));
        AirProductContractRelationData clientContractRelation = AirProductHelper.getClientContractRelation((Product)product);
        AirProductContractRelationData vendorContractRelation = AirProductHelper.getVendorContractRelation((Product)product);
        AirProductContractRelationData subagentContractRelation = AirProductHelper.getSubagentContractRelation((Product)product, (boolean)false);
        String systemNumber = product.getSystemNumber();
        ArrayList<String> ticketNumbers = new ArrayList<String>();
        if (!TextUtil.isBlank((String)systemNumber)) {
            ticketNumbers.add(systemNumber);
            for (int n = 0; n < product.getConjCount(); ++n) {
                try {
                    ticketNumbers.add(FormattedNumberUtil.add((String)systemNumber, (long)(n + 1)));
                    continue;
                }
                catch (Exception e) {
                    this.log.error("unable to parse ticket number " + systemNumber, (Throwable)e);
                }
            }
        }
        data.setTicketNumbers(ticketNumbers);
        data.setBlankOwnerNumber(product.getBlankOwnerNumber());
        data.setIssuingAgentCode(product.getCashierCode());
        List<String> bookingAgentDutyCodes = IndexBuilderHelper.getBookingAgentDutyCodes(product.getReservation());
        data.setBookingAgentCodes(bookingAgentDutyCodes);
        Reservation prodReservation = product.getReservation();
        if (prodReservation != null) {
            data.setReservationStatus(prodReservation.getStatus());
            data.setReservationDate(prodReservation.getResDate());
        }
        data.setTicketType(product.getTicketType() != null ? product.getTicketType() : TicketType.OWN);
        String ticketNumber = ticketNumbers.isEmpty() ? (status == ProductStatus.VOID ? this.buildFullNumber(product.getScns()) : null) : this.buildFullNumber(ticketNumbers);
        String sortingNumber = ticketNumber;
        data.setFirstTicketNumber((String)CollectionUtil.head(ticketNumbers));
        data.setSncs((Collection)product.getScns());
        data.setChecked(Boolean.valueOf(product.isChecked()));
        data.setCompleted(Boolean.valueOf(product.isCompleted()));
        data.setDuplicate(Boolean.valueOf(product.isDuplicate()));
        ProductCategory productCategory = product.getProductCategory();
        data.setProductCategory(productCategory);
        data.setMcoCategory(product.getMcoCategory());
        data.setMcoReservationRequestStatus(product.getMcoReservationRequestStatus());
        data.setAgent(product.getCashier());
        data.setSubsidizedTariff(Boolean.valueOf(product.isSubsidizedTariff()));
        StringBuilder email = new StringBuilder();
        if (product.getReservation() != null && product.getReservation().getBookingFile() != null) {
            data.setClient(product.getReservation().getBookingFile().getCustomerProfile());
            try {
                EntityContainer client = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
                if (client != null) {
                    String code = SystemHelper.findMetadataAsString((Collection)((Organization)client.getEntity()).getMetadata(), (MetadataKey)MetadataKey.KEY_ACCOUNTING_SYSTEM_CODE);
                    data.setClientAccountingCode(code != null ? code : ((Organization)client.getEntity()).getCode());
                    ArrayList<ProfileGroupReference> clientGroups = new ArrayList<ProfileGroupReference>();
                    for (Metadata metadata : ((Organization)client.getEntity()).getMetadata()) {
                        if (metadata.getKey() == null || !metadata.getKey().getCode().equals(MetadataKey.KEY_ORGANIZATION_PROFILE_GROUP.name()) || metadata.getValue() == null) continue;
                        clientGroups.add((ProfileGroupReference)metadata.getValue());
                    }
                    data.setClientGroups(clientGroups);
                    aggregator.aggregate(clientGroups);
                }
            }
            catch (Throwable e) {
                this.log.error("unable to load profile " + product.getReservation().getBookingFile().getCustomerProfile(), e);
            }
            if (product.getReservation().getBookingFile().getCustomer() != null) {
                for (Communication c : product.getReservation().getBookingFile().getCustomer().getCommunications()) {
                    if (c == null || !CommunicationType.EMAIL.equals((Object)c.getType()) || TextUtil.isBlank((String)c.getSense())) continue;
                    email = email.append(email.length() > 0 ? ", " + c.getSense() : c.getSense());
                }
                data.setEmail(TextUtil.adjustStringToLimit((String)email.toString(), (String)", ", (int)255));
            }
        }
        String validatorCode = product.getValidatorCode();
        data.setValidatorCode(validatorCode);
        data.setSubagency(AirProductHelper.getSubagency((Product)product));
        EntityContainer clientContainer = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
        if (clientContainer != null) {
            data.setHolding(((Organization)clientContainer.getEntity()).getHolding());
            aggregator.aggregate((Object)((Organization)clientContainer.getEntity()).getHolding());
        }
        data.setBranch(product.getBranch());
        data.setSalesPoint(product.getSalesPoint());
        data.setReservationSalesPoint(product.getReservation().getSalesPoint());
        data.setBlankType(product.getBlankType());
        data.setCarrier(product.getCarrier());
        if (product.getCarrier() != null) {
            StringBuilder carrierNames = new StringBuilder();
            Airline airline = (Airline)DictionaryCache.get().resolveReference(product.getCarrier());
            if (airline != null) {
                Object carrierCode = (String)airline.getCodeVariants().get(CodeSystem.IATA.name());
                if (TextUtil.isBlank((String)carrierCode) && !airline.getCodeVariants().isEmpty()) {
                    carrierCode = (String)airline.getCodeVariants().values().iterator().next();
                }
                data.setValidatingCarrierCode((String)carrierCode);
                aggregator.aggregate(carrierCode);
                for (String name : airline.getTranslations().values()) {
                    if (TextUtil.isBlank((String)name)) continue;
                    carrierNames.append("|");
                    carrierNames.append(name);
                }
                if (!TextUtil.isBlank((String)airline.getAirlineNumber())) {
                    carrierNames.append("|");
                    carrierNames.append(airline.getAirlineNumber());
                }
                carrierNames.append("|");
                carrierNames.append(airline.getCode());
            }
            data.setCarrierName(carrierNames.toString());
        }
        data.setCarrierNumber(product.getCarrierNumber());
        data.setEticket(Boolean.valueOf(product.isEticket()));
        data.setTripartiteContract(product.getTripartiteContractDetails().getContract());
        data.setTripartiteContractDiscountCode(product.getTripartiteContractDetails().getDiscountCode());
        data.setTripartiteContractCode(product.getTripartiteContractDetails().getContractCode());
        aggregator.aggregate((Object)product.getTripartiteContractDetails().getContract());
        aggregator.aggregate((Object)product.getTripartiteContractDetails().getDiscountCode());
        aggregator.aggregate((Object)product.getTripartiteContractDetails().getContractCode());
        String militaryClaimNumber = GeneralProductHelper.getMilitaryClaimNumber((BaseProduct)product);
        data.setMilitaryClaimNumber(militaryClaimNumber);
        aggregator.aggregate((Object)militaryClaimNumber);
        Date refuseDate = null;
        for (ProductFop fop : clientContractRelation.getFops()) {
            if (!fop.isRefused() || fop.getOperationDate() == null || refuseDate != null && !refuseDate.after(fop.getOperationDate())) continue;
            refuseDate = fop.getOperationDate();
        }
        if (refuseDate != null) {
            data.setCancellationDate(refuseDate);
            aggregator.aggregate(refuseDate);
        }
        if ((equivalentFare = AirProductHelper.getEquivalentFare((Product)product)) == null) {
            equivalentFare = BigDecimal.ZERO;
        }
        HashSet<String> passportNumbers = new HashSet<String>();
        if (product.getTraveller() != null && product.getTraveller().getPassport() != null && product.getTraveller().getPassport().getNumber() != null) {
            passportNumbers.add(product.getTraveller().getPassport().getNumber());
            data.setPassengerPassportNumbers(passportNumbers);
        }
        OperationBatch batch = null;
        if (status != null) {
            switch (status) {
                case BOOKING: 
                case VOID: 
                case VOID_BOOKING: {
                    batch = OperationBatch.VOID;
                    break;
                }
                case REFUND: {
                    batch = OperationBatch.REFUND;
                    sortingNumber = product.getSystemNumber() + "3";
                    break;
                }
                case SELL: {
                    if (productCategory == ProductCategory.AIR && product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
                        sortingNumber = ticketNumber + "4";
                        batch = OperationBatch.EXCHANGE;
                        break;
                    }
                    if (productCategory == ProductCategory.MCO && (product.getMcoCategory() == MCOCategory.PENALTY || product.getMcoCategory() == MCOCategory.INFORMATION)) {
                        Product prod = AirProductHelper.findRelatedAirProduct((Product)product, null, (boolean)false);
                        if (prod != null && prod.getStatus() == ProductStatus.REFUND) {
                            sortingNumber = prod.getSystemNumber() + (product.getMcoCategory() == MCOCategory.PENALTY ? "2" : "1");
                            batch = OperationBatch.REFUND;
                            break;
                        }
                        if (prod != null && prod.getStatus() == ProductStatus.EXCHANGE) {
                            sortingNumber = prod.getSystemNumber() + (product.getMcoCategory() == MCOCategory.PENALTY ? "2" : "1");
                            batch = OperationBatch.EXCHANGE;
                            break;
                        }
                    }
                    batch = OperationBatch.SELL;
                    break;
                }
                case EXCHANGE: {
                    batch = OperationBatch.EXCHANGE;
                    if (product.getNextProduct() == null || product.getNextProduct().getStatus() != ProductStatus.SELL) break;
                    sortingNumber = product.getNextProduct().getSystemNumber() + "3";
                    break;
                }
            }
        }
        data.setTariffType(product.getTariffType());
        aggregator.aggregate((Enum)product.getTariffType());
        ArrayList<String> classOfBookingCodes = new ArrayList<String>();
        ArrayList<String> flightNos = new ArrayList<String>();
        ArrayList<String> fareBasises = new ArrayList<String>();
        int segmentsCount = 0;
        ArrayList<DictionaryReference> opCarriersRef = new ArrayList<DictionaryReference>();
        ArrayList<DictionaryReference> cities = new ArrayList<DictionaryReference>();
        ArrayList<DictionaryReference> countries = new ArrayList<DictionaryReference>();
        DictionaryReference prevCity = null;
        DictionaryReference prevCountry = null;
        DictionaryCache dictCache = DictionaryCache.get();
        ArrayList<DictionaryReference> aircrafts = new ArrayList<DictionaryReference>();
        HashSet<String> airlineLocators = new HashSet<String>();
        boolean hasPendingSsrs = false;
        Date ssrLastDate = null;
        for (SegmentTariff st : product.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                GeoLocation arrLoc;
                GeoLocation depLoc;
                String classOfBookingCode = null;
                if (!TextUtil.isBlank((String)seg.getClassOfService())) {
                    classOfBookingCode = seg.getClassOfService().trim().toUpperCase();
                } else if (!TextUtil.isBlank((String)seg.getClassOfSvcCode())) {
                    classOfBookingCode = seg.getClassOfSvcCode().trim().toUpperCase();
                }
                if (classOfBookingCode != null && !classOfBookingCodes.contains(classOfBookingCode)) {
                    classOfBookingCodes.add(classOfBookingCode);
                }
                if (!TextUtil.isBlank((String)seg.getFlightNo())) {
                    flightNos.add(seg.getFlightNo().trim().toUpperCase());
                }
                if (!TextUtil.isBlank((String)seg.getFareBasis())) {
                    fareBasises.add(seg.getFareBasis().toUpperCase());
                }
                if (seg.getCodeShareCarrier() != null && !opCarriersRef.contains(seg.getCodeShareCarrier())) {
                    opCarriersRef.add(seg.getCodeShareCarrier());
                }
                if (!TextUtil.isBlank((String)seg.getAirlineLocator())) {
                    airlineLocators.add(seg.getAirlineLocator());
                }
                if (prevCity == null && seg.getDepartureLocation() != null || prevCity != null && !prevCity.equals((Object)seg.getDepartureLocation()) && seg.getDepartureLocation() != null) {
                    cities.add(seg.getDepartureLocation());
                }
                if ((depLoc = (GeoLocation)dictCache.resolveReference(seg.getDepartureLocation())) != null && (prevCountry == null || depLoc.getCountry() != null && !depLoc.getCountry().equals(prevCountry))) {
                    countries.add(depLoc.getCountry());
                    prevCountry = depLoc.getCountry();
                }
                if (seg.getArriveLocation() != null) {
                    cities.add(seg.getArriveLocation());
                    prevCity = seg.getArriveLocation();
                }
                if ((arrLoc = (GeoLocation)dictCache.resolveReference(seg.getArriveLocation())) != null && (prevCountry == null || arrLoc.getCountry() != null && !arrLoc.getCountry().equals((Object)prevCountry))) {
                    countries.add(arrLoc.getCountry());
                    prevCountry = arrLoc.getCountry();
                }
                for (SpecialServiceRequest ssr : seg.getSsrs()) {
                    if (ssrLastDate == null || ssr.getRequestDate() != null && ssr.getRequestDate().after(ssrLastDate)) {
                        ssrLastDate = ssr.getRequestDate();
                    }
                    if (ssr.getStatus() != SpecialServiceRequestStatus.PENDING) continue;
                    hasPendingSsrs = true;
                }
                if (seg.getBoard() == null) continue;
                aircrafts.add(seg.getBoard());
            }
            segmentsCount += st.getSegments().size();
        }
        if (status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE) {
            segmentsCount = -segmentsCount;
        }
        data.setAirlineLocators(airlineLocators);
        aggregator.aggregate(airlineLocators);
        data.setOperatingCarriers(opCarriersRef);
        data.setRouteCities(cities);
        data.setRouteCountries(countries);
        data.setHasPendingSsrs(Boolean.valueOf(hasPendingSsrs));
        data.setSsrLastDate(ssrLastDate);
        data.setAircrafts(aircrafts);
        for (DictionaryReference aircraftRef : aircrafts) {
            Aircraft aircraft = (Aircraft)dictCache.resolveReference(aircraftRef);
            if (aircraft == null) continue;
            aggregator.aggregate((Object)aircraft.getCode());
            aggregator.aggregate(aircraft.getTranslations().values());
            aggregator.aggregate(aircraft.getCodeVariants().values());
        }
        data.setFareBasises(fareBasises);
        aggregator.aggregate(fareBasises);
        boolean refund = ProductStatusHelper.get().negatesPrice(status);
        boolean exchange = product.getStatus() == ProductStatus.EXCHANGE;
        data.setPassengerType(product.getPassengerType());
        if (product.getTraveller() != null) {
            String travellerPassportName = TextUtil.buildFullName((PersonalName)product.getTraveller().getPassport());
            String travellerName = product.getTraveller().getName();
            if (TextUtil.isBlank((String)travellerPassportName)) {
                travellerPassportName = travellerName;
            }
            data.setTravellerName(travellerPassportName);
            aggregator.aggregate((Object)travellerPassportName);
            data.setPassengerName(travellerName);
            aggregator.aggregate((Object)travellerName);
        }
        data.setRouteLine(!TextUtil.isBlank((String)(routeLine = AirProductHelper.getLocalizedRouteLine((Product)product))) && routeLine.length() > 255 ? "???" : routeLine);
        String routeLineCodes = AirProductHelper.getRouteLine((Product)product, null, (boolean)true, (CodeSystem)CodeSystem.IATA);
        data.setRouteLineCodes(routeLineCodes);
        aggregator.aggregate((Object)routeLineCodes);
        Date firstFlightDate = AirProductHelper.getFirstDepartureDate((Product)product);
        data.setFirstFlightDate(firstFlightDate);
        aggregator.aggregate(firstFlightDate);
        Date lastFlightDate = AirProductHelper.getLastDepartureDate((Product)product);
        data.setLastFlightDate(lastFlightDate);
        aggregator.aggregate(lastFlightDate);
        Date lastArrivalDate = AirProductHelper.getLastArriveDate((Product)product);
        data.setLastArrivalDate(lastArrivalDate);
        aggregator.aggregate(lastArrivalDate);
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            BigDecimal baseFare;
            Object creditCardVendor = AirProductHelper.getCreditCardVendor((Collection)clientContractRelation.getFops());
            data.setClientCardVendor((CardVendor)creditCardVendor);
            aggregator.aggregate((Enum)creditCardVendor);
            creditCardVendor = AirProductHelper.getCreditCardVendor((Collection)vendorContractRelation.getFops());
            data.setSupplierCardVendor((CardVendor)creditCardVendor);
            aggregator.aggregate((Enum)creditCardVendor);
            data.setSegmentsCount(segmentsCount);
            data.setClassOfBookingCodes(classOfBookingCodes);
            aggregator.aggregate(classOfBookingCodes);
            data.setFlightNos(flightNos);
            aggregator.aggregate(flightNos);
            data.setTourCode(product.getTourCode());
            Money baseFareMoney = AirProductHelper.getBaseFare((Product)product);
            BigDecimal bigDecimal = baseFare = baseFareMoney != null ? baseFareMoney.getValue() : BigDecimal.ZERO;
            if (baseFareMoney != null) {
                data.setBaseFareCurrency(baseFareMoney.getCurrency());
                aggregator.aggregate((Object)baseFareMoney.getCurrency());
            }
            if (refund && product.getPreviousProduct() != null) {
                EntityReference sellAgent = product.getPreviousProduct().getCashier();
                data.setSellAgent(sellAgent);
                aggregator.aggregate((Object)sellAgent);
            }
            data.setForcedRefund(Boolean.valueOf(product.isForcedRefund()));
            data.setBase(refund ? baseFare.negate() : baseFare);
            String relatedTicketNo = "";
            for (Product related : product.getRelatedProducts()) {
                relatedTicketNo = related.getSystemNumber();
                if (TextUtil.isBlank((String)relatedTicketNo)) continue;
                data.setRelatedTicketNo(relatedTicketNo);
                break;
            }
            data.setConjCount(product.getConjCount());
            data.setIncludeVat(Boolean.valueOf(AirProductHelper.isHasVat((Product)product)));
            data.setTransportationType(AirProductHelper.getTransportationType((Product)product));
            data.setPenalty(product.getPenalty() != null ? product.getPenalty() : BigDecimal.ZERO);
            data.setEquivalentFare(refund ? equivalentFare.negate() : equivalentFare);
            if (productCategory == ProductCategory.MCO && product.getMcoCategory() == MCOCategory.PENALTY) {
                data.setEquivalentFare(BigDecimal.ZERO);
                data.setPenalty(equivalentFare);
            }
            data.setEquivalentFareCurrency(product.getGdsCurrency());
            data.setValid(Boolean.valueOf(true));
            data.setHasWarnings(Boolean.valueOf(false));
            data.setHasOtherErrors(Boolean.valueOf(false));
            data.setHasStockControlErrors(Boolean.valueOf(false));
            data.setHasRulesErrors(Boolean.valueOf(false));
            data.setHasErrors(Boolean.valueOf(false));
            for (ValidationMessage message : product.getValidationMessages()) {
                if (message.getSeverity() == ValidationMessageSeverity.WARNING) {
                    data.setHasWarnings(Boolean.valueOf(true));
                }
                if (message.getSeverity() == ValidationMessageSeverity.USER_ERROR) {
                    data.setHasUserErrors(Boolean.valueOf(true));
                    data.setHasErrors(Boolean.valueOf(true));
                }
                if (message.getSeverity() != ValidationMessageSeverity.ERROR) continue;
                data.setHasErrors(Boolean.valueOf(true));
                if (message.getCategory() == ValidationMessageCategory.OTHER) {
                    data.setValid(Boolean.valueOf(false));
                    data.setHasOtherErrors(Boolean.valueOf(true));
                }
                if (message.getCategory() == ValidationMessageCategory.STOCK_CONTROL) {
                    data.setHasStockControlErrors(Boolean.valueOf(true));
                }
                if (message.getCategory() != ValidationMessageCategory.RULES) continue;
                data.setHasRulesErrors(Boolean.valueOf(true));
            }
            BigDecimal taxesForBlank = AirProductTaxHelper.getTaxesForBlankEquivalentAmount((Product)product);
            BigDecimal allTaxes = AirProductTaxHelper.getEquivalentTaxesAmount((Product)product);
            BigDecimal otherTaxes = allTaxes.subtract(taxesForBlank);
            data.setTaxesForBlankSum(refund ? taxesForBlank.negate() : taxesForBlank);
            data.setTaxesSum(refund ? allTaxes.negate() : allTaxes);
            data.setTaxesOtherSum(refund ? otherTaxes.negate() : otherTaxes);
            VatAmount price = BookingHelper.calculateProductPrice((BaseProduct)product, (ContractType)ContractType.CLIENT);
            BigDecimal totalSum = price.getTotal();
            data.setTotalSum(totalSum);
            BigDecimal totalEquivalentFare = AirProductHelper.getTotalEquivalentFare((Product)product);
            data.setTotalEquivalentFare(refund ? totalEquivalentFare.negate() : totalEquivalentFare);
            if (product.getTotalVendorEquivalentVatAmount() == null) {
                data.setVatRate(price.getVat());
                data.setVatValue(price.getVatAmount());
            } else if (product.getTotalVendorEquivalentVatAmount().compareTo(BigDecimal.ZERO) == 0) {
                data.setVatRate(Double.valueOf(0.0));
                data.setVatValue(BigDecimal.ZERO);
            } else {
                data.setVatRate(Double.valueOf(MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat((Date)product.getIssueDate())).doubleValue()));
                data.setVatValue(totalSum.compareTo(BigDecimal.ZERO) >= 0 ? product.getTotalVendorEquivalentVatAmount() : product.getTotalVendorEquivalentVatAmount().negate());
            }
            try {
                Double clientFeeRate;
                Double clientBonusRate;
                Double clientCommissionRate;
                Double subagencyFeeRate;
                Double subagencyBonusRate;
                Double subagencyCommissionRate;
                Double vendorFeeRate;
                Double vendorBonusRate;
                BigDecimal vendorCommissionsBaseValue;
                BigDecimal vendorCommissionsValue;
                Double vendorCommissionRate;
                BigDecimal vendorCommissionsRate;
                if (AirProductHelper.isBSPTicket((Product)product)) {
                    Double vendorBspCommissionRate;
                    Double bspCommissionRate = product.getBspCommissionRate();
                    if (refund && bspCommissionRate != null) {
                        bspCommissionRate = BigDecimal.valueOf(-1.0 * bspCommissionRate).doubleValue();
                    }
                    data.setBspCommissionRate(bspCommissionRate);
                    data.setBspCommissionValue(BookingHelper.getCommissionValue((BigDecimal)(product.getBspCommissionValue() != null ? product.getBspCommissionValue().getValue() : null), (boolean)refund));
                    BigDecimal vendorBSPCommissionsRate = AirProductHelper.calculateCommissionsRate((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bspCommissionTypes, null), (boolean)true);
                    BigDecimal vendorBSPCommissionsValue = AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bspCommissionTypes, null));
                    BigDecimal vendorBSPCommissionsBaseValue = AirProductHelper.calculateCommissionsBaseValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bspCommissionTypes, null));
                    Double d = vendorBspCommissionRate = vendorBSPCommissionsRate != null ? Double.valueOf(vendorBSPCommissionsRate.doubleValue()) : null;
                    if (refund && vendorBspCommissionRate != null) {
                        vendorBspCommissionRate = BigDecimal.valueOf(-1.0 * vendorBspCommissionRate).doubleValue();
                    }
                    data.setVendorBspCommissionRate(vendorBspCommissionRate);
                    vendorBSPCommissionsValue = BookingHelper.getCommissionValue((BigDecimal)vendorBSPCommissionsValue, (boolean)refund);
                    data.setVendorBspCommissionValue(vendorBSPCommissionsValue);
                    vendorBSPCommissionsBaseValue = BookingHelper.getCommissionValue((BigDecimal)vendorBSPCommissionsBaseValue, (boolean)refund);
                    data.setVendorBspCommissionBaseValue(vendorBSPCommissionsBaseValue);
                    if (product.getBlankOwnerRef() != null && product.getBlankOwnerRef().equals((Object)AirProductHelper.getSupplier((Product)product))) {
                        data.setVendorCommissionRate(vendorBspCommissionRate);
                        data.setVendorCommissionValue(vendorBSPCommissionsValue);
                        data.setVendorCommissionBaseValue(vendorBSPCommissionsBaseValue);
                    } else {
                        Double vendorCommissionRate2;
                        BigDecimal vendorCommissionsRate2 = AirProductHelper.calculateCommissionsRate((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, this.supplierBspNonDirectCommissionType, null), (boolean)true);
                        Double d2 = vendorCommissionRate2 = vendorCommissionsRate2 != null ? Double.valueOf(vendorCommissionsRate2.doubleValue()) : null;
                        if (refund && vendorCommissionRate2 != null) {
                            vendorCommissionRate2 = BigDecimal.valueOf(-1.0 * vendorCommissionRate2).doubleValue();
                        }
                        BigDecimal vendorCommissionsValue2 = BookingHelper.getCommissionValue((BigDecimal)AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, this.supplierBspNonDirectCommissionType, null)), (boolean)refund);
                        BigDecimal vendorCommissionsBaseValue2 = BookingHelper.getCommissionValue((BigDecimal)AirProductHelper.calculateCommissionsBaseValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, this.supplierBspNonDirectCommissionType, null)), (boolean)refund);
                        data.setVendorCommissionRate(vendorCommissionRate2);
                        data.setVendorCommissionValue(vendorCommissionsValue2);
                        data.setVendorCommissionBaseValue(vendorCommissionsBaseValue2);
                    }
                } else if (product.getBlankOwnerRef() != null && product.getBlankOwnerRef().equals((Object)AirProductHelper.getSupplier((Product)product))) {
                    vendorCommissionsRate = AirProductHelper.calculateCommissionsRate((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, null, null), (boolean)true);
                    Double d = vendorCommissionRate = vendorCommissionsRate != null ? Double.valueOf(vendorCommissionsRate.doubleValue()) : null;
                    if (refund && vendorCommissionRate != null) {
                        vendorCommissionRate = BigDecimal.valueOf(-1.0 * vendorCommissionRate).doubleValue();
                    }
                    vendorCommissionsValue = BookingHelper.getCommissionValue((BigDecimal)AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, null, null)), (boolean)refund);
                    vendorCommissionsBaseValue = BookingHelper.getCommissionValue((BigDecimal)AirProductHelper.calculateCommissionsBaseValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, null, null)), (boolean)refund);
                    data.setVendorCommissionRate(vendorCommissionRate);
                    data.setVendorCommissionValue(vendorCommissionsValue);
                    data.setVendorCommissionBaseValue(vendorCommissionsBaseValue);
                } else {
                    vendorCommissionsRate = AirProductHelper.calculateCommissionsRate((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.subagentCommissionTypes, null), (boolean)true);
                    Double d = vendorCommissionRate = vendorCommissionsRate != null ? Double.valueOf(vendorCommissionsRate.doubleValue()) : null;
                    if (refund && vendorCommissionRate != null) {
                        vendorCommissionRate = BigDecimal.valueOf(-1.0 * vendorCommissionRate).doubleValue();
                    }
                    vendorCommissionsValue = BookingHelper.getCommissionValue((BigDecimal)AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.subagentCommissionTypes, null)), (boolean)refund);
                    vendorCommissionsBaseValue = BookingHelper.getCommissionValue((BigDecimal)AirProductHelper.calculateCommissionsBaseValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.subagentCommissionTypes, null)), (boolean)refund);
                    data.setVendorCommissionRate(vendorCommissionRate);
                    data.setVendorCommissionValue(vendorCommissionsValue);
                    data.setVendorCommissionBaseValue(vendorCommissionsBaseValue);
                }
                BigDecimal vendorBonusCommissionsRate = AirProductHelper.calculateCommissionsRate((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true);
                BigDecimal vendorBonusCommissionsValue = AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null));
                Double d = vendorBonusRate = vendorBonusCommissionsRate != null ? Double.valueOf(vendorBonusCommissionsRate.doubleValue()) : null;
                if (refund && vendorBonusRate != null) {
                    vendorBonusRate = BigDecimal.valueOf(-1.0 * vendorBonusRate).doubleValue();
                }
                data.setVendorBonusRate(vendorBonusRate);
                data.setVendorBonusValue(BookingHelper.getCommissionValue((BigDecimal)vendorBonusCommissionsValue, (boolean)refund));
                ProductFare totalFare = null;
                boolean segmentTariffs = false;
                for (ProductFare fare : product.getFares()) {
                    if (fare.getSegmentTariff() == null) {
                        totalFare = (ProductFare)XCloneHelper.clone((XCloneable)fare);
                        break;
                    }
                    segmentTariffs = true;
                }
                if (totalFare == null && segmentTariffs) {
                    totalFare = new ProductFare();
                }
                if (totalFare != null) {
                    this.updateTotalFare(totalFare, product);
                }
                BigDecimal rate = null;
                if (totalFare != null && totalFare.getBaseFare() != null && totalFare.getBaseFare().getCurrency() != null) {
                    Date date = AirProductHelper.getCurrencyRateDate((Product)product);
                    CurrencyRate currencyRate = BookingHelper.findCurrencyRate((String)totalFare.getBaseFare().getCurrency(), (Date)date, (CurrencyRateType)CurrencyRateType.IATA, (TariffType)product.getTariffType(), (EntityReference)product.getBlankOwnerRef());
                    if (currencyRate != null) {
                        rate = BigDecimal.valueOf(currencyRate.getRate());
                    }
                }
                data.setExchangeRate(rate != null ? Double.valueOf(MiscUtil.scale((BigDecimal)BigDecimal.valueOf(rate.doubleValue()), (int)2, (RoundingMode)RoundingMode.HALF_UP).doubleValue()) : null);
                BigDecimal vendorFeesRate = AirProductHelper.calculateCommissionsRate((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true);
                BigDecimal vendorFeesValue = AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.feePropertyTypes, null, null));
                Double d3 = vendorFeeRate = vendorFeesRate != null ? Double.valueOf(vendorFeesRate.doubleValue()) : null;
                if (refund && vendorFeeRate != null) {
                    vendorFeeRate = BigDecimal.valueOf(-1.0 * vendorFeeRate).doubleValue();
                }
                data.setVendorFeeRate(vendorFeeRate);
                data.setVendorFeeValue(BookingHelper.getCommissionValue((BigDecimal)vendorFeesValue, (boolean)refund));
                BigDecimal subagencyStandardCommissionsRate = AirProductHelper.calculateCommissionsRate((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true);
                BigDecimal subagencyStandardCommissionsValue = AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null));
                Double d4 = subagencyCommissionRate = subagencyStandardCommissionsRate != null ? Double.valueOf(subagencyStandardCommissionsRate.doubleValue()) : null;
                if (refund && subagencyCommissionRate != null) {
                    subagencyCommissionRate = BigDecimal.valueOf(-1.0 * subagencyCommissionRate).doubleValue();
                }
                data.setSubagencyCommissionRate(subagencyCommissionRate);
                data.setSubagencyCommissionValue(BookingHelper.getCommissionValue((BigDecimal)subagencyStandardCommissionsValue, (boolean)refund));
                BigDecimal subagencyBonusCommissionsRate = AirProductHelper.calculateCommissionsRate((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true);
                BigDecimal subagencyBonusCommissionsValue = AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null));
                Double d5 = subagencyBonusRate = subagencyBonusCommissionsRate != null ? Double.valueOf(subagencyBonusCommissionsRate.doubleValue()) : null;
                if (refund && subagencyBonusRate != null) {
                    subagencyBonusRate = BigDecimal.valueOf(-1.0 * subagencyBonusRate).doubleValue();
                }
                data.setSubagencyBonusRate(subagencyBonusRate);
                data.setSubagencyBonusValue(BookingHelper.getCommissionValue((BigDecimal)subagencyBonusCommissionsValue, (boolean)refund));
                BigDecimal subagencyFeesRate = AirProductHelper.calculateCommissionsRate((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true);
                BigDecimal subagencyFeesValue = AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, null));
                Double d6 = subagencyFeeRate = subagencyFeesRate != null ? Double.valueOf(subagencyFeesRate.doubleValue()) : null;
                if (refund && subagencyFeeRate != null) {
                    subagencyFeeRate = BigDecimal.valueOf(-1.0 * subagencyFeeRate).doubleValue();
                }
                data.setSubagencyFeeRate(subagencyFeeRate);
                data.setSubagencyFeeValue(BookingHelper.getCommissionValue((BigDecimal)subagencyFeesValue, (boolean)refund));
                BigDecimal clientStandardCommissionsRate = AirProductHelper.calculateCommissionsRate((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true);
                BigDecimal clientStandardCommissionsValue = AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null));
                Double d7 = clientCommissionRate = clientStandardCommissionsRate != null ? Double.valueOf(clientStandardCommissionsRate.doubleValue()) : null;
                if (refund && clientCommissionRate != null) {
                    clientCommissionRate = BigDecimal.valueOf(-1.0 * clientCommissionRate).doubleValue();
                }
                data.setClientCommissionRate(clientCommissionRate);
                data.setClientCommissionValue(BookingHelper.getCommissionValue((BigDecimal)clientStandardCommissionsValue, (boolean)refund));
                BigDecimal clientBonusCommissionsRate = AirProductHelper.calculateCommissionsRate((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true);
                BigDecimal clientBonusCommissionsValue = AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null));
                Double d8 = clientBonusRate = clientBonusCommissionsRate != null ? Double.valueOf(clientBonusCommissionsRate.doubleValue()) : null;
                if (refund && clientBonusRate != null) {
                    clientBonusRate = BigDecimal.valueOf(-1.0 * clientBonusRate).doubleValue();
                }
                data.setClientBonusRate(clientBonusRate);
                data.setClientBonusValue(BookingHelper.getCommissionValue((BigDecimal)clientBonusCommissionsValue, (boolean)refund));
                BigDecimal clientFeesRate = AirProductHelper.calculateCommissionsRate((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true);
                BigDecimal clientFeesValue = AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null));
                Double d9 = clientFeeRate = clientFeesRate != null ? Double.valueOf(clientFeesRate.doubleValue()) : null;
                if (refund && clientFeeRate != null) {
                    clientFeeRate = BigDecimal.valueOf(-1.0 * clientFeeRate).doubleValue();
                }
                data.setClientFeeRate(clientFeeRate);
                data.setClientFeeValue(BookingHelper.getCommissionValue((BigDecimal)clientFeesValue, (boolean)refund));
                data.setAgentPenaltyForProduct(BookingHelper.calculateAgentPenaltyForProduct((BaseProduct)product));
                data.setAgentPenaltyForCommissions(AirProductHelper.calculateAgentPenaltyForCommissions((Product)product));
                data.setAgentPenaltyForFees(BookingHelper.calculateAgentPenaltyForFees((BaseProduct)product));
            }
            catch (Exception e) {
                this.log.error("failed calculating commissions ", (Throwable)e);
            }
            Date date = null;
            EntityReference agent = null;
            boolean hasClientDebt = false;
            HashSet<PaymentType> clientFopTypes = new HashSet<PaymentType>();
            HashSet<PaymentType> clientFeesFopTypes = new HashSet<PaymentType>();
            BigDecimal clientFOPAmount = null;
            BigDecimal clientFOPAddAmount = null;
            BigDecimal clientFOPTotalAddAmount = null;
            EnumSet<PaymentType> addPaymentTypes = EnumSet.allOf(PaymentType.class);
            addPaymentTypes.remove(PaymentType.TICKET);
            addPaymentTypes.remove(PaymentType.VOUCHER);
            addPaymentTypes.remove(PaymentType.MTD);
            addPaymentTypes.remove(PaymentType.MTD_AGENCY);
            addPaymentTypes.remove(PaymentType.CREDIT);
            addPaymentTypes.remove(PaymentType.CREDIT_CARD);
            for (ProductFop fop : clientContractRelation.getFops()) {
                BigDecimal fopAmount;
                if (fop.getAmount() != null && fop.getAmount().getValue() != null) {
                    fopAmount = fop.getAmount().getValue();
                    BigDecimal bigDecimal2 = clientFOPAmount = clientFOPAmount != null ? clientFOPAmount.add(fopAmount) : fopAmount;
                }
                if (!exchange && fop.getAmount() != null && fop.getAmount().getValue() != null && addPaymentTypes.contains(fop.getType()) && GeneralProductHelper.productFopTypes.contains(AirProductHelper.getFopType((ProductFop)fop))) {
                    fopAmount = fop.getAmount().getValue();
                    BigDecimal bigDecimal3 = clientFOPAddAmount = clientFOPAddAmount != null ? clientFOPAddAmount.add(fopAmount) : fopAmount;
                }
                if (!exchange && fop.getAmount() != null && fop.getAmount().getValue() != null && addPaymentTypes.contains(fop.getType()) && !GeneralProductHelper.discountFopTypes.contains(AirProductHelper.getFopType((ProductFop)fop))) {
                    fopAmount = fop.getAmount().getValue();
                    BigDecimal bigDecimal4 = clientFOPTotalAddAmount = clientFOPTotalAddAmount != null ? clientFOPTotalAddAmount.add(fopAmount) : fopAmount;
                }
                if (fop.getType() != null) {
                    if (AirProductHelper.isServiceFop((ProductFop)fop)) {
                        clientFopTypes.add(fop.getType());
                    } else {
                        clientFeesFopTypes.add(fop.getType());
                    }
                }
                if (fop.getOperationDate() == null) {
                    hasClientDebt = true;
                    continue;
                }
                if (date != null && !date.before(fop.getOperationDate())) continue;
                date = fop.getOperationDate();
                agent = fop.getAgent();
            }
            if (refund && clientFOPAmount != null) {
                clientFOPAmount = clientFOPAmount.negate();
            }
            if (refund && clientFOPAddAmount != null) {
                clientFOPAddAmount = clientFOPAddAmount.negate();
            }
            if (refund && clientFOPTotalAddAmount != null) {
                clientFOPTotalAddAmount = clientFOPTotalAddAmount.negate();
            }
            data.setClientFopAmount(clientFOPAmount);
            data.setClientFopAddAmount(clientFOPAddAmount);
            data.setClientFopTotalAddAmount(clientFOPTotalAddAmount);
            data.setClientFopTypes(clientFopTypes);
            data.setClientFeesFopTypes(clientFeesFopTypes);
            data.setDateOfClientPayment(date);
            data.setClientFopAgent(agent);
            data.setHasClientDebt(Boolean.valueOf(hasClientDebt));
            aggregator.aggregate((Object)relatedTicketNo);
            Date date2 = null;
            HashSet<PaymentType> vendorFopTypes = new HashSet<PaymentType>();
            BigDecimal vendorFOPAmount = null;
            for (ProductFop fop : vendorContractRelation.getFops()) {
                if (fop.getAmount() != null && fop.getAmount().getValue() != null) {
                    BigDecimal fopAmount = fop.getAmount().getValue();
                    BigDecimal bigDecimal5 = vendorFOPAmount = vendorFOPAmount != null ? vendorFOPAmount.add(fopAmount) : fopAmount;
                }
                if (fop.getType() != null) {
                    vendorFopTypes.add(fop.getType());
                }
                if (fop.getOperationDate() == null || date2 != null && !date2.before(fop.getOperationDate())) continue;
                date2 = fop.getOperationDate();
            }
            if (refund && vendorFOPAmount != null) {
                vendorFOPAmount = vendorFOPAmount.negate();
            }
            data.setVendorFopAmount(vendorFOPAmount);
            data.setDateOfVendorPayment(date2);
            data.setVendorFopTypes(vendorFopTypes);
            HashSet<PaymentType> subagentFopTypes = new HashSet<PaymentType>();
            HashSet<PaymentType> subagentFeesFopTypes = new HashSet<PaymentType>();
            if (subagentContractRelation != null && subagentContractRelation.getFops() != null) {
                for (ProductFop fop : subagentContractRelation.getFops()) {
                    if (fop.getType() == null) continue;
                    if (AirProductHelper.isServiceFop((ProductFop)fop)) {
                        subagentFopTypes.add(fop.getType());
                        continue;
                    }
                    subagentFeesFopTypes.add(fop.getType());
                }
            }
            data.setSubagentFopAmount(GeneralProductHelper.getSubagentFopAmount((BaseProduct)product));
            data.setSubagentFopTypes(subagentFopTypes);
            data.setSubagentFeesFopTypes(subagentFeesFopTypes);
        } else {
            data.setValid(Boolean.valueOf(true));
            for (ValidationMessage message : product.getValidationMessages()) {
                if (message.getCategory() != ValidationMessageCategory.OTHER) continue;
                data.setValid(Boolean.valueOf(false));
                break;
            }
            BigDecimal vendorFeeValue = IndexBuilderHelper.getVoidFeeValue((BaseProduct)product, ContractType.VENDOR);
            BigDecimal subagencyFeeValue = IndexBuilderHelper.getVoidFeeValue((BaseProduct)product, ContractType.SUBAGENCY);
            BigDecimal clientFeeValue = IndexBuilderHelper.getVoidFeeValue((BaseProduct)product, ContractType.CLIENT);
            Double vendorFeeRate = IndexBuilderHelper.getVoidFeeRate((BaseProduct)product, ContractType.VENDOR);
            Double subagencyFeeRate = IndexBuilderHelper.getVoidFeeRate((BaseProduct)product, ContractType.SUBAGENCY);
            Double clientFeeRate = IndexBuilderHelper.getVoidFeeRate((BaseProduct)product, ContractType.CLIENT);
            data.setVendorFeeValue(vendorFeeValue);
            data.setSubagencyFeeValue(subagencyFeeValue);
            data.setClientFeeValue(clientFeeValue);
            data.setVendorFeeRate(vendorFeeRate);
            data.setSubagencyFeeRate(subagencyFeeRate);
            data.setClientFeeRate(clientFeeRate);
            data.setVendorFopAmount(vendorFeeValue);
            data.setSubagentFopAmount(subagencyFeeValue);
            data.setClientFopAmount(clientFeeValue);
            data.setFlightNos(flightNos);
            aggregator.aggregate(flightNos);
            data.setHasOtherErrors(Boolean.valueOf(false));
            data.setHasErrors(Boolean.valueOf(false));
        }
        for (String number : ticketNumbers) {
            aggregator.aggregate((Object)number);
        }
        aggregator.aggregate((Object)product.getBlankOwnerRef());
        data.setSupplier(AirProductHelper.getSupplier((Product)product));
        aggregator.aggregate((Object)AirProductHelper.getSupplier((Product)product));
        data.setAgency(AirProductHelper.getAgency((Product)product));
        aggregator.aggregate((Object)AirProductHelper.getAgency((Product)product));
        data.setSortingTicketNumber(sortingNumber);
        data.setOperationBatch(batch);
        data.setOverallClassService(ProductIndexHandler.calculateOverallClassService(product));
        if (product.getStatisticalData() != null) {
            StatisticalData stat = product.getStatisticalData();
            data.setLowestAvailableFare(stat.getLowestAvailableFare());
            data.setHigherBenchmarkFare(stat.getHigherBenchmarkFare());
            data.setValidatingCarrier(stat.getValidatingCarrier());
            data.setOverallDestination(stat.getOverallDestination());
            data.setActualTicketFare(stat.getActualTicketFare());
            data.setHbf1Bkg(stat.getHbf1Bkg());
            data.setHbf1Tkt(stat.getHbf1Tkt());
            data.setHbf2Bkg(stat.getHbf2Bkg());
            data.setHbf2Tkt(stat.getHbf2Tkt());
            data.setLaf1Bkg(stat.getLaf1Bkg());
            data.setLaf1Tkt(stat.getLaf1Tkt());
            data.setLaf2Bkg(stat.getLaf2Bkg());
            data.setLaf2Tkt(stat.getLaf2Tkt());
            data.setLaf3Bkg(stat.getLaf3Bkg());
            data.setLaf3Tkt(stat.getLaf3Tkt());
            data.setAtf1Bkg(stat.getAtf1Bkg());
            data.setAtf1Tkt(stat.getAtf1Tkt());
            data.setAtf2Bkg(stat.getAtf2Bkg());
            data.setAtf2Tkt(stat.getAtf2Tkt());
            data.setLbf1Bkg(stat.getLpf1Bkg());
            data.setLbf1Tkt(stat.getLpf1Tkt());
            data.setLbf2Bkg(stat.getLpf2Bkg());
            data.setLbf2Tkt(stat.getLpf2Tkt());
            data.setLbf3Bkg(stat.getLpf3Bkg());
            data.setLbf3Tkt(stat.getLpf3Tkt());
            data.setP3dBkg(stat.getP3dBkg());
            data.setP3dTkt(stat.getP3dTkt());
            data.setCtfBkg(stat.getCtfBkg());
            data.setCtfTkt(stat.getCtfTkt());
            StringBuilder ccStr = new StringBuilder();
            for (Object cc : StatisticsHelper.getAllCostCodes((StatisticalData)product.getStatisticalData())) {
                ccStr.append(ccStr.length() > 0 ? "," : "").append(cc.getCostCodeProperties() != null ? cc.getCostCodeProperties().getName() : "").append(" - ").append(cc.getValue());
            }
            data.setCostCodes(ccStr.length() > 255 ? ccStr.toString().substring(0, 255) : ccStr.toString());
            StringBuilder rcStr = new StringBuilder();
            for (ReasonCode rc : product.getStatisticalData().getReasonCodes()) {
                rcStr.append(rcStr.length() > 0 ? "," : "" + rc.getName());
            }
            data.setReasonCodes(rcStr.toString());
        }
        StringBuilder mcoFeesNumbers = new StringBuilder();
        BigDecimal mcoFeesSum = BigDecimal.ZERO;
        for (Reservation res : product.getReservation().getBookingFile().getReservations()) {
            for (BaseProduct bp : res.getProducts()) {
                MCOFees mcoFees;
                if (!(bp instanceof MCOFees) || !MCOFeesHelper.getRelatedProductUids((MCOFees)(mcoFees = (MCOFees)bp)).contains(product.getUid()) || mcoFees.getTotal() == null) continue;
                mcoFeesSum = mcoFeesSum.add(mcoFees.getTotal());
                mcoFeesNumbers.append(mcoFeesNumbers.length() > 0 ? ", " + mcoFees.getScn() : mcoFees.getScn());
            }
        }
        data.setMcoFeesNumbers(mcoFeesNumbers.toString());
        data.setMcoFeesSum(mcoFeesSum);
        List costCodes = StatisticsHelper.findCostCenterCostCodes((StatisticalData)product.getStatisticalData(), (EntityReference)product.getReservation().getBookingFile().getCustomerProfile());
        if (!costCodes.isEmpty()) {
            String value = IndexBuilderHelper.getCostCodesJoinValue(costCodes, CostCode::getValue);
            String localValue = IndexBuilderHelper.getCostCodesJoinValue(costCodes, CostCode::getLocalValue);
            String englishValue = IndexBuilderHelper.getCostCodesJoinValue(costCodes, CostCode::getEnglishValue);
            data.setCostCenter(value);
            data.setCostCenterLocalValue(localValue);
            data.setCostCenterEnglishValue(englishValue);
            aggregator.aggregate((Object)value);
            aggregator.aggregate((Object)localValue);
            aggregator.aggregate((Object)englishValue);
            data.setCostCenterList(IndexBuilderHelper.getCostCodeValues(costCodes, CostCode::getValue));
            data.setCostCenterLocalValueList(IndexBuilderHelper.getCostCodeValues(costCodes, CostCode::getLocalValue));
            data.setCostCenterEnglishValueList(IndexBuilderHelper.getCostCodeValues(costCodes, CostCode::getEnglishValue));
        }
        String comments = TextUtil.getFieldOrTrimToLength((String)product.getComments(), (int)255);
        data.setComments(comments);
        aggregator.aggregate((Object)comments);
        aggregator.aggregate((Object)product.getCashier());
        aggregator.aggregate((Object)bookingNumber);
        aggregator.aggregate((Object)blankOwnerNumber);
        aggregator.aggregate((Enum)status);
        aggregator.aggregate(issueDate);
        aggregator.aggregate((Object)product.getPcc());
        aggregator.aggregate((Object)validatorCode);
        aggregator.aggregate(ticketNumbers);
        aggregator.aggregate((Object)product.getBranch());
        aggregator.aggregate((Object)product.getSalesPoint());
        aggregator.aggregate((Object)product.getReservation().getBookingFile().getAgency());
        aggregator.aggregate((Object)AirProductHelper.getSubagency((Product)product));
        aggregator.aggregate((Object)product.getTourCode());
        aggregator.aggregate((Object)product.getCarrierNumber());
        aggregator.aggregate(bookingAgentDutyCodes);
        aggregator.aggregate((Object)(prodReservation != null ? prodReservation.getBookingAgentInformation() : null));
        aggregator.aggregate((Iterable)product.getScns());
        aggregator.aggregate((Object)product.getConjCount());
        aggregator.aggregate((Object)AirProductHelper.getRouteLine((Product)product));
        aggregator.aggregate((Object)product.isChecked());
        aggregator.aggregate((Object)product.getValidationMessages().isEmpty());
        aggregator.aggregate((Object)product.getPassengerType());
        aggregator.aggregate((Object)product.isEticket());
        aggregator.aggregate((Object)product.getPenalty());
        aggregator.aggregate((Object)equivalentFare);
        aggregator.aggregate((Object)product.getEndorsement());
        aggregator.aggregate((Object)product.getFareCalculationData());
        aggregator.aggregate((Object)product.getBlankType());
        aggregator.aggregate((Object)product.getCarrier());
        aggregator.aggregate((Object)product.getCarrierNumber());
        aggregator.aggregate((Enum)productCategory);
        aggregator.aggregate((Enum)product.getMcoCategory());
        aggregator.aggregate(passportNumbers);
        if (!TextUtil.isBlank((String)email.toString())) {
            aggregator.aggregate((Object)email.toString());
        }
        data.setHasNotes(Boolean.valueOf((notes = product.getReservation().getBookingFile().getNotes()) != null && !notes.trim().isEmpty()));
        boolean inFinanceDocuments = IndexBuilderHelper.isInFinanceDocuments((BaseProduct)product);
        data.setInFinanceDocuments(Boolean.valueOf(inFinanceDocuments));
        boolean inDelivery = IndexBuilderHelper.isInDelivery((BaseProduct)product);
        data.setInDelivery(Boolean.valueOf(inDelivery));
        boolean isInterline = AirProductHelper.isProductInterline((Product)product);
        boolean isCodeShare = AirProductHelper.isProductCodeShare((Product)product);
        data.setInterline(Boolean.valueOf(isInterline));
        data.setCodeshare(Boolean.valueOf(isCodeShare));
        EntityContainer agentContainer = EntityStorage.get().resolve(product.getCashier());
        if (agentContainer != null) {
            Person agent = (Person)agentContainer.getEntity();
            for (PersonMetadata meta : agent.getMetadata()) {
                if (meta.getKey() == null || meta.getKey().getCode() == null || !MetadataKey.KEY_PERSON_PROFILE_GROUP.name().equals(meta.getKey().getCode())) continue;
                DictionaryReference profileGroup = (DictionaryReference)meta.getValue();
                if (profileGroup != null) {
                    aggregator.aggregate((Object)profileGroup);
                }
                data.setProfileGroup(profileGroup);
            }
        }
        data.setBookAgent(product.getReservation().getBookingAgent());
    }

    private static String calculateOverallClassService(Product product) {
        return Optional.ofNullable(product.getStatisticalData()).map(StatisticalData::getOverallClassService).filter(Predicates.not(TextUtil::isBlank)).orElseGet(() -> AirProductHelper.getOverallClassService((Product)product));
    }

    private void updateTotalFare(ProductFare totalFare, Product product) {
        boolean updateBaseFare = false;
        boolean updateEquivalentFare = false;
        boolean updateNuc = false;
        boolean updateRoe = false;
        Money baseFare = totalFare.getBaseFare();
        if (baseFare == null) {
            baseFare = new Money();
            totalFare.setBaseFare(baseFare);
            updateBaseFare = true;
        }
        if (totalFare.getEquivalentFare() == null) {
            updateEquivalentFare = true;
        }
        if (totalFare.getRoe() == null) {
            updateRoe = true;
        }
        if (totalFare.getNucFare() == null) {
            updateNuc = true;
        }
        for (ProductFare fare : product.getFares()) {
            if (fare.getSegmentTariff() == null) continue;
            if (updateBaseFare && fare.getBaseFare() != null) {
                baseFare.setValue(baseFare.getValue() != null ? baseFare.getValue().add(fare.getBaseFare().getValue()) : fare.getBaseFare().getValue());
                baseFare.setCurrency(fare.getBaseFare().getCurrency());
            }
            if (updateEquivalentFare && fare.getEquivalentFare() != null) {
                totalFare.setEquivalentFare(totalFare.getEquivalentFare() != null ? totalFare.getEquivalentFare().add(fare.getEquivalentFare()) : fare.getEquivalentFare());
            }
            if (updateNuc && fare.getNucFare() != null) {
                totalFare.setNucFare(totalFare.getNucFare() != null ? totalFare.getNucFare().add(fare.getNucFare()) : fare.getNucFare());
            }
            if (!updateRoe || fare.getRoe() == null) continue;
            totalFare.setRoe(totalFare.getRoe() != null ? totalFare.getRoe().add(fare.getRoe()) : fare.getRoe());
        }
    }

    private String buildFullNumber(List<String> numbers) {
        StringBuilder sb = new StringBuilder();
        for (String number : numbers) {
            if (TextUtil.isBlank((String)number)) continue;
            if (sb.length() == 0) {
                sb.append(number.trim());
                continue;
            }
            sb.append("/").append(number.trim().substring(number.trim().length() - 1));
        }
        return sb.length() > 0 ? sb.toString() : null;
    }
}

