/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductSearchIndex;
import com.gridnine.xtrip.common.model.booking.ProductSearchIndexData;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.util.FormattedNumberUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductSearchIndexHandler
implements IndexHandler<BookingFile, ProductSearchIndex> {
    Logger log = LoggerFactory.getLogger(this.getClass());

    public Class<? extends BaseIndexData<BookingFile, ProductSearchIndex>> getDataClass() {
        return ProductSearchIndexData.class;
    }

    public Class<ProductSearchIndex> getIndexClass() {
        return ProductSearchIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public void create(EntityContainer<BookingFile> etc, Collection<BaseIndexData<BookingFile, ProductSearchIndex>> indexes) {
        for (Reservation reservation : ((BookingFile)etc.getEntity()).getReservations()) {
            DataAggregator aggregator = new DataAggregator();
            for (BaseProduct product : reservation.getProducts()) {
                if (!(product instanceof Product)) continue;
                List<GdsName> gdsNames = IndexBuilderHelper.getGdsNames(product.getReservation());
                List<String> recordLocators = IndexBuilderHelper.getRecordLocators(product.getReservation());
                Product airProduct = (Product)product;
                int conjCount = airProduct.getConjCount();
                for (int n = 0; n <= conjCount; ++n) {
                    ProductSearchIndexData data = new ProductSearchIndexData();
                    aggregator.aggregate((Object)airProduct.getBlankOwnerRef());
                    data.setAgency(AirProductHelper.getAgency((Product)airProduct));
                    data.setNavigationKey(product.getUid());
                    data.setRecordLocators(recordLocators);
                    data.setGdsNames(gdsNames);
                    String blankOwnerNumber = airProduct.getBlankOwnerNumber();
                    data.setBlankOwnerNumber(blankOwnerNumber);
                    data.setBlankOwner(airProduct.getBlankOwnerRef());
                    ProductStatus status = airProduct.getStatus();
                    data.setStatus(status);
                    data.setProductUid(product.getUid());
                    Date issueDate = airProduct.getIssueDate();
                    data.setIssueDate(issueDate);
                    String systemNumber = airProduct.getSystemNumber();
                    if (n != 0) {
                        try {
                            systemNumber = FormattedNumberUtil.add((String)systemNumber, (long)n);
                        }
                        catch (Exception e) {
                            this.log.error("unable to parse ticket number " + systemNumber, (Throwable)e);
                        }
                    }
                    data.setSystemNumber(systemNumber);
                    data.setBlankOwnerNumber(airProduct.getBlankOwnerNumber());
                    data.setTicketType(airProduct.getTicketType() != null ? airProduct.getTicketType() : TicketType.OWN);
                    if (airProduct.getScns().size() > n) {
                        data.setScn((String)airProduct.getScns().get(n));
                    }
                    data.setProductCategory(airProduct.getProductCategory());
                    data.setMcoCategory(airProduct.getMcoCategory());
                    data.setAgent(airProduct.getCashier());
                    data.setClient(((BookingFile)etc.getEntity()).getCustomerProfile());
                    String validatorCode = airProduct.getValidatorCode();
                    data.setValidatorCode(validatorCode);
                    data.setSubagency(AirProductHelper.getSubagency((Product)airProduct));
                    data.setSalesPoint(airProduct.getSalesPoint());
                    data.setBlankType(airProduct.getBlankType());
                    data.setCarrier(airProduct.getCarrier());
                    data.setEticket(Boolean.valueOf(airProduct.isEticket()));
                    String travellerName = null;
                    if (airProduct.getTraveller() != null && airProduct.getTraveller().getName() != null) {
                        travellerName = TextUtil.first((String)airProduct.getTraveller().getName(), (int)255);
                    }
                    data.setTravellerName(travellerName);
                    for (Product related : airProduct.getRelatedProducts()) {
                        String relatedTicketNo = related.getSystemNumber();
                        if (TextUtil.isBlank((String)relatedTicketNo)) continue;
                        data.setRelatedTicketNo(relatedTicketNo);
                        aggregator.aggregate((Object)relatedTicketNo);
                        break;
                    }
                    data.setConjunctionsCount(conjCount);
                    data.setPassengerType(airProduct.getPassengerType());
                    data.setCarrierNumber(airProduct.getCarrierNumber());
                    data.setTariffType(airProduct.getTariffType());
                    HashSet<String> airlineLocators = new HashSet<String>();
                    for (SegmentTariff segmentTariff : airProduct.getSegmentTariffs()) {
                        for (Segment segment : segmentTariff.getSegments()) {
                            if (!TextUtil.nonBlank((String)segment.getAirlineLocator())) continue;
                            airlineLocators.add(segment.getAirlineLocator());
                        }
                    }
                    data.setAirlineLocators(airlineLocators);
                    aggregator.aggregate(airlineLocators);
                    aggregator.aggregate((Object)airProduct.getCashier());
                    aggregator.aggregate(recordLocators);
                    aggregator.aggregate(gdsNames);
                    aggregator.aggregate((Object)blankOwnerNumber);
                    aggregator.aggregate((Enum)status);
                    aggregator.aggregate(issueDate);
                    aggregator.aggregate((Object)validatorCode);
                    aggregator.aggregate((Object)systemNumber);
                    aggregator.aggregate((Object)airProduct.getSalesPoint());
                    aggregator.aggregate((Object)AirProductHelper.getAgency((Product)airProduct));
                    aggregator.aggregate((Object)AirProductHelper.getSubagency((Product)airProduct));
                    aggregator.aggregate((Object)airProduct.getBlankOwnerRef());
                    aggregator.aggregate((Object)airProduct.getTourCode());
                    aggregator.aggregate((Object)airProduct.getCarrierNumber());
                    aggregator.aggregate((Object)airProduct.getSystemNumber());
                    aggregator.aggregate((Iterable)airProduct.getScns());
                    aggregator.aggregate((Object)airProduct.getConjCount());
                    aggregator.aggregate((Object)AirProductHelper.getRouteLine((Product)airProduct));
                    aggregator.aggregate((Object)airProduct.isChecked());
                    aggregator.aggregate((Object)airProduct.getValidationMessages().isEmpty());
                    aggregator.aggregate((Object)airProduct.getPassengerType());
                    aggregator.aggregate((Object)airProduct.isEticket());
                    aggregator.aggregate((Object)airProduct.getPenalty());
                    aggregator.aggregate((Object)airProduct.getEndorsement());
                    aggregator.aggregate((Object)airProduct.getFareCalculationData());
                    aggregator.aggregate((Object)airProduct.getBlankType());
                    aggregator.aggregate((Object)airProduct.getCarrier());
                    aggregator.aggregate((Object)airProduct.getCarrierNumber());
                    aggregator.aggregate((Enum)airProduct.getProductCategory());
                    aggregator.aggregate((Enum)airProduct.getTariffType());
                    aggregator.aggregate((Enum)airProduct.getMcoCategory());
                    aggregator.aggregate((Object)travellerName);
                    data.setAggregatedData(aggregator.toString());
                    indexes.add((BaseIndexData<BookingFile, ProductSearchIndex>)data);
                    aggregator.reset();
                }
            }
        }
    }
}

