/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductFopIndex;
import com.gridnine.xtrip.common.model.booking.CommonProductFopIndexData;
import com.gridnine.xtrip.common.model.booking.FopType;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProductVoidingHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductVoidingCommonProductFopIndexHandler
implements IndexHandler<BookingFile, CommonProductFopIndex> {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public Class<? extends BaseIndexData<BookingFile, CommonProductFopIndex>> getDataClass() {
        return CommonProductFopIndexData.class;
    }

    public Class<CommonProductFopIndex> getIndexClass() {
        return CommonProductFopIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public void create(EntityContainer<BookingFile> bookingFileContainer, Collection<BaseIndexData<BookingFile, CommonProductFopIndex>> datas) {
        for (Reservation reservation : ((BookingFile)bookingFileContainer.getEntity()).getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                if (!(baseProduct instanceof ProductVoiding)) continue;
                ProductVoiding product = (ProductVoiding)baseProduct;
                this.addIndeces(datas, product, ContractType.VENDOR);
                this.addIndeces(datas, product, ContractType.SUBAGENCY);
                this.addIndeces(datas, product, ContractType.CLIENT);
            }
        }
    }

    private void addIndeces(Collection<BaseIndexData<BookingFile, CommonProductFopIndex>> datas, ProductVoiding product, ContractType contractType) {
        List fops = null;
        switch (contractType) {
            case VENDOR: {
                fops = ProductVoidingHelper.getVendorFops((ProductVoiding)product);
                break;
            }
            case SUBAGENCY: {
                fops = ProductVoidingHelper.getSubagentFops((ProductVoiding)product, (boolean)false);
                break;
            }
            default: {
                fops = ProductVoidingHelper.getClientFops((ProductVoiding)product);
            }
        }
        for (GeneralProductFop fop : fops) {
            DataAggregator aggregator = new DataAggregator();
            CommonProductFopIndexData data = new CommonProductFopIndexData();
            this.updateProductData(data, aggregator, product);
            this.updateFopData(data, aggregator, fop, product);
            data.setContractType(contractType);
            if (contractType == ContractType.CLIENT) {
                data.setRefuse(Boolean.valueOf(fop.isRefused()));
            }
            data.setAggregatedData(aggregator.toString());
            datas.add((BaseIndexData<BookingFile, CommonProductFopIndex>)data);
        }
    }

    protected void updateProductData(CommonProductFopIndexData data, DataAggregator aggregator, ProductVoiding product) {
        data.setProductUid(product.getUid());
        String bookingNumber = TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile());
        data.setBookingNumber(bookingNumber);
        aggregator.aggregate((Object)bookingNumber);
        data.setProductType(ProductType.MISC_PRODUCT);
        aggregator.aggregate((Enum)ProductType.MISC_PRODUCT);
        data.setClient(product.getReservation().getBookingFile().getCustomerProfile());
        aggregator.aggregate((Object)product.getReservation().getBookingFile().getCustomerProfile());
        if (product.getRelatedProduct() != null) {
            ProductHandler ph = HandlersRegistry.get().findProductHandler(product.getRelatedProduct().getClass());
            EntityReference blankOwner = ph.getBlankOwner(product.getRelatedProduct());
            data.setBlankOwner(blankOwner);
            aggregator.aggregate((Object)blankOwner);
            String blankOwnerCode = null;
            String blankOwnerAirlineNumber = null;
            if (blankOwner != null) {
                try {
                    EntityContainer blankOwnerContainer = EntityStorage.get().resolve(blankOwner);
                    if (blankOwnerContainer != null) {
                        Airline airline = (Airline)DictionaryCache.get().resolveReference(((Organization)blankOwnerContainer.getEntity()).getAirline());
                        if (airline != null) {
                            blankOwnerAirlineNumber = airline.getAirlineNumber();
                        }
                        blankOwnerCode = ((Organization)blankOwnerContainer.getEntity()).getCode();
                    }
                }
                catch (Exception e) {
                    this.log.error("unable to resolve blank owner", (Throwable)e);
                }
            }
            List systemNumbers = ph.getProductNumbers(product.getRelatedProduct());
            data.setSystemNumbers((Collection)systemNumbers);
            aggregator.aggregate((Iterable)systemNumbers);
            data.setBlankOwnerCode(blankOwnerCode);
            aggregator.aggregate(blankOwnerCode);
            data.setBlankOwnerAirlineNumber(blankOwnerAirlineNumber);
            aggregator.aggregate((Object)blankOwnerAirlineNumber);
        }
        EntityReference supplier = ProductVoidingHelper.getSupplier((ProductVoiding)product);
        data.setSupplier(supplier);
        aggregator.aggregate((Object)supplier);
        EntityReference agency = ProductVoidingHelper.getAgency((ProductVoiding)product);
        data.setAgency(agency);
        aggregator.aggregate((Object)agency);
        EntityReference subagency = ProductVoidingHelper.getSubagency((ProductVoiding)product);
        data.setSubagency(subagency);
        aggregator.aggregate((Object)subagency);
        EntityContainer clientContainer = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
        if (clientContainer != null) {
            data.setHolding(((Organization)clientContainer.getEntity()).getHolding());
            aggregator.aggregate((Object)((Organization)clientContainer.getEntity()).getHolding());
        }
        EntityReference agentRef = (EntityReference)ProductVoidingHelper.getRelatedProductValue((ProductVoiding)product, (rp, handler) -> handler.findIssuingAgent(rp));
        data.setAgent(agentRef);
        aggregator.aggregate((Object)agentRef);
        data.setTicketType(TicketType.OWN);
        IndexBuilderHelper.updateReservationGdsNameInfo(product.getReservation(), data, aggregator);
        Date issueDate = (Date)ProductVoidingHelper.getRelatedProductValue((ProductVoiding)product, (rp, handler) -> handler.findIssueDate(rp));
        data.setIssueDate(issueDate);
        data.setIssueDateTime(issueDate);
        data.setUnholdDate(null);
        data.setUnholdDateTime(null);
        data.setStatus(ProductStatus.SELL);
        data.setServiceLocationType(ServiceLocationType.DOMESTIC);
        aggregator.aggregate((Enum)ServiceLocationType.DOMESTIC);
    }

    protected void updateFopData(CommonProductFopIndexData data, DataAggregator aggregator, GeneralProductFop fop, ProductVoiding product) {
        data.setFopUid(fop.getUid());
        FopType fopType = GeneralProductHelper.getFopType((GeneralProductFop)fop);
        data.setFopType(fopType);
        aggregator.aggregate((Enum)fopType);
        data.setPaymentType(fop.getType());
        aggregator.aggregate((Enum)fop.getType());
        BigDecimal equivalentAmount = fop.getEquivalentAmount();
        data.setAmount(equivalentAmount);
        try {
            String currency = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)null);
            data.setCurrency(currency);
            aggregator.aggregate((Object)currency);
        }
        catch (Exception currency) {
            // empty catch block
        }
        CardVendor cardVendor = null;
        String cardNumber = null;
        String cardSecurityCode = null;
        if (fop.getCard() != null) {
            Card card = fop.getCard();
            cardVendor = card.getVendor();
            cardNumber = card.getNumber();
            cardSecurityCode = card.getSecurityCode();
        }
        data.setCardVendor(cardVendor);
        aggregator.aggregate((Enum)cardVendor);
        data.setCardNumber(cardNumber);
        aggregator.aggregate((Object)cardNumber);
        data.setCardSecurityCode(cardSecurityCode);
        aggregator.aggregate((Object)cardSecurityCode);
        data.setRelatedTicketNumber(fop.getRelatedTicketNumber());
        aggregator.aggregate((Object)fop.getRelatedTicketNumber());
        data.setFopAgent(fop.getAgent());
        aggregator.aggregate((Object)fop.getAgent());
        data.setFopDate(fop.getOperationDate());
        data.setHasComments(Boolean.valueOf(!TextUtil.isBlank((String)product.getReservation().getBookingFile().getNotes())));
    }
}

