/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.CommonProductIndexData;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.ProfileGroupReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProductVoidingHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.handlers.ServerHandlersRegistry;
import com.gridnine.xtrip.server.model.handlers.index.CommonIndexHandler;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import com.gridnine.xtrip.server.model.index.BaseCommonProductIndexHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductVoidingCommonProductIndexHandler
extends BaseCommonProductIndexHandler
implements IndexHandler<BookingFile, CommonProductIndex> {
    Logger log = LoggerFactory.getLogger(this.getClass());

    public Class<? extends BaseIndexData<BookingFile, CommonProductIndex>> getDataClass() {
        return CommonProductIndexData.class;
    }

    public Class<CommonProductIndex> getIndexClass() {
        return CommonProductIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public void create(EntityContainer<BookingFile> etc, Collection<BaseIndexData<BookingFile, CommonProductIndex>> indexes) {
        DataAggregator aggregator = new DataAggregator();
        for (Reservation reservation : ((BookingFile)etc.getEntity()).getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                if (!(baseProduct instanceof ProductVoiding)) continue;
                aggregator.reset();
                try {
                    CommonProductIndexData data = new CommonProductIndexData();
                    List handlers = ServerHandlersRegistry.get().findCommonIndexHandlers(this.getIndexClass());
                    for (CommonIndexHandler<BaseProduct, BookingFile, CommonProductIndex> commonIndexHandler : handlers) {
                        commonIndexHandler.updateData((BaseIndexData<BookingFile, CommonProductIndex>)data, aggregator, etc, baseProduct);
                    }
                    this.updateData(data, aggregator, etc, (ProductVoiding)baseProduct);
                    data.setAggregatedData(aggregator.toString());
                    indexes.add((BaseIndexData<BookingFile, CommonProductIndex>)data);
                }
                catch (Exception e) {
                    this.log.error("unable to create index", (Throwable)e);
                }
            }
        }
    }

    protected void updateData(CommonProductIndexData data, DataAggregator aggregator, EntityContainer<BookingFile> etc, ProductVoiding product) throws Exception {
        data.setNavigationKey(product.getUid());
        data.setReservationType(product.getReservation().getType());
        data.setBookingNumber(TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile()));
        aggregator.aggregate((Object)TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile()));
        data.setBookingCreateDate(product.getReservation().getBookingFile().getCreateDate());
        aggregator.aggregate(product.getReservation().getBookingFile().getCreateDate());
        EntityReference agency = ProductVoidingHelper.getAgency((ProductVoiding)product);
        data.setAgency(agency);
        aggregator.aggregate((Object)agency);
        EntityReference supplier = ProductVoidingHelper.getSupplier((ProductVoiding)product);
        data.setSupplier(supplier);
        aggregator.aggregate((Object)supplier);
        data.setTimeLimit(product.getReservation().getTimeLimit());
        aggregator.aggregate(product.getReservation().getTimeLimit());
        data.setServiceLocationType(ServiceLocationType.DOMESTIC);
        aggregator.aggregate((Enum)ServiceLocationType.DOMESTIC);
        data.setAgentPenaltyForService(BigDecimal.ZERO);
        data.setAgentPenaltyForFees(BigDecimal.ZERO);
        String militaryClaimNumber = GeneralProductHelper.getMilitaryClaimNumber((BaseProduct)product);
        data.setMilitaryClaimNumber(militaryClaimNumber);
        aggregator.aggregate((Object)militaryClaimNumber);
        data.setTicketType(product.getTicketType());
        aggregator.aggregate((Enum)product.getTicketType());
        ArrayList systemNumbers = new ArrayList();
        data.setSystemNumbers(systemNumbers);
        aggregator.aggregate(systemNumbers);
        data.setFirstSystemNumber((String)CollectionUtil.head(systemNumbers));
        ArrayList scns = new ArrayList();
        data.setSncs(scns);
        aggregator.aggregate(scns);
        data.setClient(product.getReservation().getBookingFile().getCustomerProfile());
        EntityReference clientRelationMediator = GeneralProductHelper.getClientRelationMediator((BaseProduct)product);
        data.setMediator(clientRelationMediator);
        aggregator.aggregate((Object)clientRelationMediator);
        aggregator.aggregate((Object)product.getReservation().getBookingFile().getCustomerProfile());
        try {
            EntityContainer client = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
            if (client != null) {
                String code = SystemHelper.findMetadataAsString((Collection)((Organization)client.getEntity()).getMetadata(), (MetadataKey)MetadataKey.KEY_ACCOUNTING_SYSTEM_CODE);
                code = code != null ? code : ((Organization)client.getEntity()).getCode();
                data.setClientAccountingCode(code);
                aggregator.aggregate((Object)code);
                ArrayList<ProfileGroupReference> clientGroups = new ArrayList<ProfileGroupReference>();
                for (Metadata metadata : ((Organization)client.getEntity()).getMetadata()) {
                    if (metadata.getKey() == null || !metadata.getKey().getCode().equals(MetadataKey.KEY_ORGANIZATION_PROFILE_GROUP.name()) || metadata.getValue() == null) continue;
                    clientGroups.add((ProfileGroupReference)metadata.getValue());
                }
                data.setClientGroups(clientGroups);
                aggregator.aggregate(clientGroups);
            }
        }
        catch (Throwable e) {
            this.log.error("unable to load profile " + product.getReservation().getBookingFile().getCustomerProfile(), e);
        }
        EntityReference subagency = ProductVoidingHelper.getSubagency((ProductVoiding)product);
        data.setSubagency(subagency);
        aggregator.aggregate((Object)subagency);
        EntityContainer clientContainer = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
        if (clientContainer != null) {
            data.setHolding(((Organization)clientContainer.getEntity()).getHolding());
            aggregator.aggregate((Object)((Organization)clientContainer.getEntity()).getHolding());
        }
        data.setEticket(Boolean.valueOf(false));
        Date refuseDate = null;
        for (GeneralProductFop fop2 : ProductVoidingHelper.getClientFops((ProductVoiding)product)) {
            if (!fop2.isRefused() || fop2.getOperationDate() == null || refuseDate != null && !refuseDate.after(fop2.getOperationDate())) continue;
            refuseDate = fop2.getOperationDate();
        }
        if (refuseDate != null) {
            data.setCancellationDate(refuseDate);
            aggregator.aggregate(refuseDate);
        }
        BigDecimal equivalentFare = BigDecimal.ZERO;
        aggregator.aggregate((Object)equivalentFare);
        HashSet passportNumbers = new HashSet();
        HashSet travellersNames = new HashSet();
        HashSet passengers = new HashSet();
        data.setTravellersPassportsNumbers(passportNumbers);
        data.setTravellersNames(travellersNames);
        data.setPassengers(passengers);
        aggregator.aggregate(passportNumbers);
        aggregator.aggregate(travellersNames);
        data.setWorkflowStatus(product.getReservation().getBookingFile().getWorkflowStatus());
        aggregator.aggregate((Enum)product.getReservation().getBookingFile().getWorkflowStatus());
        data.setReservationStatus(product.getReservation().getStatus());
        aggregator.aggregate((Enum)product.getReservation().getStatus());
        ProductStatus productStatus = GeneralProductHelper.getStatus((BaseProduct)product);
        data.setStatus(productStatus);
        aggregator.aggregate((Enum)productStatus);
        aggregator.aggregate((Enum)ProductType.PRODUCT_VOIDING);
        data.setProductType(ProductType.PRODUCT_VOIDING);
        data.setDescription(ProductType.PRODUCT_VOIDING.toString());
        data.setIncludeVat(Boolean.valueOf(true));
        data.setValid(Boolean.valueOf(true));
        data.setHasOtherErrors(Boolean.valueOf(false));
        data.setHasStockControlErrors(Boolean.valueOf(false));
        data.setHasRulesErrors(Boolean.valueOf(false));
        data.setHasShipmentErrors(Boolean.valueOf(false));
        data.setHasErrors(Boolean.valueOf(false));
        for (ValidationMessage message : product.getValidationMessages()) {
            if (message.getSeverity() == ValidationMessageSeverity.WARNING) {
                data.setHasWarnings(Boolean.valueOf(true));
            }
            if (message.getSeverity() == ValidationMessageSeverity.USER_ERROR) {
                data.setHasUserErrors(Boolean.valueOf(true));
                data.setHasErrors(Boolean.valueOf(true));
            }
            if (message.getSeverity() == ValidationMessageSeverity.SHIPMENT_ERROR) {
                data.setHasShipmentErrors(Boolean.valueOf(true));
            }
            if (message.getSeverity() != ValidationMessageSeverity.ERROR) continue;
            data.setHasErrors(Boolean.valueOf(true));
            if (message.getCategory() == ValidationMessageCategory.OTHER) {
                data.setValid(Boolean.valueOf(false));
                data.setHasOtherErrors(Boolean.valueOf(true));
            }
            if (message.getCategory() == ValidationMessageCategory.STOCK_CONTROL) {
                data.setHasStockControlErrors(Boolean.valueOf(true));
            }
            if (message.getCategory() != ValidationMessageCategory.RULES) continue;
            data.setHasRulesErrors(Boolean.valueOf(true));
        }
        data.setFirstTravelDate(null);
        data.setLastTravelDate(null);
        data.setTaxesSum(BigDecimal.ZERO);
        data.setTaxesForBlankSum(BigDecimal.ZERO);
        data.setOtherTaxesSum(BigDecimal.ZERO);
        CardVendor creditCardVendor = GeneralProductHelper.getCreditCardVendor((Collection)ProductVoidingHelper.getClientFops((ProductVoiding)product));
        data.setClientCardVendor(creditCardVendor);
        aggregator.aggregate((Enum)creditCardVendor);
        creditCardVendor = GeneralProductHelper.getCreditCardVendor((Collection)ProductVoidingHelper.getVendorFops((ProductVoiding)product));
        data.setSupplierCardVendor(creditCardVendor);
        aggregator.aggregate((Enum)creditCardVendor);
        VatAmount price = BookingHelper.calculateProductPrice((BaseProduct)product, (ContractType)ContractType.CLIENT);
        BigDecimal totalSum = price.getTotal();
        data.setTotalSum(totalSum);
        aggregator.aggregate((Object)totalSum);
        data.setVatRate(price.getVat());
        data.setVatValue(price.getVatAmount());
        try {
            data.setVendorCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)ProductVoidingHelper.getUnmodifiableCommissions((ProductVoiding)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)false));
            data.setVendorBonusValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)ProductVoidingHelper.getUnmodifiableCommissions((ProductVoiding)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)false));
            data.setVendorFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)ProductVoidingHelper.getUnmodifiableCommissions((ProductVoiding)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)false));
            data.setVendorCommissionRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)ProductVoidingHelper.getUnmodifiableCommissions((ProductVoiding)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)false));
            data.setVendorBonusRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)ProductVoidingHelper.getUnmodifiableCommissions((ProductVoiding)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true));
            data.setVendorFeeRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)ProductVoidingHelper.getUnmodifiableCommissions((ProductVoiding)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true));
            data.setSubagencyCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)ProductVoidingHelper.getUnmodifiableCommissions((ProductVoiding)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)false));
            data.setSubagencyBonusValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)ProductVoidingHelper.getUnmodifiableCommissions((ProductVoiding)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)false));
            data.setSubagencyFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)ProductVoidingHelper.getUnmodifiableCommissions((ProductVoiding)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)false));
            data.setSubagencyHiddenFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)ProductVoidingHelper.getUnmodifiableCommissions((ProductVoiding)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, (Set)GeneralProductHelper.hiddenCommissionCategories)), (boolean)false));
            data.setSubagencyCommissionRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)ProductVoidingHelper.getUnmodifiableCommissions((ProductVoiding)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)false));
            data.setSubagencyBonusRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)ProductVoidingHelper.getUnmodifiableCommissions((ProductVoiding)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true));
            data.setSubagencyFeeRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)ProductVoidingHelper.getUnmodifiableCommissions((ProductVoiding)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true));
            data.setClientCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)ProductVoidingHelper.getUnmodifiableCommissions((ProductVoiding)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)false));
            data.setClientBonusValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)ProductVoidingHelper.getUnmodifiableCommissions((ProductVoiding)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)false));
            data.setClientFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)ProductVoidingHelper.getUnmodifiableCommissions((ProductVoiding)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)false));
            data.setClientServiceFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)ProductVoidingHelper.getUnmodifiableCommissions((ProductVoiding)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.serviceFeePropertyTypes, null, null)), (boolean)false));
            data.setClientPaymentFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)ProductVoidingHelper.getUnmodifiableCommissions((ProductVoiding)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.paymentFeePropertyTypes, null, null)), (boolean)false));
            data.setClientCommissionRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)ProductVoidingHelper.getUnmodifiableCommissions((ProductVoiding)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true));
            data.setClientBonusRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)ProductVoidingHelper.getUnmodifiableCommissions((ProductVoiding)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true));
            data.setClientFeeRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)ProductVoidingHelper.getUnmodifiableCommissions((ProductVoiding)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true));
        }
        catch (Exception e) {
            this.log.error("failed calculating commissions ", (Throwable)e);
        }
        Date date = null;
        EntityReference agent = null;
        boolean hasClientDebt = false;
        HashSet<PaymentType> clientFopTypes = new HashSet<PaymentType>();
        HashSet<PaymentType> clientFeesFopTypes = new HashSet<PaymentType>();
        BigDecimal clientFOPAmount = null;
        BigDecimal clientFOPAddAmount = null;
        BigDecimal clientFOPTotalAddAmount = null;
        EnumSet<PaymentType> addPaymentTypes = EnumSet.allOf(PaymentType.class);
        addPaymentTypes.remove(PaymentType.TICKET);
        addPaymentTypes.remove(PaymentType.VOUCHER);
        addPaymentTypes.remove(PaymentType.MTD);
        addPaymentTypes.remove(PaymentType.MTD_AGENCY);
        addPaymentTypes.remove(PaymentType.CREDIT);
        addPaymentTypes.remove(PaymentType.CREDIT_CARD);
        for (GeneralProductFop fop3 : ProductVoidingHelper.getClientFops((ProductVoiding)product)) {
            if (fop3.getEquivalentAmount() != null) {
                BigDecimal bigDecimal = clientFOPAmount = clientFOPAmount != null ? clientFOPAmount.add(fop3.getEquivalentAmount()) : fop3.getEquivalentAmount();
            }
            if (fop3.getEquivalentAmount() != null && addPaymentTypes.contains(fop3.getType()) && GeneralProductHelper.productFopTypes.contains(GeneralProductHelper.getFopType((GeneralProductFop)fop3))) {
                BigDecimal bigDecimal = clientFOPAddAmount = clientFOPAddAmount != null ? clientFOPAddAmount.add(fop3.getEquivalentAmount()) : fop3.getEquivalentAmount();
            }
            if (fop3.getEquivalentAmount() != null && addPaymentTypes.contains(fop3.getType()) && !GeneralProductHelper.discountFopTypes.contains(GeneralProductHelper.getFopType((GeneralProductFop)fop3))) {
                BigDecimal bigDecimal = clientFOPTotalAddAmount = clientFOPTotalAddAmount != null ? clientFOPTotalAddAmount.add(fop3.getEquivalentAmount()) : fop3.getEquivalentAmount();
            }
            if (fop3.getType() != null) {
                if (GeneralProductHelper.isServiceFop((GeneralProductFop)fop3)) {
                    clientFopTypes.add(fop3.getType());
                } else {
                    clientFeesFopTypes.add(fop3.getType());
                }
            }
            if (fop3.getOperationDate() == null) {
                hasClientDebt = true;
                continue;
            }
            if (date != null && !date.before(fop3.getOperationDate())) continue;
            date = fop3.getOperationDate();
            agent = fop3.getAgent();
        }
        data.setClientFopAmount(clientFOPAmount);
        aggregator.aggregate(clientFOPAmount);
        data.setClientFopAddAmount(clientFOPAddAmount);
        aggregator.aggregate(clientFOPAddAmount);
        data.setClientFopTotalAddAmount(clientFOPTotalAddAmount);
        aggregator.aggregate(clientFOPTotalAddAmount);
        data.setClientFopTypes(clientFopTypes);
        aggregator.aggregate(clientFopTypes);
        data.setClientFeesFopTypes(clientFeesFopTypes);
        aggregator.aggregate(clientFeesFopTypes);
        data.setDateOfClientPayment(date);
        aggregator.aggregate(date);
        data.setClientFopAgent(agent);
        aggregator.aggregate((Object)agent);
        data.setHasClientDebt(Boolean.valueOf(hasClientDebt));
        HashSet<PaymentType> vendorFopTypes = new HashSet<PaymentType>();
        BigDecimal vendorFOPAmount = null;
        date = null;
        for (GeneralProductFop fop4 : ProductVoidingHelper.getVendorFops((ProductVoiding)product)) {
            if (fop4.getEquivalentAmount() != null) {
                BigDecimal bigDecimal = vendorFOPAmount = vendorFOPAmount != null ? vendorFOPAmount.add(fop4.getEquivalentAmount()) : fop4.getEquivalentAmount();
            }
            if (fop4.getType() != null) {
                vendorFopTypes.add(fop4.getType());
            }
            if (fop4.getOperationDate() == null || date != null && !date.before(fop4.getOperationDate())) continue;
            date = fop4.getOperationDate();
        }
        data.setVendorFopAmount(vendorFOPAmount);
        aggregator.aggregate(vendorFOPAmount);
        data.setDateOfVendorPayment(date);
        aggregator.aggregate(date);
        data.setVendorFopTypes(vendorFopTypes);
        aggregator.aggregate(vendorFopTypes);
        HashSet<PaymentType> subagentFopTypes = new HashSet<PaymentType>();
        HashSet<PaymentType> subagentFeesFopTypes = new HashSet<PaymentType>();
        List subagentFops = ProductVoidingHelper.getSubagentFops((ProductVoiding)product, (boolean)false);
        if (subagentFops != null) {
            for (GeneralProductFop fop5 : subagentFops) {
                if (fop5.getType() == null) continue;
                if (GeneralProductHelper.isServiceFop((GeneralProductFop)fop5)) {
                    subagentFopTypes.add(fop5.getType());
                    continue;
                }
                subagentFeesFopTypes.add(fop5.getType());
            }
        }
        data.setSubagencyContractTotalSum(BookingHelper.calculateProductPrice((BaseProduct)product, (ContractType)ContractType.SUBAGENCY).getTotal());
        data.setSubagentFopTypes(subagentFopTypes);
        data.setSubagentFeesFopTypes(subagentFeesFopTypes);
        data.setAgentPenaltyForService(BookingHelper.calculateAgentPenaltyForProduct((BaseProduct)product));
        data.setAgentPenaltyForCommissions(null);
        data.setAgentPenaltyForFees(BookingHelper.calculateAgentPenaltyForFees((BaseProduct)product));
        data.setPayers((Collection)GeneralProductHelper.getClientFops((BaseProduct)product).stream().filter(fop -> fop.getPayer() != null).map(fop -> fop.getPayer()).collect(Collectors.toSet()));
        String notes = product.getReservation().getBookingFile().getNotes();
        data.setHasNotes(Boolean.valueOf(notes != null && !notes.trim().isEmpty()));
        boolean inFinanceDocuments = IndexBuilderHelper.isInFinanceDocuments((BaseProduct)product);
        data.setInFinanceDocuments(Boolean.valueOf(inFinanceDocuments));
        boolean inDelivery = IndexBuilderHelper.isInDelivery((BaseProduct)product);
        data.setInDelivery(Boolean.valueOf(inDelivery));
        StringBuilder email = new StringBuilder();
        if (product.getReservation().getBookingFile() != null && product.getReservation().getBookingFile().getCustomer() != null) {
            for (Communication c : product.getReservation().getBookingFile().getCustomer().getCommunications()) {
                if (c == null || !CommunicationType.EMAIL.equals((Object)c.getType()) || TextUtil.isBlank((String)c.getSense())) continue;
                email = email.append(email.length() > 0 ? ", " + c.getSense() : c.getSense());
            }
        }
        if (!TextUtil.isBlank((String)email.toString())) {
            data.setEmail(email.toString());
            aggregator.aggregate((Object)email.toString());
        }
        Set shipments = product.getFopDetalizations().values().stream().flatMap(item -> item.getComponents().stream()).filter(item -> item.getShipment() != null).map(item -> item.getShipment()).collect(Collectors.toSet());
        data.setShipments(shipments);
        aggregator.aggregate(shipments);
        data.setShipmentsDate(product.getShipmentsDate());
        data.setShipmentsDateSubagent(product.getShipmentsDateSubagent());
        data.setFopComponentsAllUsed(Boolean.valueOf(product.getFopDetalizations().values().stream().flatMap(item -> item.getComponents().stream()).allMatch(item -> item.getShipment() != null)));
        EntityReference clientPrepaymentDocument = null;
        EntityReference subagentPrepaymentDocument = null;
        for (EntityReference prepaymentDocumentReference : product.getPrepaymentDocuments()) {
            EntityContainer contract;
            EntityContainer prepaymentDocument = EntityStorage.get().resolve(prepaymentDocumentReference);
            if (prepaymentDocument == null || (contract = EntityStorage.get().resolve(((FinanceDocument)prepaymentDocument.getEntity()).getContract())) == null) continue;
            if (((Contract)contract.getEntity()).getContractType() == ContractType.CLIENT) {
                clientPrepaymentDocument = prepaymentDocumentReference;
                continue;
            }
            if (((Contract)contract.getEntity()).getContractType() != ContractType.SUBAGENCY) continue;
            subagentPrepaymentDocument = prepaymentDocumentReference;
        }
        data.setClientPrepaymentDocument(clientPrepaymentDocument);
        data.setSubagentPrepaymentDocument(subagentPrepaymentDocument);
        aggregator.aggregate(clientPrepaymentDocument);
        aggregator.aggregate(subagentPrepaymentDocument);
        Set receipts = product.getFopDetalizations().values().stream().flatMap(fopDetalization -> fopDetalization.getComponents().stream()).map(FopComponent::getReceipt).collect(Collectors.toSet());
        data.setReceipts(receipts);
        Set travellersGroups = GeneralProductHelper.getHandler((BaseProduct)product).getTravellers((BaseProduct)product).stream().map(item -> EntityStorage.get().resolve(item.getPassenger())).filter(item -> item != null).flatMap(item -> ((Person)item.getEntity()).getMetadata().stream()).filter(item -> item.getKey() != null && item.getValue() != null && MiscUtil.equals((Object)item.getKey().getCode(), (Object)MetadataKey.KEY_PERSON_PROFILE_GROUP.name())).map(item -> (ProfileGroupReference)item.getValue()).collect(Collectors.toSet());
        data.setTravellersGroups(travellersGroups);
        aggregator.aggregate(travellersGroups);
        Set agentsGroups = Optional.ofNullable(EntityStorage.get().resolve(GeneralProductHelper.getHandler((BaseProduct)product).findIssuingAgent((BaseProduct)product))).map(item -> ((Person)item.getEntity()).getMetadata()).orElse(Collections.emptyList()).stream().filter(item -> item.getKey() != null && item.getValue() != null && MiscUtil.equals((Object)item.getKey().getCode(), (Object)MetadataKey.KEY_PERSON_PROFILE_GROUP.name())).map(item -> (ProfileGroupReference)item.getValue()).collect(Collectors.toSet());
        data.setAgentsGroups(agentsGroups);
        aggregator.aggregate(agentsGroups);
        data.setAggregator(aggregator);
        this.updateStatisticalData(data, product.getStatisticalData(), (EntityReference<Organization>)product.getReservation().getBookingFile().getCustomerProfile());
        data.setAggregator(null);
    }
}

