/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.fiscal.Receipt;
import com.gridnine.xtrip.common.model.fiscal.ReceiptDataType;
import com.gridnine.xtrip.common.model.fiscal.ReceiptIndex;
import com.gridnine.xtrip.common.model.fiscal.ReceiptIndexData;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLine;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLineType;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.index.ReceiptStorageProcessing;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ReceiptIndexHandler
implements IndexHandler<Receipt, ReceiptIndex> {
    public Class<? extends BaseIndexData<Receipt, ReceiptIndex>> getDataClass() {
        return ReceiptIndexData.class;
    }

    public Class<ReceiptIndex> getIndexClass() {
        return ReceiptIndex.class;
    }

    public Class<Receipt> getEntityType() {
        return Receipt.class;
    }

    public void create(EntityContainer<Receipt> receiptCtr, Collection<BaseIndexData<Receipt, ReceiptIndex>> indexes) throws Exception {
        ReceiptIndexData receiptIndexData = new ReceiptIndexData();
        DataAggregator dataAggregator = new DataAggregator();
        receiptIndexData.setAggregator(dataAggregator);
        Receipt receipt = (Receipt)receiptCtr.getEntity();
        receiptIndexData.setFullNumber(TextUtil.buildFullNumber((CompositeNumber)receipt));
        dataAggregator.aggregate((Object)TextUtil.buildFullNumber((CompositeNumber)receipt));
        receiptIndexData.setServiceType(receipt.getServiceType());
        dataAggregator.aggregate((Enum)receipt.getServiceType());
        receiptIndexData.setStatus(receipt.getStatus());
        dataAggregator.aggregate((Enum)receipt.getStatus());
        receiptIndexData.setOwner(receipt.getOwner());
        dataAggregator.aggregate((Object)receipt.getOwner());
        receiptIndexData.setDescription(receipt.getDescription());
        dataAggregator.aggregate((Object)receipt.getDescription());
        receiptIndexData.setCreated(receipt.getCreated());
        receiptIndexData.setUpdated(receipt.getUpdated());
        receiptIndexData.setPaymentId(receipt.getPaymentId());
        if (receipt.getReceiptData() != null) {
            receiptIndexData.setType(receipt.getReceiptData().getType());
            receiptIndexData.setDataTypes((Collection)receipt.getReceiptData().getItems().stream().map(ReceiptLine::getLineType).filter(Objects::nonNull).map(this::convertLineType2DataType).collect(Collectors.toSet()));
            receiptIndexData.setProductUids((Collection)receipt.getReceiptData().getItems().stream().map(ReceiptLine::getProductReference).filter(Objects::nonNull).distinct().map(NestedEntityReference::getNestedEntityUid).filter(Objects::nonNull).collect(Collectors.toList()));
            receiptIndexData.setTotalSum(receipt.getReceiptData().getItems().stream().map(ReceiptLine::getTotal).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(BigDecimal.ZERO));
            EntityStorageContext storageContext = new EntityStorageContext();
            List productNumbers = receipt.getReceiptData().getItems().stream().map(ReceiptLine::getProductReference).filter(Objects::nonNull).distinct().map(product -> (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)product, (EntityStorageContext)storageContext)).filter(Objects::nonNull).map(GeneralProductHelper::getSystemNumber).filter(Objects::nonNull).collect(Collectors.toList());
            receiptIndexData.setProductNumbers(productNumbers);
            dataAggregator.aggregate(productNumbers);
        }
        for (ReceiptStorageProcessing.ReceiptIndexHandlerPostProcess indexHandlerPostProcess : ReceiptStorageProcessing.getInstance().getIndexHandlerPostProcesses()) {
            indexHandlerPostProcess.processing(receipt, receiptIndexData, dataAggregator);
        }
        receiptIndexData.setAggregatedData(dataAggregator.toString());
        indexes.add((BaseIndexData<Receipt, ReceiptIndex>)receiptIndexData);
    }

    private ReceiptDataType convertLineType2DataType(ReceiptLineType lineType) {
        switch (lineType) {
            case PRODUCT: 
            case TAX: {
                return ReceiptDataType.PRODUCT;
            }
            case FEES: {
                return ReceiptDataType.FEES;
            }
            case PENALTY: {
                return ReceiptDataType.PENALTY;
            }
            case SERVICE: {
                return ReceiptDataType.SERVICE;
            }
        }
        return ReceiptDataType.PRODUCT;
    }
}

