/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.rules.RulesMigrationSettings;
import com.gridnine.xtrip.common.model.rules.RulesMigrationSettingsIndex;
import com.gridnine.xtrip.common.model.rules.RulesMigrationSettingsIndexData;
import com.gridnine.xtrip.common.model.rules.RulesMigrationSourceContractData;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Collectors;

public class RulesMigrationSettingsIndexHandler
implements IndexHandler<RulesMigrationSettings, RulesMigrationSettingsIndex> {
    public Class<? extends BaseIndexData<RulesMigrationSettings, RulesMigrationSettingsIndex>> getDataClass() {
        return RulesMigrationSettingsIndexData.class;
    }

    public Class<RulesMigrationSettingsIndex> getIndexClass() {
        return RulesMigrationSettingsIndex.class;
    }

    public Class<RulesMigrationSettings> getEntityType() {
        return RulesMigrationSettings.class;
    }

    public void create(EntityContainer<RulesMigrationSettings> etc, Collection<BaseIndexData<RulesMigrationSettings, RulesMigrationSettingsIndex>> indexes) {
        RulesMigrationSettingsIndexData data = new RulesMigrationSettingsIndexData();
        RulesMigrationSettings entity = (RulesMigrationSettings)etc.getEntity();
        data.setNavigationKey(entity.getUid());
        data.setName(entity.getName());
        data.setStartDate(entity.getStartDate());
        data.setEndDate(entity.getEndDate());
        DataAggregator aggregator = new DataAggregator();
        if (!entity.getSourceContractItems().isEmpty()) {
            Iterator iterator = entity.getSourceContractItems().iterator();
            if (iterator.hasNext()) {
                RulesMigrationSourceContractData item = (RulesMigrationSourceContractData)iterator.next();
                data.setSourceContract(item.getSourceContract());
                aggregator.aggregate((Object)item);
            }
            data.setSourceContracts((Collection)entity.getSourceContractItems().stream().map(RulesMigrationSourceContractData::getSourceContract).filter(Objects::nonNull).collect(Collectors.toList()));
        } else {
            Iterator iterator = entity.getSourceContracts().iterator();
            if (iterator.hasNext()) {
                EntityReference item = (EntityReference)iterator.next();
                data.setSourceContract(item);
                aggregator.aggregate((Object)item);
            }
            data.setSourceContracts((Collection)entity.getSourceContracts());
        }
        data.setTargetContract(entity.getTargetContract());
        aggregator.aggregate((Object)entity.getName());
        aggregator.aggregate((Object)entity.getTargetContract());
        data.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<RulesMigrationSettings, RulesMigrationSettingsIndex>)data);
    }
}

