/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.CommunicationFormat;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.SalesPointIndex;
import com.gridnine.xtrip.common.model.profile.SalesPointIndexData;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;

public class SalesPointIndexHandler
implements IndexHandler<SalesPoint, SalesPointIndex> {
    public Class<? extends BaseIndexData<SalesPoint, SalesPointIndex>> getDataClass() {
        return SalesPointIndexData.class;
    }

    public Class<SalesPointIndex> getIndexClass() {
        return SalesPointIndex.class;
    }

    public Class<SalesPoint> getEntityType() {
        return SalesPoint.class;
    }

    public void create(EntityContainer<SalesPoint> etc, Collection<BaseIndexData<SalesPoint, SalesPointIndex>> indexes) {
        SalesPointIndexData data = new SalesPointIndexData();
        DataAggregator aggregator = new DataAggregator();
        this.updateData(data, aggregator, etc);
        data.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<SalesPoint, SalesPointIndex>)data);
    }

    protected void updateData(SalesPointIndexData data, DataAggregator aggregator, EntityContainer<SalesPoint> etc) {
        SalesPoint entity = (SalesPoint)etc.getEntity();
        data.setDisabled(Boolean.valueOf(entity.isDisabled()));
        data.setCode(entity.getCode());
        ArrayList<String> validators = new ArrayList<String>();
        for (Validator validator : entity.getValidators()) {
            validators.add(validator.getNumber());
        }
        data.setValidators(validators);
        ArrayList<String> pccs = new ArrayList<String>();
        HashSet terminals = new HashSet();
        for (Pcc pcc : entity.getPccs()) {
            pccs.add(pcc.getCode());
            terminals.addAll(pcc.getTerminalNames());
        }
        data.setPccs(pccs);
        data.setPointOfSaleGroup((DictionaryReference)SystemHelper.getMetadata((Collection)entity.getMetadata(), (MetadataKey)MetadataKey.POINT_OF_SALE));
        data.setTerminals(terminals);
        data.setAgency(entity.getAgency());
        data.setBranch(entity.getBranch());
        data.setPreferredLocale(entity.getPreferredLocale());
        ArrayList<String> communications = new ArrayList<String>();
        for (Communication communication : entity.getCommunications()) {
            if (TextUtil.isBlank((String)communication.getSense())) continue;
            CommunicationFormat phoneFormat = new CommunicationFormat("+C (T) N #I");
            CommunicationFormat emailFormat = new CommunicationFormat("N");
            CommunicationFormat webFormat = new CommunicationFormat("N");
            String communicationString = null;
            if (communication.getType() == null) {
                communicationString = phoneFormat.format(communication);
            } else {
                switch (communication.getType()) {
                    case WORK_PHONE: 
                    case HOME_PHONE: 
                    case FAX: 
                    case MOBILE: 
                    case AGENCY: 
                    case HOTEL: 
                    case CELL: 
                    case EMERGENCY: {
                        communicationString = phoneFormat.format(communication);
                        break;
                    }
                    case EMAIL: {
                        communicationString = emailFormat.format(communication);
                        break;
                    }
                    case WEB: {
                        communicationString = webFormat.format(communication);
                        break;
                    }
                    default: {
                        communicationString = phoneFormat.format(communication);
                    }
                }
            }
            if (communicationString == null) continue;
            communications.add(communication.getType() != null ? communication.getType() + ": " + communicationString : communicationString);
        }
        data.setCommunications(communications);
        data.setAddressFactual(ProfileHelper.buildFullAddress((Address)ProfileHelper.filterAddresses((Collection)entity.getAddresses(), (AddressType)AddressType.FACTUAL), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        data.setAddressContact(ProfileHelper.buildFullAddress((Address)ProfileHelper.filterAddresses((Collection)entity.getAddresses(), (AddressType)AddressType.CONTACT), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        data.setName(entity.getFullName());
        data.setShortName(entity.getShortName());
        data.setFullName(entity.getFullName());
        data.setType(entity.getType());
        aggregator.aggregate((Object)entity.getCode());
        aggregator.aggregate((Object)entity.getFullName());
        aggregator.aggregate((Object)entity.getShortName());
        aggregator.aggregate(validators);
        aggregator.aggregate(pccs);
        aggregator.aggregate(terminals);
        aggregator.aggregate((Object)entity.getAgency());
        aggregator.aggregate((Object)entity.getBranch());
        aggregator.aggregate((Object)entity.getPreferredLocale());
        aggregator.aggregate((Enum)entity.getType());
    }
}

